/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.channel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.allocation.ArenaMemoryAllocator;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.channel.ComposingWritableFrameChannel;
import org.apache.druid.frame.channel.FrameWithPartition;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.OutputChannel;
import org.apache.druid.query.ResourceLimitExceededException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.mockito.Mockito;

public class ComposingWritableFrameChannelTest {
    @Test
    public void testComposingWritableChannelSwitchesProperly() throws IOException {
        LimitedWritableFrameChannel writableFrameChannel1 = new LimitedWritableFrameChannel(2);
        LimitedWritableFrameChannel writableFrameChannel2 = new LimitedWritableFrameChannel(100);
        Supplier<ReadableFrameChannel> readableFrameChannelSupplier1 = () -> null;
        Supplier<ReadableFrameChannel> readableFrameChannelSupplier2 = () -> null;
        OutputChannel outputChannel1 = OutputChannel.pair((WritableFrameChannel)writableFrameChannel1, (MemoryAllocator)ArenaMemoryAllocator.createOnHeap((int)1), readableFrameChannelSupplier1, (int)1);
        OutputChannel outputChannel2 = OutputChannel.pair((WritableFrameChannel)writableFrameChannel2, (MemoryAllocator)ArenaMemoryAllocator.createOnHeap((int)1), readableFrameChannelSupplier2, (int)2);
        HashMap partitionToChannelMap = new HashMap();
        ComposingWritableFrameChannel composingWritableFrameChannel = new ComposingWritableFrameChannel(null, (List)ImmutableList.of(() -> outputChannel1, () -> outputChannel2), null, (List)ImmutableList.of(() -> writableFrameChannel1, () -> writableFrameChannel2), partitionToChannelMap);
        composingWritableFrameChannel.write(new FrameWithPartition((Frame)Mockito.mock(Frame.class), 1));
        composingWritableFrameChannel.write(new FrameWithPartition((Frame)Mockito.mock(Frame.class), 2));
        composingWritableFrameChannel.write(new FrameWithPartition((Frame)Mockito.mock(Frame.class), 3));
        Assert.assertEquals((Object)ImmutableSet.of((Object)0), partitionToChannelMap.get(1));
        Assert.assertEquals((Object)ImmutableSet.of((Object)0), partitionToChannelMap.get(2));
        Assert.assertEquals((Object)ImmutableSet.of((Object)1), partitionToChannelMap.get(3));
        Assert.assertThrows(DruidException.class, () -> ((OutputChannel)outputChannel1).getWritableChannel());
        composingWritableFrameChannel.close();
        Exception ise1 = (Exception)Assert.assertThrows(DruidException.class, () -> ((OutputChannel)outputChannel1).getFrameMemoryAllocator());
        MatcherAssert.assertThat((Object)ise1, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.startsWith((String)"Frame memory allocator is not available.")));
        Exception ise2 = (Exception)Assert.assertThrows(DruidException.class, () -> ((OutputChannel)outputChannel2).getFrameMemoryAllocator());
        MatcherAssert.assertThat((Object)ise2, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.startsWith((String)"Frame memory allocator is not available.")));
    }

    static class LimitedWritableFrameChannel
    implements WritableFrameChannel {
        private final int maxFrames;
        private int curFrame = 0;

        public LimitedWritableFrameChannel(int maxFrames) {
            this.maxFrames = maxFrames;
        }

        public void write(FrameWithPartition frameWithPartition) {
            if (this.curFrame >= this.maxFrames) {
                throw new ResourceLimitExceededException("Cannot write more frames to the channel");
            }
            ++this.curFrame;
        }

        public void write(Frame frame) {
        }

        public void fail(@Nullable Throwable cause) {
        }

        public void close() {
        }

        public boolean isClosed() {
            return false;
        }

        public ListenableFuture<?> writabilityFuture() {
            return null;
        }
    }
}

