/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.field.TransformUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TransformUtilsTest {
    private final WritableMemory lhsMemory = WritableMemory.allocate((int)10);
    private final WritableMemory rhsMemory = WritableMemory.allocate((int)10);
    private static final long MEMORY_LOCATION = 0L;
    private final FrameType frameType;

    public TransformUtilsTest(FrameType frameType) {
        this.frameType = frameType;
    }

    @Parameterized.Parameters(name="frameType = {0}")
    public static Iterable<Object[]> constructorFeeder() {
        return List.of(new Object[]{FrameType.ROW_BASED_V1}, new Object[]{FrameType.ROW_BASED_V2});
    }

    public static int expectedComparison(FrameType frameType, float x, float y) {
        switch (frameType) {
            case ROW_BASED_V1: {
                return Long.compare(TransformUtils.detransformToLong((long)TransformUtils.transformFromFloat((float)x, (FrameType)frameType)), TransformUtils.detransformToLong((long)TransformUtils.transformFromFloat((float)y, (FrameType)frameType)));
            }
        }
        return Float.isNaN(x) && Float.isNaN(y) ? 0 : Float.compare(x, y);
    }

    public static int expectedComparison(FrameType frameType, double x, double y) {
        switch (frameType) {
            case ROW_BASED_V1: {
                return Long.compare(TransformUtils.detransformToLong((long)TransformUtils.transformFromDouble((double)x, (FrameType)frameType)), TransformUtils.detransformToLong((long)TransformUtils.transformFromDouble((double)y, (FrameType)frameType)));
            }
        }
        return Double.isNaN(x) && Double.isNaN(y) ? 0 : Double.compare(x, y);
    }

    @Test
    public void doubleTest() {
        ImmutableList values = ImmutableList.of((Object)Double.NaN, (Object)Double.MAX_VALUE, (Object)Double.MIN_VALUE, (Object)Double.POSITIVE_INFINITY, (Object)Double.NEGATIVE_INFINITY, (Object)Double.MIN_NORMAL, (Object)0.0, (Object)1.234234, (Object)-1.344234, (Object)129123.123123, (Object)-2.131221333E7, (Object)1111.0, (Object[])new Double[]{23.0, -7.692E-6, -0.07692, -0.1410658, -0.183808, -0.3311, -0.4615, 7.692E-6, 0.07692, 0.1410658, 0.183808, 0.3311, 0.4615});
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            double value = (Double)iterator.next();
            Assert.assertEquals((String)String.valueOf(value), (double)value, (double)TransformUtils.detransformToDouble((long)TransformUtils.transformFromDouble((double)value, (FrameType)this.frameType), (FrameType)this.frameType), (double)0.0);
        }
        for (int lhsIndex = 0; lhsIndex < values.size(); ++lhsIndex) {
            for (int rhsIndex = lhsIndex; rhsIndex < values.size(); ++rhsIndex) {
                double lhs = (Double)values.get(lhsIndex);
                double rhs = (Double)values.get(rhsIndex);
                this.lhsMemory.putLong(0L, TransformUtils.transformFromDouble((double)lhs, (FrameType)this.frameType));
                this.rhsMemory.putLong(0L, TransformUtils.transformFromDouble((double)rhs, (FrameType)this.frameType));
                int byteCmp = this.byteComparison(8);
                int expectedCmp = TransformUtilsTest.expectedComparison(this.frameType, lhs, rhs);
                Assert.assertEquals((String)StringUtils.format((String)"compare(%s, %s)", (Object[])new Object[]{lhs, rhs}), (long)this.signum(expectedCmp), (long)this.signum(byteCmp));
            }
        }
    }

    @Test
    public void longTest() {
        ImmutableList values = ImmutableList.of((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE, (Object)0L, (Object)123L, (Object)-123L);
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            long value = (Long)iterator.next();
            Assert.assertEquals((long)value, (long)TransformUtils.detransformToLong((long)TransformUtils.transformFromLong((long)value)));
        }
        for (int lhsIndex = 0; lhsIndex < values.size(); ++lhsIndex) {
            for (int rhsIndex = lhsIndex; rhsIndex < values.size(); ++rhsIndex) {
                long lhs = (Long)values.get(lhsIndex);
                long rhs = (Long)values.get(rhsIndex);
                this.lhsMemory.putLong(0L, TransformUtils.transformFromLong((long)lhs));
                this.rhsMemory.putLong(0L, TransformUtils.transformFromLong((long)rhs));
                int byteCmp = this.byteComparison(8);
                if (byteCmp < 0) {
                    Assert.assertTrue((lhs < rhs ? 1 : 0) != 0);
                    continue;
                }
                if (byteCmp == 0) {
                    Assert.assertEquals((long)lhs, (long)rhs);
                    continue;
                }
                Assert.assertTrue((lhs > rhs ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void floatTest() {
        ImmutableList values = ImmutableList.of((Object)Float.valueOf(Float.NaN), (Object)Float.valueOf(Float.MIN_VALUE), (Object)Float.valueOf(Float.MAX_VALUE), (Object)Float.valueOf(Float.MIN_NORMAL), (Object)Float.valueOf(Float.POSITIVE_INFINITY), (Object)Float.valueOf(Float.NEGATIVE_INFINITY), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(1.234234f), (Object)Float.valueOf(-1.344234f), (Object)Float.valueOf(129123.125f), (Object)Float.valueOf(-2.1312214E7f), (Object)Float.valueOf(1111.0f), (Object[])new Float[]{Float.valueOf(23.0f), Float.valueOf(-7.692E-6f), Float.valueOf(-0.07692f), Float.valueOf(-0.1410658f), Float.valueOf(-0.183808f), Float.valueOf(-0.3311f), Float.valueOf(-0.4615f), Float.valueOf(7.692E-6f), Float.valueOf(0.07692f), Float.valueOf(0.1410658f), Float.valueOf(0.183808f), Float.valueOf(0.3311f), Float.valueOf(0.4615f)});
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            float value = ((Float)iterator.next()).floatValue();
            Assert.assertEquals((String)String.valueOf(value), (double)value, (double)TransformUtils.detransformToFloat((int)TransformUtils.transformFromFloat((float)value, (FrameType)this.frameType), (FrameType)this.frameType), (double)0.0);
        }
        for (int lhsIndex = 0; lhsIndex < values.size(); ++lhsIndex) {
            for (int rhsIndex = lhsIndex; rhsIndex < values.size(); ++rhsIndex) {
                float lhs = ((Float)values.get(lhsIndex)).floatValue();
                float rhs = ((Float)values.get(rhsIndex)).floatValue();
                this.lhsMemory.putLong(0L, (long)TransformUtils.transformFromFloat((float)lhs, (FrameType)this.frameType));
                this.rhsMemory.putLong(0L, (long)TransformUtils.transformFromFloat((float)rhs, (FrameType)this.frameType));
                int byteCmp = this.byteComparison(8);
                int expectedCmp = TransformUtilsTest.expectedComparison(this.frameType, lhs, rhs);
                Assert.assertEquals((String)StringUtils.format((String)"compare(%s, %s)", (Object[])new Object[]{Float.valueOf(lhs), Float.valueOf(rhs)}), (long)this.signum(expectedCmp), (long)this.signum(byteCmp));
            }
        }
    }

    private int byteComparison(int numBytes) {
        for (int i = 0; i < numBytes; ++i) {
            byte rhsByte;
            byte lhsByte = this.lhsMemory.getByte(0L + (long)i);
            int cmp = (lhsByte & 0xFF) - ((rhsByte = this.rhsMemory.getByte(0L + (long)i)) & 0xFF);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    private int signum(int n) {
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        return 0;
    }
}

