/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.key;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Hashing;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.key.ByteRowKeyComparator;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.key.KeyOrder;
import org.apache.druid.frame.key.KeyTestUtils;
import org.apache.druid.frame.key.RowKey;
import org.apache.druid.hll.HyperLogLogCollector;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesSerde;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetrics;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class ByteRowKeyComparatorTest
extends InitializedNullHandlingTest {
    static final RowSignature NO_COMPLEX_SIGNATURE;
    static final RowSignature SIGNATURE;
    private static final Object[] OBJECTS1_WITHOUT_COMPLEX_COLUMN;
    private static final Object[] OBJECTS2_WITHOUT_COMPLEX_COLUMN;
    private static final Object[] OBJECTS3_WITHOUT_COMPLEX_COLUMN;
    private static final Object[] OBJECTS4_WITHOUT_COMPLEX_COLUMN;
    private static final Object[] OBJECTS5_WITHOUT_COMPLEX_COLUMN;
    private static final Object[] OBJECTS6_WITHOUT_COMPLEX_COLUMN;
    private static final Object[] OBJECTS7_WITHOUT_COMPLEX_COLUMN;
    private static final Object[] OBJECTS8_WITHOUT_COMPLEX_COLUMN;
    private static final Object[] OBJECTS9_WITHOUT_COMPLEX_COLUMN;
    private static final Object[] OBJECTS1;
    private static final Object[] OBJECTS2;
    private static final Object[] OBJECTS3;
    private static final Object[] OBJECTS4;
    private static final Object[] OBJECTS5;
    private static final Object[] OBJECTS6;
    private static final Object[] OBJECTS7;
    private static final Object[] OBJECTS8;
    private static final Object[] OBJECTS9;
    static final List<Object[]> KEY_OBJECTS_WITHOUT_COMPLEX_COLUMN;
    static final List<Object[]> ALL_KEY_OBJECTS;

    @Test
    public void test_compare_AAAA_without_complex_column() {
        ImmutableList keyColumns = ImmutableList.of((Object)new KeyColumn("1", KeyOrder.DESCENDING), (Object)new KeyColumn("2", KeyOrder.DESCENDING), (Object)new KeyColumn("3", KeyOrder.DESCENDING), (Object)new KeyColumn("4", KeyOrder.DESCENDING));
        Assert.assertEquals(ByteRowKeyComparatorTest.sortUsingObjectComparator((List<KeyColumn>)keyColumns, KEY_OBJECTS_WITHOUT_COMPLEX_COLUMN, NO_COMPLEX_SIGNATURE), ByteRowKeyComparatorTest.sortUsingByteKeyComparator((List<KeyColumn>)keyColumns, KEY_OBJECTS_WITHOUT_COMPLEX_COLUMN, NO_COMPLEX_SIGNATURE));
    }

    @Test
    public void test_compare_DDDD_without_complex_column() {
        ImmutableList keyColumns = ImmutableList.of((Object)new KeyColumn("1", KeyOrder.ASCENDING), (Object)new KeyColumn("2", KeyOrder.ASCENDING), (Object)new KeyColumn("3", KeyOrder.ASCENDING), (Object)new KeyColumn("4", KeyOrder.ASCENDING));
        Assert.assertEquals(ByteRowKeyComparatorTest.sortUsingObjectComparator((List<KeyColumn>)keyColumns, KEY_OBJECTS_WITHOUT_COMPLEX_COLUMN, NO_COMPLEX_SIGNATURE), ByteRowKeyComparatorTest.sortUsingByteKeyComparator((List<KeyColumn>)keyColumns, KEY_OBJECTS_WITHOUT_COMPLEX_COLUMN, NO_COMPLEX_SIGNATURE));
    }

    @Test
    public void test_compare_DAAD_without_complex_column() {
        ImmutableList keyColumns = ImmutableList.of((Object)new KeyColumn("1", KeyOrder.ASCENDING), (Object)new KeyColumn("2", KeyOrder.DESCENDING), (Object)new KeyColumn("3", KeyOrder.DESCENDING), (Object)new KeyColumn("4", KeyOrder.ASCENDING));
        Assert.assertEquals(ByteRowKeyComparatorTest.sortUsingObjectComparator((List<KeyColumn>)keyColumns, KEY_OBJECTS_WITHOUT_COMPLEX_COLUMN, NO_COMPLEX_SIGNATURE), ByteRowKeyComparatorTest.sortUsingByteKeyComparator((List<KeyColumn>)keyColumns, KEY_OBJECTS_WITHOUT_COMPLEX_COLUMN, NO_COMPLEX_SIGNATURE));
    }

    @Test
    public void test_compare_ADDA_without_complex_column() {
        ImmutableList keyColumns = ImmutableList.of((Object)new KeyColumn("1", KeyOrder.DESCENDING), (Object)new KeyColumn("2", KeyOrder.ASCENDING), (Object)new KeyColumn("3", KeyOrder.ASCENDING), (Object)new KeyColumn("4", KeyOrder.DESCENDING));
        Assert.assertEquals(ByteRowKeyComparatorTest.sortUsingObjectComparator((List<KeyColumn>)keyColumns, KEY_OBJECTS_WITHOUT_COMPLEX_COLUMN, NO_COMPLEX_SIGNATURE), ByteRowKeyComparatorTest.sortUsingByteKeyComparator((List<KeyColumn>)keyColumns, KEY_OBJECTS_WITHOUT_COMPLEX_COLUMN, NO_COMPLEX_SIGNATURE));
    }

    @Test
    public void test_compare_DADA_without_complex_column() {
        ImmutableList keyColumns = ImmutableList.of((Object)new KeyColumn("1", KeyOrder.DESCENDING), (Object)new KeyColumn("2", KeyOrder.ASCENDING), (Object)new KeyColumn("3", KeyOrder.DESCENDING), (Object)new KeyColumn("4", KeyOrder.ASCENDING));
        Assert.assertEquals(ByteRowKeyComparatorTest.sortUsingObjectComparator((List<KeyColumn>)keyColumns, KEY_OBJECTS_WITHOUT_COMPLEX_COLUMN, NO_COMPLEX_SIGNATURE), ByteRowKeyComparatorTest.sortUsingByteKeyComparator((List<KeyColumn>)keyColumns, KEY_OBJECTS_WITHOUT_COMPLEX_COLUMN, NO_COMPLEX_SIGNATURE));
    }

    @Test
    public void test_compare_DDDDDDDD() {
        ImmutableList keyColumns = ImmutableList.of((Object)new KeyColumn("1", KeyOrder.DESCENDING), (Object)new KeyColumn("2", KeyOrder.DESCENDING), (Object)new KeyColumn("3", KeyOrder.DESCENDING), (Object)new KeyColumn("4", KeyOrder.DESCENDING), (Object)new KeyColumn("5", KeyOrder.DESCENDING), (Object)new KeyColumn("6", KeyOrder.DESCENDING), (Object)new KeyColumn("7", KeyOrder.DESCENDING), (Object)new KeyColumn("8", KeyOrder.DESCENDING));
        Assert.assertEquals(ByteRowKeyComparatorTest.sortUsingObjectComparator((List<KeyColumn>)keyColumns, ALL_KEY_OBJECTS, SIGNATURE), ByteRowKeyComparatorTest.sortUsingByteKeyComparator((List<KeyColumn>)keyColumns, ALL_KEY_OBJECTS, SIGNATURE));
    }

    @Test
    public void test_compare_AAAAAAAA() {
        ImmutableList keyColumns = ImmutableList.of((Object)new KeyColumn("1", KeyOrder.ASCENDING), (Object)new KeyColumn("2", KeyOrder.ASCENDING), (Object)new KeyColumn("3", KeyOrder.ASCENDING), (Object)new KeyColumn("4", KeyOrder.ASCENDING), (Object)new KeyColumn("5", KeyOrder.ASCENDING), (Object)new KeyColumn("6", KeyOrder.ASCENDING), (Object)new KeyColumn("7", KeyOrder.ASCENDING), (Object)new KeyColumn("8", KeyOrder.ASCENDING));
        Assert.assertEquals(ByteRowKeyComparatorTest.sortUsingObjectComparator((List<KeyColumn>)keyColumns, ALL_KEY_OBJECTS, SIGNATURE), ByteRowKeyComparatorTest.sortUsingByteKeyComparator((List<KeyColumn>)keyColumns, ALL_KEY_OBJECTS, SIGNATURE));
    }

    @Test
    public void test_compare_ADDADDAA() {
        ImmutableList keyColumns = ImmutableList.of((Object)new KeyColumn("1", KeyOrder.ASCENDING), (Object)new KeyColumn("2", KeyOrder.DESCENDING), (Object)new KeyColumn("3", KeyOrder.DESCENDING), (Object)new KeyColumn("4", KeyOrder.ASCENDING), (Object)new KeyColumn("5", KeyOrder.DESCENDING), (Object)new KeyColumn("6", KeyOrder.DESCENDING), (Object)new KeyColumn("7", KeyOrder.ASCENDING), (Object)new KeyColumn("8", KeyOrder.ASCENDING));
        Assert.assertEquals(ByteRowKeyComparatorTest.sortUsingObjectComparator((List<KeyColumn>)keyColumns, ALL_KEY_OBJECTS, SIGNATURE), ByteRowKeyComparatorTest.sortUsingByteKeyComparator((List<KeyColumn>)keyColumns, ALL_KEY_OBJECTS, SIGNATURE));
    }

    @Test
    public void test_compare_DAADAADD() {
        ImmutableList keyColumns = ImmutableList.of((Object)new KeyColumn("1", KeyOrder.DESCENDING), (Object)new KeyColumn("2", KeyOrder.ASCENDING), (Object)new KeyColumn("3", KeyOrder.ASCENDING), (Object)new KeyColumn("4", KeyOrder.DESCENDING), (Object)new KeyColumn("5", KeyOrder.ASCENDING), (Object)new KeyColumn("6", KeyOrder.ASCENDING), (Object)new KeyColumn("7", KeyOrder.DESCENDING), (Object)new KeyColumn("8", KeyOrder.DESCENDING));
        Assert.assertEquals(ByteRowKeyComparatorTest.sortUsingObjectComparator((List<KeyColumn>)keyColumns, ALL_KEY_OBJECTS, SIGNATURE), ByteRowKeyComparatorTest.sortUsingByteKeyComparator((List<KeyColumn>)keyColumns, ALL_KEY_OBJECTS, SIGNATURE));
    }

    @Test
    public void test_compare_DADADADA() {
        ImmutableList keyColumns = ImmutableList.of((Object)new KeyColumn("1", KeyOrder.DESCENDING), (Object)new KeyColumn("2", KeyOrder.ASCENDING), (Object)new KeyColumn("3", KeyOrder.DESCENDING), (Object)new KeyColumn("4", KeyOrder.ASCENDING), (Object)new KeyColumn("5", KeyOrder.DESCENDING), (Object)new KeyColumn("6", KeyOrder.ASCENDING), (Object)new KeyColumn("7", KeyOrder.DESCENDING), (Object)new KeyColumn("8", KeyOrder.ASCENDING));
        Assert.assertEquals(ByteRowKeyComparatorTest.sortUsingObjectComparator((List<KeyColumn>)keyColumns, ALL_KEY_OBJECTS, SIGNATURE), ByteRowKeyComparatorTest.sortUsingByteKeyComparator((List<KeyColumn>)keyColumns, ALL_KEY_OBJECTS, SIGNATURE));
    }

    @Test
    public void test_equals() {
        EqualsVerifier.forClass(ByteRowKeyComparator.class).usingGetClass().verify();
    }

    private static List<RowKey> sortUsingByteKeyComparator(List<KeyColumn> keyColumns, List<Object[]> objectss, RowSignature rowSignature) {
        return objectss.stream().map(objects -> KeyTestUtils.createKey(rowSignature, FrameType.latestRowBased(), objects).array()).sorted((Comparator<byte[]>)ByteRowKeyComparator.create(keyColumns, (RowSignature)rowSignature)).map(RowKey::wrap).collect(Collectors.toList());
    }

    private static List<RowKey> sortUsingObjectComparator(List<KeyColumn> keyColumns, List<Object[]> objectss, RowSignature rowSignature) {
        List sortedObjectssCopy = objectss.stream().sorted((o1, o2) -> {
            for (int i = 0; i < keyColumns.size(); ++i) {
                KeyColumn keyColumn = (KeyColumn)keyColumns.get(i);
                int cmp = Comparators.naturalNullsFirst().compare((Object)((Comparable)o1[i]), (Object)((Comparable)o2[i]));
                if (cmp == 0) continue;
                return keyColumn.order() == KeyOrder.DESCENDING ? -cmp : cmp;
            }
            return 0;
        }).collect(Collectors.toList());
        ArrayList<RowKey> sortedKeys = new ArrayList<RowKey>();
        for (Object[] objects : sortedObjectssCopy) {
            sortedKeys.add(KeyTestUtils.createKey(rowSignature, FrameType.latestRowBased(), objects));
        }
        return sortedKeys;
    }

    public static HyperLogLogCollector makeHllCollector(int estimatedCardinality) {
        HyperLogLogCollector collector = HyperLogLogCollector.makeLatestCollector();
        for (int i = 0; i < estimatedCardinality; ++i) {
            collector.add(Hashing.murmur3_128().hashBytes(StringUtils.toUtf8((String)String.valueOf(i))).asBytes());
        }
        return collector;
    }

    static {
        ComplexMetrics.registerSerde((String)"hyperUnique", (ComplexMetricSerde)new HyperUniquesSerde());
        NO_COMPLEX_SIGNATURE = RowSignature.builder().add("1", ColumnType.LONG).add("2", ColumnType.STRING).add("3", ColumnType.LONG).add("4", ColumnType.DOUBLE).build();
        SIGNATURE = RowSignature.builder().add("1", HyperUniquesAggregatorFactory.TYPE).add("2", ColumnType.LONG).add("3", ColumnType.STRING).add("4", HyperUniquesAggregatorFactory.TYPE).add("5", ColumnType.LONG).add("6", ColumnType.DOUBLE).add("7", HyperUniquesAggregatorFactory.TYPE).add("8", HyperUniquesAggregatorFactory.TYPE).build();
        OBJECTS1_WITHOUT_COMPLEX_COLUMN = new Object[]{-1L, "foo", 2L, -1.2};
        OBJECTS2_WITHOUT_COMPLEX_COLUMN = new Object[]{-1L, null, 2L, 1.2};
        OBJECTS3_WITHOUT_COMPLEX_COLUMN = new Object[]{-1L, "bar", 2L, 1.2};
        OBJECTS4_WITHOUT_COMPLEX_COLUMN = new Object[]{-1L, "foo", 2L, 1.2};
        OBJECTS5_WITHOUT_COMPLEX_COLUMN = new Object[]{-1L, "foo", 3L, 1.2};
        OBJECTS6_WITHOUT_COMPLEX_COLUMN = new Object[]{-1L, "foo", 2L, 1.3};
        OBJECTS7_WITHOUT_COMPLEX_COLUMN = new Object[]{1L, "foo", 2L, -1.2};
        OBJECTS8_WITHOUT_COMPLEX_COLUMN = new Object[]{1L, "foo", 2L, -1.2};
        OBJECTS9_WITHOUT_COMPLEX_COLUMN = new Object[]{1L, "foo", 2L, -1.2};
        OBJECTS1 = new Object[]{null, -1L, "foo", ByteRowKeyComparatorTest.makeHllCollector(5), 2L, -1.2, ByteRowKeyComparatorTest.makeHllCollector(5), ByteRowKeyComparatorTest.makeHllCollector(1)};
        OBJECTS2 = new Object[]{null, -1L, null, null, 2L, 1.2, ByteRowKeyComparatorTest.makeHllCollector(50), ByteRowKeyComparatorTest.makeHllCollector(5)};
        OBJECTS3 = new Object[]{ByteRowKeyComparatorTest.makeHllCollector(50), -1L, "bar", ByteRowKeyComparatorTest.makeHllCollector(5), 2L, 1.2, ByteRowKeyComparatorTest.makeHllCollector(5), ByteRowKeyComparatorTest.makeHllCollector(50)};
        OBJECTS4 = new Object[]{ByteRowKeyComparatorTest.makeHllCollector(50), -1L, "foo", ByteRowKeyComparatorTest.makeHllCollector(100), 2L, 1.2, ByteRowKeyComparatorTest.makeHllCollector(1), ByteRowKeyComparatorTest.makeHllCollector(5)};
        OBJECTS5 = new Object[]{ByteRowKeyComparatorTest.makeHllCollector(1), -1L, "foo", ByteRowKeyComparatorTest.makeHllCollector(5), 3L, 1.2, null, ByteRowKeyComparatorTest.makeHllCollector(5)};
        OBJECTS6 = new Object[]{ByteRowKeyComparatorTest.makeHllCollector(5), -1L, "foo", ByteRowKeyComparatorTest.makeHllCollector(100), 2L, 1.3, ByteRowKeyComparatorTest.makeHllCollector(100), ByteRowKeyComparatorTest.makeHllCollector(20)};
        OBJECTS7 = new Object[]{ByteRowKeyComparatorTest.makeHllCollector(100), 1L, "foo", ByteRowKeyComparatorTest.makeHllCollector(5), 2L, -1.2, null, null};
        OBJECTS8 = new Object[]{ByteRowKeyComparatorTest.makeHllCollector(5), 1L, "foo", ByteRowKeyComparatorTest.makeHllCollector(50), 2L, -1.2, ByteRowKeyComparatorTest.makeHllCollector(500), ByteRowKeyComparatorTest.makeHllCollector(100)};
        OBJECTS9 = new Object[]{ByteRowKeyComparatorTest.makeHllCollector(5), 1L, "foo", ByteRowKeyComparatorTest.makeHllCollector(50), 2L, -1.2, ByteRowKeyComparatorTest.makeHllCollector(500), ByteRowKeyComparatorTest.makeHllCollector(10)};
        KEY_OBJECTS_WITHOUT_COMPLEX_COLUMN = Arrays.asList(OBJECTS1_WITHOUT_COMPLEX_COLUMN, OBJECTS2_WITHOUT_COMPLEX_COLUMN, OBJECTS3_WITHOUT_COMPLEX_COLUMN, OBJECTS4_WITHOUT_COMPLEX_COLUMN, OBJECTS5_WITHOUT_COMPLEX_COLUMN, OBJECTS6_WITHOUT_COMPLEX_COLUMN, OBJECTS7_WITHOUT_COMPLEX_COLUMN, OBJECTS8_WITHOUT_COMPLEX_COLUMN, OBJECTS9_WITHOUT_COMPLEX_COLUMN);
        ALL_KEY_OBJECTS = Arrays.asList(OBJECTS1, OBJECTS2, OBJECTS3, OBJECTS4, OBJECTS5, OBJECTS6, OBJECTS7, OBJECTS8, OBJECTS9);
    }
}

