/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor.test;

import com.google.common.util.concurrent.ListenableFuture;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.java.util.common.ISE;

public class AlwaysAsyncReadableFrameChannel
implements ReadableFrameChannel {
    private final ReadableFrameChannel delegate;
    private boolean defer;

    public AlwaysAsyncReadableFrameChannel(ReadableFrameChannel delegate) {
        this.delegate = delegate;
    }

    public boolean isFinished() {
        if (this.defer) {
            return false;
        }
        return this.delegate.isFinished();
    }

    public boolean canRead() {
        if (this.defer) {
            return false;
        }
        return this.delegate.canRead();
    }

    public Frame read() {
        if (this.defer) {
            throw new ISE("Cannot call read() while deferred", new Object[0]);
        }
        this.defer = true;
        return this.delegate.read();
    }

    public ListenableFuture<?> readabilityFuture() {
        this.defer = false;
        return this.delegate.readabilityFuture();
    }

    public void close() {
        this.defer = false;
        this.delegate.close();
    }
}

