/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.druid.indexer.RunnerTaskState;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.junit.Assert;
import org.junit.Test;

public class TaskStatusPlusTest {
    private final ObjectMapper jsonMapper = new DefaultObjectMapper();

    @Test
    public void testSerde() throws IOException {
        TaskStatusPlus status = new TaskStatusPlus("testId", "testGroupId", "testType", DateTimes.nowUtc(), DateTimes.nowUtc(), TaskState.RUNNING, RunnerTaskState.RUNNING, Long.valueOf(1000L), TaskLocation.create((String)"testHost", (int)1010, (int)-1), "ds_test", null);
        String json = this.jsonMapper.writeValueAsString((Object)status);
        Assert.assertEquals((Object)status, (Object)this.jsonMapper.readValue(json, TaskStatusPlus.class));
    }

    @Test
    public void testJsonAttributes() throws IOException {
        String json = "{\n\"id\": \"testId\",\n\"groupId\": \"testGroupId\",\n\"type\": \"testType\",\n\"createdTime\": \"2018-09-17T06:35:17.392Z\",\n\"queueInsertionTime\": \"2018-09-17T06:35:17.392Z\",\n\"statusCode\": \"RUNNING\",\n\"status\": \"RUNNING\",\n\"runnerStatusCode\": \"RUNNING\",\n\"duration\": 1000,\n\"location\": {\n\"host\": \"testHost\",\n\"port\": 1010,\n\"tlsPort\": -1\n},\n\"dataSource\": \"ds_test\",\n\"errorMsg\": null\n}";
        TaskStatusPlus taskStatusPlus = (TaskStatusPlus)this.jsonMapper.readValue("{\n\"id\": \"testId\",\n\"groupId\": \"testGroupId\",\n\"type\": \"testType\",\n\"createdTime\": \"2018-09-17T06:35:17.392Z\",\n\"queueInsertionTime\": \"2018-09-17T06:35:17.392Z\",\n\"statusCode\": \"RUNNING\",\n\"status\": \"RUNNING\",\n\"runnerStatusCode\": \"RUNNING\",\n\"duration\": 1000,\n\"location\": {\n\"host\": \"testHost\",\n\"port\": 1010,\n\"tlsPort\": -1\n},\n\"dataSource\": \"ds_test\",\n\"errorMsg\": null\n}", TaskStatusPlus.class);
        Assert.assertNotNull((Object)taskStatusPlus);
        Assert.assertNotNull((Object)taskStatusPlus.getStatusCode());
        Assert.assertTrue((boolean)taskStatusPlus.getStatusCode().isRunnable());
        Assert.assertNotNull((Object)taskStatusPlus.getRunnerStatusCode());
        String serialized = this.jsonMapper.writeValueAsString((Object)taskStatusPlus);
        Assert.assertTrue((boolean)serialized.contains("\"status\":"));
        Assert.assertTrue((boolean)serialized.contains("\"statusCode\":"));
        Assert.assertTrue((boolean)serialized.contains("\"runnerStatusCode\":"));
    }
}

