/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.initialization;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.util.ArrayList;
import java.util.List;
import org.apache.druid.initialization.DruidModule;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DruidModuleTest {
    @Test
    public void testOverride() {
        Injector initInjector = Guice.createInjector((Module[])new Module[]{new LocalProviderModule(10)});
        DruidModule overrideModule = DruidModule.override((Module)new LocalProviderModule(1), (Module)new LocalProviderModule(2));
        initInjector.injectMembers((Object)overrideModule);
        Injector injector = Guice.createInjector((Module[])new Module[]{overrideModule});
        Integer val = (Integer)injector.getInstance(Integer.class);
        Assertions.assertEquals((int)12, (Integer)val);
    }

    @Test
    public void testOverrideJacksonModules() {
        Injector initInjector = Guice.createInjector((Module[])new Module[]{new LocalProviderModule(10)});
        DruidModule overrideModule = DruidModule.override((Module)new LocalProviderModule(1), (Module)new LocalProviderModule(2));
        initInjector.injectMembers((Object)overrideModule);
        List jacksonModules = overrideModule.getJacksonModules();
        Assertions.assertEquals((int)1, (int)jacksonModules.size());
    }

    static class LocalProviderModule
    implements DruidModule {
        private int val;
        private int baseVal = 0;

        @Inject
        public void injectInteger(Integer baseVal) {
            this.baseVal = baseVal;
        }

        public LocalProviderModule(int i) {
            this.val = i;
        }

        public void configure(Binder binder) {
        }

        @Provides
        public Integer getVal() {
            return this.val + this.baseVal;
        }

        public List<? extends com.fasterxml.jackson.databind.Module> getJacksonModules() {
            ArrayList<Object> li = new ArrayList<Object>();
            for (int i = 0; i < this.val; ++i) {
                li.add(null);
            }
            return li;
        }
    }
}

