/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.InvalidTypeIdException;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.query.Query;
import org.apache.druid.query.rowsandcols.MapOfColumnsRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.IntArrayColumn;
import org.apache.druid.query.rowsandcols.concrete.ColumnBasedFrameRowsAndColumns;
import org.apache.druid.query.rowsandcols.concrete.ColumnBasedFrameRowsAndColumnsTest;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.Test;

public class DefaultObjectMapperTest {
    ObjectMapper mapper = new DefaultObjectMapper();

    @Test
    public void testDateTime() throws Exception {
        DateTime time = DateTimes.nowUtc();
        Assert.assertEquals((Object)StringUtils.format((String)"\"%s\"", (Object[])new Object[]{time}), (Object)this.mapper.writeValueAsString((Object)time));
        Assert.assertEquals((Object)time, (Object)this.mapper.readValue(StringUtils.format((String)"\"%s\"", (Object[])new Object[]{time}), DateTime.class));
        DateTime result = (DateTime)this.mapper.readValue("1717267200000", DateTime.class);
        Assert.assertEquals((Object)DateTimes.utc((long)1717267200000L), (Object)result);
        String badString = "{\"dateTime\": true}";
        Exception ex = (Exception)Assert.assertThrows(Exception.class, () -> this.mapper.readValue(badString, DateTime.class));
        Assert.assertTrue((boolean)ex.getMessage().contains("expected int or string token"));
    }

    @Test
    public void testYielder() throws Exception {
        Sequence sequence = Sequences.simple(Arrays.asList("a", "b", null, DateTimes.utc((long)2L), 5, DateTimeZone.UTC, "c"));
        Assert.assertEquals((Object)"[\"a\",\"b\",null,\"1970-01-01T00:00:00.002Z\",5,\"UTC\",\"c\"]", (Object)this.mapper.writeValueAsString((Object)Yielders.each((Sequence)sequence)));
    }

    @Test
    public void testUnknownType() throws JsonProcessingException {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper("testService");
        try {
            objectMapper.readValue("{\"queryType\":\"random\",\"name\":\"does-not-matter\"}", Query.class);
        }
        catch (InvalidTypeIdException e) {
            String message = e.getMessage();
            Assert.assertTrue((String)message, (boolean)message.startsWith("Please make sure to load all the necessary extensions and jars with type 'random' on 'testService' service."));
            return;
        }
        Assert.fail((String)"We expect InvalidTypeIdException to be thrown");
    }

    @Test
    public void testUnknownTypeWithUnknownService() throws JsonProcessingException {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper((String)null);
        try {
            objectMapper.readValue("{\"queryType\":\"random\",\"name\":\"does-not-matter\"}", Query.class);
        }
        catch (InvalidTypeIdException e) {
            String message = e.getMessage();
            Assert.assertTrue((String)message, (boolean)message.startsWith("Please make sure to load all the necessary extensions and jars with type 'random'."));
            return;
        }
        Assert.fail((String)"We expect InvalidTypeIdException to be thrown");
    }

    @Test
    public void testColumnBasedFrameRowsAndColumns() throws Exception {
        DefaultObjectMapper om = new DefaultObjectMapper("test");
        MapOfColumnsRowsAndColumns input = MapOfColumnsRowsAndColumns.fromMap((Map)ImmutableMap.of((Object)"colA", (Object)new IntArrayColumn(new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}), (Object)"colB", (Object)new IntArrayColumn(new int[]{4, -4, 3, -3, 4, 82, -90, 4, 0, 0})));
        ColumnBasedFrameRowsAndColumns frc = ColumnBasedFrameRowsAndColumnsTest.buildFrame(input);
        byte[] bytes = om.writeValueAsBytes((Object)frc);
        ColumnBasedFrameRowsAndColumns frc2 = (ColumnBasedFrameRowsAndColumns)om.readValue(bytes, RowsAndColumns.class);
        Assert.assertEquals((Object)frc, (Object)frc2);
    }
}

