/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common;

import com.google.common.collect.ImmutableList;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.MemoryBoundLinkedBlockingQueue;
import org.apache.druid.java.util.common.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class MemoryBoundLinkedBlockingQueueTest {
    @Test
    public void test_offer_emptyQueueWithEnoughCapacity_true() {
        long byteCapacity = 10L;
        MemoryBoundLinkedBlockingQueue queue = MemoryBoundLinkedBlockingQueueTest.setupQueue(byteCapacity, ImmutableList.of());
        byte[] item = "item".getBytes(StandardCharsets.UTF_8);
        boolean succeeds = queue.offer(new MemoryBoundLinkedBlockingQueue.ObjectContainer((Object)item, (long)item.length));
        long expectedByteSize = item.length;
        Assert.assertTrue((boolean)succeeds);
        Assert.assertEquals((long)1L, (long)queue.size());
        Assert.assertEquals((long)expectedByteSize, (long)queue.byteSize());
        Assert.assertEquals((long)(byteCapacity - (long)item.length), (long)queue.remainingCapacity());
    }

    @Test
    public void test_offer_nonEmptyQueueWithEnoughCapacity_true() {
        long byteCapacity = 10L;
        byte[] item1 = "item1".getBytes(StandardCharsets.UTF_8);
        byte[] item2 = "item2".getBytes(StandardCharsets.UTF_8);
        Collection items = MemoryBoundLinkedBlockingQueueTest.buildItemContainers((Collection<byte[]>)ImmutableList.of((Object)item1));
        MemoryBoundLinkedBlockingQueue queue = MemoryBoundLinkedBlockingQueueTest.setupQueue(byteCapacity, items);
        boolean succeeds = queue.offer(new MemoryBoundLinkedBlockingQueue.ObjectContainer((Object)item2, (long)item2.length));
        long expectedByteSize = item1.length + item2.length;
        Assert.assertTrue((boolean)succeeds);
        Assert.assertEquals((long)2L, (long)queue.size());
        Assert.assertEquals((long)expectedByteSize, (long)queue.byteSize());
        Assert.assertEquals((long)(byteCapacity - expectedByteSize), (long)queue.remainingCapacity());
    }

    @Test
    public void test_offer_queueWithoutEnoughCapacity_false() {
        long byteCapacity = 7L;
        byte[] item1 = "item1".getBytes(StandardCharsets.UTF_8);
        byte[] item2 = "item2".getBytes(StandardCharsets.UTF_8);
        Collection items = MemoryBoundLinkedBlockingQueueTest.buildItemContainers((Collection<byte[]>)ImmutableList.of((Object)item1));
        MemoryBoundLinkedBlockingQueue queue = MemoryBoundLinkedBlockingQueueTest.setupQueue(byteCapacity, items);
        boolean succeeds = queue.offer(new MemoryBoundLinkedBlockingQueue.ObjectContainer((Object)item2, (long)item2.length));
        long expectedByteSize = item1.length;
        Assert.assertFalse((boolean)succeeds);
        Assert.assertEquals((long)1L, (long)queue.size());
        Assert.assertEquals((long)expectedByteSize, (long)queue.byteSize());
        Assert.assertEquals((long)(byteCapacity - expectedByteSize), (long)queue.remainingCapacity());
    }

    @Test
    public void test_offerWithTimeLimit_interruptedExceptinThrown_throws() {
        long byteCapacity = 10L;
        MemoryBoundLinkedBlockingQueue<byte[]> queue = MemoryBoundLinkedBlockingQueueTest.setupQueue(byteCapacity, ImmutableList.of(), new InterruptedExceptionThrowingQueue());
        byte[] item = "item".getBytes(StandardCharsets.UTF_8);
        Assert.assertThrows(InterruptedException.class, () -> queue.offer(new MemoryBoundLinkedBlockingQueue.ObjectContainer((Object)item, (long)item.length), 1L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)0L, (long)queue.size());
        Assert.assertEquals((long)0L, (long)queue.byteSize());
        Assert.assertEquals((long)byteCapacity, (long)queue.remainingCapacity());
    }

    @Test
    public void test_offerWithTimeLimit_fullQueue_waitsTime() throws InterruptedException {
        long timeoutMillis = 2000L;
        long byteCapacity = 10L;
        byte[] item1 = "item1".getBytes(StandardCharsets.UTF_8);
        byte[] item2 = "item2".getBytes(StandardCharsets.UTF_8);
        Collection items = MemoryBoundLinkedBlockingQueueTest.buildItemContainers((Collection<byte[]>)ImmutableList.of((Object)item1, (Object)item2));
        MemoryBoundLinkedBlockingQueue<byte[]> queue = MemoryBoundLinkedBlockingQueueTest.setupQueue(byteCapacity, items, new InterruptedExceptionThrowingQueue());
        byte[] item = "item".getBytes(StandardCharsets.UTF_8);
        long start = System.currentTimeMillis();
        boolean succeeds = queue.offer(new MemoryBoundLinkedBlockingQueue.ObjectContainer((Object)item, (long)item.length), timeoutMillis, TimeUnit.MILLISECONDS);
        long end = System.currentTimeMillis();
        Assert.assertFalse((boolean)succeeds);
        Assert.assertTrue((String)StringUtils.format((String)"offer only waited at most [%d] nanos instead of expected [%d] nanos", (Object[])new Object[]{TimeUnit.MILLISECONDS.toNanos(end - start), TimeUnit.MILLISECONDS.toNanos(timeoutMillis)}), (TimeUnit.MILLISECONDS.toNanos(end - start) >= TimeUnit.MILLISECONDS.toNanos(timeoutMillis) ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)queue.size());
        Assert.assertEquals((long)10L, (long)queue.byteSize());
        Assert.assertEquals((long)0L, (long)queue.remainingCapacity());
    }

    @Test
    public void test_take_nonEmptyQueue_expected() throws InterruptedException {
        long byteCapacity = 10L;
        byte[] item1 = "item1".getBytes(StandardCharsets.UTF_8);
        byte[] item2 = "item2".getBytes(StandardCharsets.UTF_8);
        MemoryBoundLinkedBlockingQueue.ObjectContainer item1Container = new MemoryBoundLinkedBlockingQueue.ObjectContainer((Object)item1, (long)item1.length);
        MemoryBoundLinkedBlockingQueue.ObjectContainer item2Container = new MemoryBoundLinkedBlockingQueue.ObjectContainer((Object)item2, (long)item2.length);
        MemoryBoundLinkedBlockingQueue queue = MemoryBoundLinkedBlockingQueueTest.setupQueue(byteCapacity, ImmutableList.of());
        Assert.assertTrue((boolean)queue.offer(item1Container));
        Assert.assertTrue((boolean)queue.offer(item2Container));
        MemoryBoundLinkedBlockingQueue.ObjectContainer takenItem = queue.take();
        long expectedByteSize = item2.length;
        Assert.assertSame((Object)item1Container, (Object)takenItem);
        Assert.assertEquals((long)1L, (long)queue.size());
        Assert.assertEquals((long)expectedByteSize, (long)queue.byteSize());
        Assert.assertEquals((long)(byteCapacity - expectedByteSize), (long)queue.remainingCapacity());
    }

    @Test
    public void test_drain_emptyQueue_succeeds() throws InterruptedException {
        ArrayList buffer;
        long byteCapacity = 7L;
        MemoryBoundLinkedBlockingQueue queue = MemoryBoundLinkedBlockingQueueTest.setupQueue(byteCapacity, ImmutableList.of());
        int numAdded = queue.drain(buffer = new ArrayList(), 1, 1L, TimeUnit.SECONDS);
        Assert.assertTrue((numAdded == 0 && numAdded == buffer.size() ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)queue.size());
        Assert.assertEquals((long)0L, (long)queue.byteSize());
        Assert.assertEquals((long)byteCapacity, (long)queue.remainingCapacity());
    }

    @Test
    public void test_drain_queueWithOneItem_succeeds() throws InterruptedException {
        ArrayList buffer;
        long byteCapacity = 7L;
        byte[] item1 = "item1".getBytes(StandardCharsets.UTF_8);
        Collection items = MemoryBoundLinkedBlockingQueueTest.buildItemContainers((Collection<byte[]>)ImmutableList.of((Object)item1));
        MemoryBoundLinkedBlockingQueue queue = MemoryBoundLinkedBlockingQueueTest.setupQueue(byteCapacity, items);
        int numAdded = queue.drain(buffer = new ArrayList(), 1, 1L, TimeUnit.MINUTES);
        Assert.assertTrue((numAdded == 1 && numAdded == buffer.size() ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)queue.size());
        Assert.assertEquals((long)0L, (long)queue.byteSize());
        Assert.assertEquals((long)byteCapacity, (long)queue.remainingCapacity());
    }

    @Test
    public void test_drain_queueWithMultipleItems_succeeds() throws InterruptedException {
        ArrayList buffer;
        byte[] item3;
        byte[] item2;
        long byteCapacity = 15L;
        byte[] item1 = "item1".getBytes(StandardCharsets.UTF_8);
        Collection items = MemoryBoundLinkedBlockingQueueTest.buildItemContainers((Collection<byte[]>)ImmutableList.of((Object)item1, (Object)(item2 = "item2".getBytes(StandardCharsets.UTF_8)), (Object)(item3 = "item3".getBytes(StandardCharsets.UTF_8))));
        MemoryBoundLinkedBlockingQueue<byte[]> queue = MemoryBoundLinkedBlockingQueueTest.setupQueue(byteCapacity, items, new NotAllDrainedQueue());
        int numAdded = queue.drain(buffer = new ArrayList(), 10, 1L, TimeUnit.MINUTES);
        Assert.assertTrue((numAdded == 2 && numAdded == buffer.size() ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)queue.size());
        Assert.assertEquals((long)item3.length, (long)queue.byteSize());
        Assert.assertEquals((long)(byteCapacity - (long)item3.length), (long)queue.remainingCapacity());
    }

    @Test
    public void test_drain_queueWithFirstItemSizeGreaterThanLimit_succeeds() throws InterruptedException {
        ArrayList buffer;
        byte[] item3;
        byte[] item2;
        long byteCapacity = 15L;
        byte[] item1 = "item1".getBytes(StandardCharsets.UTF_8);
        Collection items = MemoryBoundLinkedBlockingQueueTest.buildItemContainers((Collection<byte[]>)ImmutableList.of((Object)item1, (Object)(item2 = "item2".getBytes(StandardCharsets.UTF_8)), (Object)(item3 = "item3".getBytes(StandardCharsets.UTF_8))));
        MemoryBoundLinkedBlockingQueue<byte[]> queue = MemoryBoundLinkedBlockingQueueTest.setupQueue(byteCapacity, items, new NotAllDrainedQueue());
        int numAdded = queue.drain(buffer = new ArrayList(), item1.length - 1, 1L, TimeUnit.MINUTES);
        Assert.assertTrue((numAdded == 1 && numAdded == buffer.size() ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)queue.size());
        Assert.assertEquals((long)(item2.length + item3.length), (long)queue.byteSize());
        Assert.assertEquals((long)(byteCapacity - (long)(item2.length + item3.length)), (long)queue.remainingCapacity());
    }

    private static <T> MemoryBoundLinkedBlockingQueue<T> setupQueue(long byteCapacity, Collection<MemoryBoundLinkedBlockingQueue.ObjectContainer<T>> items) {
        return MemoryBoundLinkedBlockingQueueTest.setupQueue(byteCapacity, items, null);
    }

    private static <T> MemoryBoundLinkedBlockingQueue<T> setupQueue(long byteCapacity, Collection<MemoryBoundLinkedBlockingQueue.ObjectContainer<T>> items, @Nullable LinkedBlockingQueue<MemoryBoundLinkedBlockingQueue.ObjectContainer<T>> underlyingQueue) {
        Assert.assertTrue((MemoryBoundLinkedBlockingQueueTest.getTotalSizeOfItems(items) <= byteCapacity ? 1 : 0) != 0);
        MemoryBoundLinkedBlockingQueue queue = underlyingQueue != null ? new MemoryBoundLinkedBlockingQueue(underlyingQueue, byteCapacity) : new MemoryBoundLinkedBlockingQueue(byteCapacity);
        items.forEach(i -> Assert.assertTrue((boolean)queue.offer(i)));
        return queue;
    }

    private static Collection<MemoryBoundLinkedBlockingQueue.ObjectContainer<byte[]>> buildItemContainers(Collection<byte[]> items) {
        return items.stream().map(i -> new MemoryBoundLinkedBlockingQueue.ObjectContainer(i, (long)((byte[])i).length)).collect(Collectors.toList());
    }

    private static <T> long getTotalSizeOfItems(Collection<MemoryBoundLinkedBlockingQueue.ObjectContainer<T>> items) {
        return items.stream().mapToLong(MemoryBoundLinkedBlockingQueue.ObjectContainer::getSize).sum();
    }

    static class InterruptedExceptionThrowingQueue
    extends LinkedBlockingQueue<MemoryBoundLinkedBlockingQueue.ObjectContainer<byte[]>> {
        InterruptedExceptionThrowingQueue() {
        }

        @Override
        public boolean offer(MemoryBoundLinkedBlockingQueue.ObjectContainer<byte[]> item, long timeout, TimeUnit unit) throws InterruptedException {
            throw new InterruptedException("exception thrown");
        }
    }

    static class NotAllDrainedQueue
    extends LinkedBlockingQueue<MemoryBoundLinkedBlockingQueue.ObjectContainer<byte[]>> {
        NotAllDrainedQueue() {
        }

        @Override
        public int drainTo(Collection<? super MemoryBoundLinkedBlockingQueue.ObjectContainer<byte[]>> c, int maxElements) {
            MemoryBoundLinkedBlockingQueue.ObjectContainer firstItem = (MemoryBoundLinkedBlockingQueue.ObjectContainer)this.poll();
            c.add((MemoryBoundLinkedBlockingQueue.ObjectContainer<byte[]>)firstItem);
            return 1;
        }
    }
}

