/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.guava;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.druid.java.util.common.guava.Accumulator;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.DelegatingYieldingAccumulator;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.SequenceTestHelper;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.YieldingAccumulator;
import org.junit.Assert;
import org.junit.Test;

public class SkippingSequenceTest {
    private static final List<Integer> NUMS = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);

    @Test
    public void testSanityAccumulate() throws Exception {
        int threshold = 5;
        SequenceTestHelper.testAll((Sequence<Integer>)Sequences.simple(NUMS).skip(5L), Lists.newArrayList((Iterable)Iterables.skip(NUMS, (int)5)));
    }

    @Test
    public void testTwo() throws Exception {
        int threshold = 2;
        SequenceTestHelper.testAll((Sequence<Integer>)Sequences.simple(NUMS).skip(2L), Lists.newArrayList((Iterable)Iterables.skip(NUMS, (int)2)));
    }

    @Test
    public void testOne() throws Exception {
        boolean threshold = true;
        SequenceTestHelper.testAll((Sequence<Integer>)Sequences.simple(NUMS).skip(1L), Lists.newArrayList((Iterable)Iterables.skip(NUMS, (int)1)));
    }

    @Test
    public void testLimitThenSkip() throws Exception {
        int skip = 2;
        int limit = 4;
        SequenceTestHelper.testAll((Sequence<Integer>)Sequences.simple(NUMS).limit(4L).skip(2L), Lists.newArrayList((Iterable)Iterables.skip((Iterable)Iterables.limit(NUMS, (int)4), (int)2)));
    }

    @Test
    public void testWithYieldingSequence() {
        BaseSequence<Integer, Iterator<Integer>> sequence = new BaseSequence<Integer, Iterator<Integer>>((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<Integer, Iterator<Integer>>(){

            public Iterator<Integer> make() {
                return NUMS.iterator();
            }

            public void cleanup(Iterator<Integer> iterFromMake) {
            }
        }){

            public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, Integer> accumulator) {
                return super.toYielder(initValue, (YieldingAccumulator)new DelegatingYieldingAccumulator<OutType, Integer>(accumulator){

                    public OutType accumulate(OutType accumulated, Integer in) {
                        Object retVal = super.accumulate(accumulated, (Object)in);
                        this.yield();
                        return retVal;
                    }
                });
            }
        };
        int threshold = 4;
        SequenceTestHelper.testAccumulation("", (Sequence<Integer>)sequence.skip(4L), Lists.newArrayList((Iterable)Iterables.skip(NUMS, (int)4)));
    }

    @Test
    public void testNoSideEffects() {
        List<Integer> nums = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        AtomicLong accumulated = new AtomicLong(0L);
        Sequence seq = Sequences.simple((Iterable)Iterables.transform(nums, input -> {
            accumulated.addAndGet(input.intValue());
            return input;
        })).limit(5L);
        Assert.assertEquals((long)10L, (long)((Integer)seq.accumulate((Object)0, (Accumulator)new IntAdditionAccumulator())).intValue());
        Assert.assertEquals((long)10L, (long)accumulated.get());
        Assert.assertEquals((long)10L, (long)((Integer)seq.accumulate((Object)0, (Accumulator)new IntAdditionAccumulator())).intValue());
        Assert.assertEquals((long)20L, (long)accumulated.get());
    }

    private static class IntAdditionAccumulator
    implements Accumulator<Integer, Integer> {
        private IntAdditionAccumulator() {
        }

        public Integer accumulate(Integer accumulated, Integer in) {
            return accumulated + in;
        }
    }
}

