/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.emitter.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Properties;
import org.apache.druid.java.util.emitter.core.BaseHttpEmittingConfig;
import org.apache.druid.java.util.emitter.core.BatchingStrategy;
import org.apache.druid.java.util.emitter.core.Emitters;
import org.apache.druid.java.util.emitter.core.HttpEmitterConfig;
import org.apache.druid.java.util.emitter.core.ParametrizedUriEmitterConfig;
import org.junit.Assert;
import org.junit.Test;

public class ParametrizedUriEmitterConfigTest {
    private static Injector makeInjector(Properties props) {
        return Guice.createInjector((Module[])new Module[]{binder -> {
            ParametrizedUriEmitterConfig paramConfig = (ParametrizedUriEmitterConfig)new ObjectMapper().convertValue((Object)Emitters.makeCustomFactoryMap((Properties)props), ParametrizedUriEmitterConfig.class);
            HttpEmitterConfig httpEmitterConfig = paramConfig.buildHttpEmitterConfig("http://example.com/topic");
            binder.bind(HttpEmitterConfig.class).toInstance((Object)httpEmitterConfig);
        }});
    }

    @Test
    public void testDefaults() {
        Injector injector = ParametrizedUriEmitterConfigTest.makeInjector(new Properties());
        HttpEmitterConfig config = (HttpEmitterConfig)injector.getInstance(HttpEmitterConfig.class);
        Assert.assertEquals((long)BaseHttpEmittingConfig.DEFAULT_MAX_BATCH_SIZE, (long)config.getMaxBatchSize());
        Assert.assertEquals((long)BaseHttpEmittingConfig.DEFAULT_BATCH_QUEUE_SIZE_LIMIT, (long)config.getBatchQueueSizeLimit());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)config.getFlushTimeOut());
    }

    @Test
    public void testSettingEverything() {
        Properties props = new Properties();
        props.setProperty("org.apache.druid.java.util.emitter.httpEmitting.flushMillis", "1");
        props.setProperty("org.apache.druid.java.util.emitter.httpEmitting.flushCount", "2");
        props.setProperty("org.apache.druid.java.util.emitter.httpEmitting.basicAuthentication", "a:b");
        props.setProperty("org.apache.druid.java.util.emitter.httpEmitting.batchingStrategy", "NEWLINES");
        props.setProperty("org.apache.druid.java.util.emitter.httpEmitting.maxBatchSize", "4");
        props.setProperty("org.apache.druid.java.util.emitter.httpEmitting.flushTimeOut", "1000");
        Injector injector = ParametrizedUriEmitterConfigTest.makeInjector(props);
        HttpEmitterConfig config = (HttpEmitterConfig)injector.getInstance(HttpEmitterConfig.class);
        Assert.assertEquals((long)1L, (long)config.getFlushMillis());
        Assert.assertEquals((long)2L, (long)config.getFlushCount());
        Assert.assertEquals((Object)"http://example.com/topic", (Object)config.getRecipientBaseUrl());
        Assert.assertEquals((Object)"a:b", (Object)config.getBasicAuthentication().getPassword());
        Assert.assertEquals((Object)BatchingStrategy.NEWLINES, (Object)config.getBatchingStrategy());
        Assert.assertEquals((long)4L, (long)config.getMaxBatchSize());
        Assert.assertEquals((long)1000L, (long)config.getFlushTimeOut());
    }
}

