/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.NonnullPair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.ExpressionTypeFactory;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.TypeStrategies;
import org.apache.druid.segment.column.TypeStrategiesTest;
import org.apache.druid.segment.column.TypeStrategy;
import org.apache.druid.segment.column.Types;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ExprEvalTest
extends InitializedNullHandlingTest {
    private static int MAX_SIZE_BYTES = 8192;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    ByteBuffer buffer = ByteBuffer.allocate(65536);

    @BeforeClass
    public static void setup() {
        TypeStrategies.registerComplex((String)TypeStrategiesTest.NULLABLE_TEST_PAIR_TYPE.getComplexTypeName(), (TypeStrategy)new TypeStrategiesTest.NullableLongPairTypeStrategy());
    }

    @Test
    public void testStringSerde() {
        this.assertExpr(0, "hello");
        this.assertExpr(1234, "hello");
        this.assertExpr(0, ExprEval.bestEffortOf(null));
    }

    @Test
    public void testStringSerdeTooBig() {
        this.expectedException.expect(ISE.class);
        this.expectedException.expectMessage(StringUtils.format((String)"Unable to serialize [%s], max size bytes is [%s], but need at least [%s] bytes to write entire value", (Object[])new Object[]{ExpressionType.STRING, 10, 16}));
        this.assertExpr(0, ExprEval.of((String)"hello world"), 10);
    }

    @Test
    public void testLongSerde() {
        this.assertExpr(0, 1L);
        this.assertExpr(1234, 1L);
        this.assertExpr(1234, ExprEval.ofLong(null));
    }

    @Test
    public void testDoubleSerde() {
        this.assertExpr(0, 1.123);
        this.assertExpr(1234, 1.123);
        this.assertExpr(1234, ExprEval.ofDouble(null));
    }

    @Test
    public void testStringArraySerde() {
        this.assertExpr(0, new String[]{"hello", "hi", "hey"});
        this.assertExpr(1024, new String[]{"hello", null, "hi", "hey"});
        this.assertExpr(2048, new String[0]);
    }

    @Test
    public void testStringArraySerdeToBig() {
        this.expectedException.expect(ISE.class);
        this.expectedException.expectMessage(StringUtils.format((String)"Unable to serialize [%s], max size bytes is [%s], but need at least [%s] bytes to write entire value", (Object[])new Object[]{ExpressionType.STRING_ARRAY, 10, 30}));
        this.assertExpr(0, ExprEval.ofStringArray((Object[])new String[]{"hello", "hi", "hey"}), 10);
    }

    @Test
    public void testStringArrayEvalToBig() {
        this.expectedException.expect(ISE.class);
        this.expectedException.expectMessage(StringUtils.format((String)"Unable to serialize [%s], max size bytes is [%s], but need at least [%s] bytes to write entire value", (Object[])new Object[]{ExpressionType.STRING_ARRAY, 10, 30}));
        this.assertExpr(0, ExprEval.ofStringArray((Object[])new String[]{"hello", "hi", "hey"}), 10);
    }

    @Test
    public void testLongArraySerde() {
        this.assertExpr(0, new Long[]{1L, 2L, 3L});
        this.assertExpr(0, new long[]{1L, 2L, 3L});
        this.assertExpr(1234, new Long[]{1L, 2L, null, 3L});
        this.assertExpr(1234, new Long[0]);
    }

    @Test
    public void testLongArraySerdeTooBig() {
        this.expectedException.expect(ISE.class);
        this.expectedException.expectMessage(StringUtils.format((String)"Unable to serialize [%s], max size bytes is [%s], but need at least [%s] bytes to write entire value", (Object[])new Object[]{ExpressionType.LONG_ARRAY, 10, 32}));
        this.assertExpr(0, ExprEval.ofLongArray((Object[])new Long[]{1L, 2L, 3L}), 10);
    }

    @Test
    public void testLongArrayEvalTooBig() {
        this.expectedException.expect(ISE.class);
        this.expectedException.expectMessage(StringUtils.format((String)"Unable to serialize [%s], max size bytes is [%s], but need at least [%s] bytes to write entire value", (Object[])new Object[]{ExpressionType.LONG_ARRAY, 10, 32}));
        this.assertExpr(0, ExprEval.ofLongArray((Object[])new Long[]{1L, 2L, 3L}), 10);
    }

    @Test
    public void testDoubleArraySerde() {
        this.assertExpr(0, new Double[]{1.1, 2.2, 3.3});
        this.assertExpr(0, new double[]{1.1, 2.2, 3.3});
        this.assertExpr(1234, new Double[]{1.1, 2.2, null, 3.3});
        this.assertExpr(1234, new Double[0]);
    }

    @Test
    public void testDoubleArraySerdeTooBig() {
        this.expectedException.expect(ISE.class);
        this.expectedException.expectMessage(StringUtils.format((String)"Unable to serialize [%s], max size bytes is [%s], but need at least [%s] bytes to write entire value", (Object[])new Object[]{ExpressionType.DOUBLE_ARRAY, 10, 32}));
        this.assertExpr(0, ExprEval.ofDoubleArray((Object[])new Double[]{1.1, 2.2, 3.3}), 10);
    }

    @Test
    public void testDoubleArrayEvalTooBig() {
        this.expectedException.expect(ISE.class);
        this.expectedException.expectMessage(StringUtils.format((String)"Unable to serialize [%s], max size bytes is [%s], but need at least [%s] bytes to write entire value", (Object[])new Object[]{ExpressionType.DOUBLE_ARRAY, 10, 32}));
        this.assertExpr(0, ExprEval.ofDoubleArray((Object[])new Double[]{1.1, 2.2, 3.3}), 10);
    }

    @Test
    public void testComplexEval() {
        ExpressionType complexType = ExpressionType.fromColumnType((TypeSignature)TypeStrategiesTest.NULLABLE_TEST_PAIR_TYPE);
        this.assertExpr(0, ExprEval.ofComplex((ExpressionType)complexType, (Object)new TypeStrategiesTest.NullableLongPair(1234L, 5678L)));
        this.assertExpr(1024, ExprEval.ofComplex((ExpressionType)complexType, (Object)new TypeStrategiesTest.NullableLongPair(1234L, 5678L)));
    }

    @Test
    public void testComplexEvalTooBig() {
        ExpressionType complexType = ExpressionType.fromColumnType((TypeSignature)TypeStrategiesTest.NULLABLE_TEST_PAIR_TYPE);
        this.expectedException.expect(ISE.class);
        this.expectedException.expectMessage(StringUtils.format((String)"Unable to serialize [%s], max size bytes is [%s], but need at least [%s] bytes to write entire value", (Object[])new Object[]{complexType.asTypeString(), 10, 19}));
        this.assertExpr(0, ExprEval.ofComplex((ExpressionType)complexType, (Object)new TypeStrategiesTest.NullableLongPair(1234L, 5678L)), 10);
    }

    @Test
    public void test_coerceListToArray() {
        Assert.assertNull((Object)ExprEval.coerceListToArray(null, (boolean)false));
        NonnullPair coerced = ExprEval.coerceListToArray((List)ImmutableList.of(), (boolean)false);
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)coerced.lhs);
        Assert.assertArrayEquals((Object[])new Object[0], (Object[])((Object[])coerced.rhs));
        coerced = ExprEval.coerceListToArray(null, (boolean)true);
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)coerced.lhs);
        Assert.assertArrayEquals((Object[])new Object[]{null}, (Object[])((Object[])coerced.rhs));
        coerced = ExprEval.coerceListToArray((List)ImmutableList.of(), (boolean)true);
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)coerced.lhs);
        Assert.assertArrayEquals((Object[])new Object[]{null}, (Object[])((Object[])coerced.rhs));
        ImmutableList longList = ImmutableList.of((Object)1L, (Object)2L, (Object)3L);
        coerced = ExprEval.coerceListToArray((List)longList, (boolean)false);
        Assert.assertEquals((Object)ExpressionType.LONG_ARRAY, (Object)coerced.lhs);
        Assert.assertArrayEquals((Object[])new Object[]{1L, 2L, 3L}, (Object[])((Object[])coerced.rhs));
        ImmutableList intList = ImmutableList.of((Object)1, (Object)2, (Object)3);
        ExprEval.coerceListToArray((List)intList, (boolean)false);
        Assert.assertEquals((Object)ExpressionType.LONG_ARRAY, (Object)coerced.lhs);
        Assert.assertArrayEquals((Object[])new Object[]{1L, 2L, 3L}, (Object[])((Object[])coerced.rhs));
        ImmutableList floatList = ImmutableList.of((Object)Float.valueOf(1.0f), (Object)Float.valueOf(2.0f), (Object)Float.valueOf(3.0f));
        coerced = ExprEval.coerceListToArray((List)floatList, (boolean)false);
        Assert.assertEquals((Object)ExpressionType.DOUBLE_ARRAY, (Object)coerced.lhs);
        Assert.assertArrayEquals((Object[])new Object[]{1.0, 2.0, 3.0}, (Object[])((Object[])coerced.rhs));
        ImmutableList doubleList = ImmutableList.of((Object)1.0, (Object)2.0, (Object)3.0);
        coerced = ExprEval.coerceListToArray((List)doubleList, (boolean)false);
        Assert.assertEquals((Object)ExpressionType.DOUBLE_ARRAY, (Object)coerced.lhs);
        Assert.assertArrayEquals((Object[])new Object[]{1.0, 2.0, 3.0}, (Object[])((Object[])coerced.rhs));
        ImmutableList stringList = ImmutableList.of((Object)"a", (Object)"b", (Object)"c");
        coerced = ExprEval.coerceListToArray((List)stringList, (boolean)false);
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)coerced.lhs);
        Assert.assertArrayEquals((Object[])new Object[]{"a", "b", "c"}, (Object[])((Object[])coerced.rhs));
        ArrayList<String> withNulls = new ArrayList<String>();
        withNulls.add("a");
        withNulls.add(null);
        withNulls.add("c");
        coerced = ExprEval.coerceListToArray(withNulls, (boolean)false);
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)coerced.lhs);
        Assert.assertArrayEquals((Object[])new Object[]{"a", null, "c"}, (Object[])((Object[])coerced.rhs));
        ArrayList<Long> withNumberNulls = new ArrayList<Long>();
        withNumberNulls.add(1L);
        withNumberNulls.add(null);
        withNumberNulls.add(3L);
        coerced = ExprEval.coerceListToArray(withNumberNulls, (boolean)false);
        Assert.assertEquals((Object)ExpressionType.LONG_ARRAY, (Object)coerced.lhs);
        Assert.assertArrayEquals((Object[])new Object[]{1L, null, 3L}, (Object[])((Object[])coerced.rhs));
        ImmutableList withStringMix = ImmutableList.of((Object)1L, (Object)"b", (Object)3L);
        coerced = ExprEval.coerceListToArray((List)withStringMix, (boolean)false);
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)coerced.lhs);
        Assert.assertArrayEquals((Object[])new Object[]{"1", "b", "3"}, (Object[])((Object[])coerced.rhs));
        ImmutableList withIntsAndLongs = ImmutableList.of((Object)1, (Object)2L, (Object)3);
        coerced = ExprEval.coerceListToArray((List)withIntsAndLongs, (boolean)false);
        Assert.assertEquals((Object)ExpressionType.LONG_ARRAY, (Object)coerced.lhs);
        Assert.assertArrayEquals((Object[])new Object[]{1L, 2L, 3L}, (Object[])((Object[])coerced.rhs));
        ImmutableList withFloatsAndLongs = ImmutableList.of((Object)1, (Object)2L, (Object)Float.valueOf(3.0f));
        coerced = ExprEval.coerceListToArray((List)withFloatsAndLongs, (boolean)false);
        Assert.assertEquals((Object)ExpressionType.DOUBLE_ARRAY, (Object)coerced.lhs);
        Assert.assertArrayEquals((Object[])new Object[]{1.0, 2.0, 3.0}, (Object[])((Object[])coerced.rhs));
        ImmutableList withDoublesAndLongs = ImmutableList.of((Object)1, (Object)2L, (Object)3.0);
        coerced = ExprEval.coerceListToArray((List)withDoublesAndLongs, (boolean)false);
        Assert.assertEquals((Object)ExpressionType.DOUBLE_ARRAY, (Object)coerced.lhs);
        Assert.assertArrayEquals((Object[])new Object[]{1.0, 2.0, 3.0}, (Object[])((Object[])coerced.rhs));
        ImmutableList withFloatsAndDoubles = ImmutableList.of((Object)1L, (Object)Float.valueOf(2.0f), (Object)3.0);
        coerced = ExprEval.coerceListToArray((List)withFloatsAndDoubles, (boolean)false);
        Assert.assertEquals((Object)ExpressionType.DOUBLE_ARRAY, (Object)coerced.lhs);
        Assert.assertArrayEquals((Object[])new Object[]{1.0, 2.0, 3.0}, (Object[])((Object[])coerced.rhs));
        ArrayList<Object> withAllNulls = new ArrayList<Object>();
        withAllNulls.add(null);
        withAllNulls.add(null);
        withAllNulls.add(null);
        coerced = ExprEval.coerceListToArray(withAllNulls, (boolean)false);
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)coerced.lhs);
        Assert.assertArrayEquals((Object[])new Object[]{null, null, null}, (Object[])((Object[])coerced.rhs));
        ImmutableMap nested1 = ImmutableMap.of((Object)"x", (Object)1L, (Object)"y", (Object)2L);
        ImmutableList mixedObject = ImmutableList.of((Object)"a", (Object)1L, (Object)3.0, (Object)nested1);
        coerced = ExprEval.coerceListToArray((List)mixedObject, (boolean)false);
        Assert.assertEquals((Object)ExpressionTypeFactory.getInstance().ofArray(ExpressionType.NESTED_DATA), (Object)coerced.lhs);
        Assert.assertArrayEquals((Object[])new Object[]{"a", 1L, 3.0, nested1}, (Object[])((Object[])coerced.rhs));
        ImmutableList mixedObject2 = ImmutableList.of((Object)nested1, (Object)"a", (Object)1L, (Object)3.0);
        coerced = ExprEval.coerceListToArray((List)mixedObject2, (boolean)false);
        Assert.assertEquals((Object)ExpressionTypeFactory.getInstance().ofArray(ExpressionType.NESTED_DATA), (Object)coerced.lhs);
        Assert.assertArrayEquals((Object[])new Object[]{nested1, "a", 1L, 3.0}, (Object[])((Object[])coerced.rhs));
        ImmutableList nestedLists = ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), (Object)ImmutableList.of((Object)"d", (Object)"e", (Object)"f"));
        coerced = ExprEval.coerceListToArray((List)nestedLists, (boolean)false);
        Assert.assertEquals((Object)ExpressionTypeFactory.getInstance().ofArray(ExpressionType.STRING_ARRAY), (Object)coerced.lhs);
        Assert.assertArrayEquals((Object[])new Object[]{new Object[]{"a", "b", "c"}, new Object[]{"d", "e", "f"}}, (Object[])((Object[])coerced.rhs));
        ImmutableMap nested2 = ImmutableMap.of((Object)"x", (Object)4L, (Object)"y", (Object)5L);
        ImmutableList listUnknownComplex = ImmutableList.of((Object)nested1, (Object)nested2);
        coerced = ExprEval.coerceListToArray((List)listUnknownComplex, (boolean)false);
        Assert.assertEquals((Object)ExpressionTypeFactory.getInstance().ofArray(ExpressionType.NESTED_DATA), (Object)coerced.lhs);
        Assert.assertArrayEquals((Object[])new Object[]{nested1, nested2}, (Object[])((Object[])coerced.rhs));
        ImmutableMap nested3 = ImmutableMap.of((Object)"x", (Object)5L, (Object)"y", (Object)7L);
        ImmutableMap nested4 = ImmutableMap.of((Object)"x", (Object)6L, (Object)"y", (Object)8L);
        ImmutableList nestedListsComplex = ImmutableList.of((Object)ImmutableList.of((Object)nested1, (Object)nested2), (Object)ImmutableList.of((Object)nested3, (Object)nested4));
        coerced = ExprEval.coerceListToArray((List)nestedListsComplex, (boolean)false);
        Assert.assertEquals((Object)ExpressionTypeFactory.getInstance().ofArray(ExpressionTypeFactory.getInstance().ofArray(ExpressionType.NESTED_DATA)), (Object)coerced.lhs);
        Assert.assertArrayEquals((Object[])new Object[]{new Object[]{nested1, nested2}, new Object[]{nested3, nested4}}, (Object[])((Object[])coerced.rhs));
        ImmutableList mixed = ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), (Object)ImmutableList.of((Object)1L, (Object)2L, (Object)3L), (Object)ImmutableList.of((Object)3.0, (Object)4.0, (Object)5.0), (Object)ImmutableList.of((Object)"a", (Object)2L, (Object)3.0));
        coerced = ExprEval.coerceListToArray((List)mixed, (boolean)false);
        Assert.assertEquals((Object)ExpressionTypeFactory.getInstance().ofArray(ExpressionType.STRING_ARRAY), (Object)coerced.lhs);
        Assert.assertArrayEquals((Object[])new Object[]{new Object[]{"a", "b", "c"}, new Object[]{"1", "2", "3"}, new Object[]{"3.0", "4.0", "5.0"}, new Object[]{"a", "2", "3.0"}}, (Object[])((Object[])coerced.rhs));
        ImmutableList mixedNested = ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), (Object)ImmutableList.of((Object)1L, (Object)2L, (Object)3L), (Object)ImmutableList.of((Object)3.0, (Object)4.0, (Object)5.0), (Object)ImmutableList.of((Object)"a", (Object)2L, (Object)3.0, (Object)nested1));
        coerced = ExprEval.coerceListToArray((List)mixedNested, (boolean)false);
        Assert.assertEquals((Object)ExpressionTypeFactory.getInstance().ofArray(ExpressionTypeFactory.getInstance().ofArray(ExpressionType.NESTED_DATA)), (Object)coerced.lhs);
        Assert.assertArrayEquals((Object[])new Object[]{new Object[]{"a", "b", "c"}, new Object[]{1L, 2L, 3L}, new Object[]{3.0, 4.0, 5.0}, new Object[]{"a", 2L, 3.0, nested1}}, (Object[])((Object[])coerced.rhs));
        ImmutableList mixedNested2 = ImmutableList.of((Object)"a", (Object)1L, (Object)3.0, (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), (Object)ImmutableList.of((Object)1L, (Object)2L, (Object)3L), (Object)ImmutableList.of((Object)3.0, (Object)4.0, (Object)5.0), (Object)ImmutableList.of((Object)nested1, (Object)nested2, (Object)nested3));
        coerced = ExprEval.coerceListToArray((List)mixedNested2, (boolean)false);
        Assert.assertEquals((Object)ExpressionTypeFactory.getInstance().ofArray(ExpressionTypeFactory.getInstance().ofArray(ExpressionType.NESTED_DATA)), (Object)coerced.lhs);
        Assert.assertArrayEquals((Object[])new Object[]{new Object[]{"a"}, new Object[]{1L}, new Object[]{3.0}, new Object[]{"a", "b", "c"}, new Object[]{1L, 2L, 3L}, new Object[]{3.0, 4.0, 5.0}, new Object[]{nested1, nested2, nested3}}, (Object[])((Object[])coerced.rhs));
        ImmutableList mixedNested3 = ImmutableList.of((Object)"a", (Object)1L, (Object)3.0, (Object)nested1, (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), (Object)ImmutableList.of((Object)1L, (Object)2L, (Object)3L), (Object)ImmutableList.of((Object)3.0, (Object)4.0, (Object)5.0), (Object)ImmutableList.of((Object)nested1, (Object)nested2, (Object)nested3));
        coerced = ExprEval.coerceListToArray((List)mixedNested3, (boolean)false);
        Assert.assertEquals((Object)ExpressionTypeFactory.getInstance().ofArray(ExpressionType.NESTED_DATA), (Object)coerced.lhs);
        Assert.assertArrayEquals((Object[])new Object[]{"a", 1L, 3.0, nested1, new Object[]{"a", "b", "c"}, new Object[]{1L, 2L, 3L}, new Object[]{3.0, 4.0, 5.0}, new Object[]{nested1, nested2, nested3}}, (Object[])((Object[])coerced.rhs));
        ImmutableList mixedUnknown = ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), (Object)ImmutableList.of((Object)1L, (Object)2L, (Object)3L), (Object)ImmutableList.of((Object)3.0, (Object)4.0, (Object)5.0, (Object)new SerializablePair((Object)"hello", (Object)1234L)), (Object)ImmutableList.of((Object)"a", (Object)2L, (Object)3.0, (Object)nested1));
        Throwable t = Assert.assertThrows(Types.IncompatibleTypeException.class, () -> ExprEvalTest.lambda$test_coerceListToArray$0((List)mixedUnknown));
        Assert.assertEquals((Object)"Cannot implicitly cast [DOUBLE] to [COMPLEX]", (Object)t.getMessage());
    }

    @Test
    public void testCastString() {
        ExprEval eval = ExprEval.of((String)"hello");
        ExprEval cast = eval.castTo(ExpressionType.DOUBLE);
        Assert.assertNull((Object)cast.value());
        cast = eval.castTo(ExpressionType.LONG);
        Assert.assertNull((Object)cast.value());
        cast = eval.castTo(ExpressionType.STRING_ARRAY);
        Assert.assertArrayEquals((Object[])new Object[]{"hello"}, (Object[])((Object[])cast.value()));
        cast = eval.castTo(ExpressionType.LONG_ARRAY);
        Assert.assertArrayEquals((Object[])new Object[]{null}, (Object[])((Object[])cast.value()));
        cast = eval.castTo(ExpressionType.DOUBLE_ARRAY);
        Assert.assertArrayEquals((Object[])new Object[]{null}, (Object[])((Object[])cast.value()));
        cast = eval.castTo(ExpressionType.NESTED_DATA);
        Assert.assertEquals((Object)"hello", (Object)cast.value());
        cast = eval.castTo(ExpressionTypeFactory.getInstance().ofArray(ExpressionType.NESTED_DATA));
        Assert.assertArrayEquals((Object[])new Object[]{"hello"}, (Object[])((Object[])cast.value()));
        eval = ExprEval.of((String)"1234.3");
        cast = eval.castTo(ExpressionType.DOUBLE);
        Assert.assertEquals((Object)1234.3, (Object)cast.value());
        cast = eval.castTo(ExpressionType.LONG);
        Assert.assertEquals((Object)1234L, (Object)cast.value());
        cast = eval.castTo(ExpressionType.DOUBLE_ARRAY);
        Assert.assertArrayEquals((Object[])new Object[]{1234.3}, (Object[])((Object[])cast.value()));
        cast = eval.castTo(ExpressionType.LONG_ARRAY);
        Assert.assertArrayEquals((Object[])new Object[]{1234L}, (Object[])((Object[])cast.value()));
        eval = ExprEval.ofType((ExpressionType)ExpressionType.STRING, null);
        cast = eval.castTo(ExpressionType.DOUBLE);
        Assert.assertNull((Object)cast.value());
        cast = eval.castTo(ExpressionType.LONG);
        Assert.assertNull((Object)cast.value());
        cast = eval.castTo(ExpressionType.STRING_ARRAY);
        Assert.assertNull((Object)cast.value());
        cast = eval.castTo(ExpressionType.LONG_ARRAY);
        Assert.assertNull((Object)cast.value());
        cast = eval.castTo(ExpressionType.DOUBLE_ARRAY);
        Assert.assertNull((Object)cast.value());
        cast = eval.castTo(ExpressionType.NESTED_DATA);
        Assert.assertNull((Object)cast.value());
    }

    @Test
    public void testCastDouble() {
        ExprEval eval = ExprEval.of((double)123.4);
        ExprEval cast = eval.castTo(ExpressionType.STRING);
        Assert.assertEquals((Object)"123.4", (Object)cast.value());
        cast = eval.castTo(ExpressionType.LONG);
        Assert.assertEquals((Object)123L, (Object)cast.value());
        cast = eval.castTo(ExpressionType.STRING_ARRAY);
        Assert.assertArrayEquals((Object[])new Object[]{"123.4"}, (Object[])((Object[])cast.value()));
        cast = eval.castTo(ExpressionType.LONG_ARRAY);
        Assert.assertArrayEquals((Object[])new Object[]{123L}, (Object[])((Object[])cast.value()));
        cast = eval.castTo(ExpressionType.DOUBLE_ARRAY);
        Assert.assertArrayEquals((Object[])new Object[]{123.4}, (Object[])((Object[])cast.value()));
        cast = eval.castTo(ExpressionType.NESTED_DATA);
        Assert.assertEquals((Object)123.4, (Object)cast.value());
        eval = ExprEval.ofType((ExpressionType)ExpressionType.DOUBLE, null);
        cast = eval.castTo(ExpressionType.STRING);
        Assert.assertNull((Object)cast.value());
        cast = eval.castTo(ExpressionType.LONG);
        Assert.assertNull((Object)cast.value());
        cast = eval.castTo(ExpressionType.STRING_ARRAY);
        Assert.assertNull((Object)cast.value());
        cast = eval.castTo(ExpressionType.LONG_ARRAY);
        Assert.assertNull((Object)cast.value());
        cast = eval.castTo(ExpressionType.DOUBLE_ARRAY);
        Assert.assertNull((Object)cast.value());
        cast = eval.castTo(ExpressionType.NESTED_DATA);
        Assert.assertNull((Object)cast.value());
    }

    @Test
    public void testCastLong() {
        ExprEval eval = ExprEval.of((long)1234L);
        ExprEval cast = eval.castTo(ExpressionType.STRING);
        Assert.assertEquals((Object)"1234", (Object)cast.value());
        cast = eval.castTo(ExpressionType.DOUBLE);
        Assert.assertEquals((Object)1234.0, (Object)cast.value());
        cast = eval.castTo(ExpressionType.STRING_ARRAY);
        Assert.assertArrayEquals((Object[])new Object[]{"1234"}, (Object[])((Object[])cast.value()));
        cast = eval.castTo(ExpressionType.LONG_ARRAY);
        Assert.assertArrayEquals((Object[])new Object[]{1234L}, (Object[])((Object[])cast.value()));
        cast = eval.castTo(ExpressionType.DOUBLE_ARRAY);
        Assert.assertArrayEquals((Object[])new Object[]{1234.0}, (Object[])((Object[])cast.value()));
        cast = eval.castTo(ExpressionType.NESTED_DATA);
        Assert.assertEquals((Object)1234L, (Object)cast.value());
        eval = ExprEval.ofType((ExpressionType)ExpressionType.LONG, null);
        cast = eval.castTo(ExpressionType.STRING);
        Assert.assertNull((Object)cast.value());
        cast = eval.castTo(ExpressionType.LONG);
        Assert.assertNull((Object)cast.value());
        cast = eval.castTo(ExpressionType.STRING_ARRAY);
        Assert.assertNull((Object)cast.value());
        cast = eval.castTo(ExpressionType.LONG_ARRAY);
        Assert.assertNull((Object)cast.value());
        cast = eval.castTo(ExpressionType.DOUBLE_ARRAY);
        Assert.assertNull((Object)cast.value());
        cast = eval.castTo(ExpressionType.NESTED_DATA);
        Assert.assertNull((Object)cast.value());
    }

    @Test
    public void testCastArray() {
        ExprEval eval = ExprEval.ofStringArray((Object[])new String[]{"1", "2", "foo", null, "3.3"});
        ExprEval cast = eval.castTo(ExpressionType.LONG_ARRAY);
        Assert.assertArrayEquals((Object[])new Object[]{1L, 2L, null, null, 3L}, (Object[])((Object[])cast.value()));
        cast = eval.castTo(ExpressionType.DOUBLE_ARRAY);
        Assert.assertArrayEquals((Object[])new Object[]{1.0, 2.0, null, null, 3.3}, (Object[])((Object[])cast.value()));
        cast = eval.castTo(ExpressionType.NESTED_DATA);
        Assert.assertArrayEquals((Object[])new Object[]{"1", "2", "foo", null, "3.3"}, (Object[])((Object[])cast.value()));
        cast = eval.castTo(ExpressionTypeFactory.getInstance().ofArray(ExpressionType.NESTED_DATA));
        Assert.assertArrayEquals((Object[])new Object[]{"1", "2", "foo", null, "3.3"}, (Object[])((Object[])cast.value()));
        cast = eval.castTo(ExpressionType.LONG);
        Assert.assertNull((Object)cast.value());
        cast = eval.castTo(ExpressionType.DOUBLE);
        Assert.assertNull((Object)cast.value());
        cast = eval.castTo(ExpressionType.STRING);
        Assert.assertNull((Object)cast.value());
        eval = ExprEval.ofType((ExpressionType)ExpressionType.LONG_ARRAY, (Object)new Object[]{1234L});
        cast = eval.castTo(ExpressionType.DOUBLE_ARRAY);
        Assert.assertArrayEquals((Object[])new Object[]{1234.0}, (Object[])((Object[])cast.value()));
        cast = eval.castTo(ExpressionType.STRING_ARRAY);
        Assert.assertArrayEquals((Object[])new Object[]{"1234"}, (Object[])((Object[])cast.value()));
        cast = eval.castTo(ExpressionType.STRING);
        Assert.assertEquals((Object)"1234", (Object)cast.value());
        cast = eval.castTo(ExpressionType.DOUBLE);
        Assert.assertEquals((Object)1234.0, (Object)cast.value());
        cast = eval.castTo(ExpressionType.LONG);
        Assert.assertEquals((Object)1234L, (Object)cast.value());
    }

    @Test
    public void testCastNestedData() {
        ExprEval eval = ExprEval.ofType((ExpressionType)ExpressionType.NESTED_DATA, (Object)ImmutableMap.of((Object)"x", (Object)1234L, (Object)"y", (Object)12.34));
        Assert.assertEquals((Object)ImmutableMap.of((Object)"x", (Object)1234L, (Object)"y", (Object)12.34), (Object)eval.castTo(ExpressionType.NESTED_DATA).value());
        Throwable t = Assert.assertThrows(IAE.class, () -> eval.castTo(ExpressionType.LONG));
        Assert.assertEquals((Object)"Invalid type, cannot cast [COMPLEX<json>] to [LONG]", (Object)t.getMessage());
    }

    @Test
    public void testEmptyArrayFromList() {
        ExprEval someEmptyArray = ExprEval.bestEffortOf(new ArrayList());
        Assert.assertTrue((boolean)someEmptyArray.isArray());
        Assert.assertEquals((long)0L, (long)someEmptyArray.asArray().length);
    }

    private void assertExpr(int position, Object expected) {
        this.assertExpr(position, ExprEval.bestEffortOf((Object)expected));
    }

    private void assertExpr(int position, ExprEval expected) {
        this.assertExpr(position, expected, MAX_SIZE_BYTES);
    }

    private void assertExpr(int position, ExprEval expected, int maxSizeBytes) {
        ExprEval.serialize((ByteBuffer)this.buffer, (int)position, (ExpressionType)expected.type(), (ExprEval)expected, (int)maxSizeBytes);
        if (expected.type().isArray()) {
            Assert.assertArrayEquals((String)"deserialized value with buffer references allowed", (Object[])expected.asArray(), (Object[])ExprEval.deserialize((ByteBuffer)this.buffer, (int)position, (int)MAX_SIZE_BYTES, (ExpressionType)expected.type(), (boolean)true).asArray());
            Assert.assertArrayEquals((String)"deserialized value with buffer references not allowed", (Object[])expected.asArray(), (Object[])ExprEval.deserialize((ByteBuffer)this.buffer, (int)position, (int)MAX_SIZE_BYTES, (ExpressionType)expected.type(), (boolean)false).asArray());
        } else {
            Assert.assertEquals((String)"deserialized value with buffer references allowed", (Object)expected.value(), (Object)ExprEval.deserialize((ByteBuffer)this.buffer, (int)position, (int)MAX_SIZE_BYTES, (ExpressionType)expected.type(), (boolean)true).value());
            Assert.assertEquals((String)"deserialized value with buffer references not allowed", (Object)expected.value(), (Object)ExprEval.deserialize((ByteBuffer)this.buffer, (int)position, (int)MAX_SIZE_BYTES, (ExpressionType)expected.type(), (boolean)false).value());
        }
    }

    private static /* synthetic */ void lambda$test_coerceListToArray$0(List mixedUnknown) throws Throwable {
        ExprEval.coerceListToArray((List)mixedUnknown, (boolean)false);
    }
}

