/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import org.apache.druid.metadata.DynamicConfigProvider;
import org.apache.druid.metadata.EnvironmentVariableDynamicConfigProvider;
import org.junit.Assert;
import org.junit.Test;

public class EnvironmentVariableDynamicConfigProviderTest {
    @Test
    public void testSerde() throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        String providerString = "{\"type\": \"environment\", \"variables\" : {\"testKey\":\"testValue\"}}";
        DynamicConfigProvider provider = (DynamicConfigProvider)objectMapper.readValue(providerString, DynamicConfigProvider.class);
        Assert.assertTrue((boolean)(provider instanceof EnvironmentVariableDynamicConfigProvider));
        Assert.assertEquals((Object)"testValue", ((EnvironmentVariableDynamicConfigProvider)provider).getVariables().get("testKey"));
        DynamicConfigProvider serde = (DynamicConfigProvider)objectMapper.readValue(objectMapper.writeValueAsString((Object)provider), DynamicConfigProvider.class);
        Assert.assertEquals((Object)provider, (Object)serde);
    }

    @Test
    public void testGetConfig() {
        final ImmutableMap env = ImmutableMap.of((Object)"DRUID_USER", (Object)"druid", (Object)"DRUID_PASSWORD", (Object)"123");
        ImmutableMap config = ImmutableMap.of((Object)"user", (Object)"DRUID_USER", (Object)"password", (Object)"DRUID_PASSWORD");
        EnvironmentVariableDynamicConfigProvider provider = new EnvironmentVariableDynamicConfigProvider((Map)config){

            protected String getEnv(String var) {
                return env.containsKey((Object)var) ? (String)env.get((Object)var) : super.getEnv(var);
            }
        };
        Assert.assertEquals((Object)"druid", provider.getConfig().get("user"));
        Assert.assertEquals((Object)"123", provider.getConfig().get("password"));
    }
}

