/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.JoinAlgorithm;
import org.apache.druid.query.JoinDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.RestrictedDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnionDataSource;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.NullFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.policy.NoRestrictionPolicy;
import org.apache.druid.query.policy.NoopPolicyEnforcer;
import org.apache.druid.query.policy.Policy;
import org.apache.druid.query.policy.PolicyEnforcer;
import org.apache.druid.query.policy.RestrictAllTablesPolicyEnforcer;
import org.apache.druid.query.policy.RowFilterPolicy;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.segment.join.NoopJoinableFactory;
import org.junit.Assert;
import org.junit.Test;

public class DataSourceTest {
    private static final ObjectMapper JSON_MAPPER = TestHelper.makeJsonMapper();

    @Test
    public void testSerialization() throws IOException {
        TableDataSource dataSource = new TableDataSource("somedatasource");
        String json = JSON_MAPPER.writeValueAsString((Object)dataSource);
        DataSource serdeDataSource = (DataSource)JSON_MAPPER.readValue(json, DataSource.class);
        Assert.assertEquals((Object)dataSource, (Object)serdeDataSource);
    }

    @Test
    public void testLegacyDataSource() throws IOException {
        DataSource dataSource = (DataSource)JSON_MAPPER.readValue("\"somedatasource\"", DataSource.class);
        Assert.assertEquals((Object)new TableDataSource("somedatasource"), (Object)dataSource);
    }

    @Test
    public void testTableDataSource() throws IOException {
        DataSource dataSource = (DataSource)JSON_MAPPER.readValue("{\"type\":\"table\", \"name\":\"somedatasource\"}", DataSource.class);
        Assert.assertEquals((Object)new TableDataSource("somedatasource"), (Object)dataSource);
    }

    @Test
    public void testRestrictedDataSource() throws IOException {
        DataSource dataSource = (DataSource)JSON_MAPPER.readValue("{\"type\":\"restrict\",\"base\":{\"type\":\"table\",\"name\":\"somedatasource\"},\"policy\":{\"type\":\"noRestriction\"}}\n", DataSource.class);
        Assert.assertEquals((Object)RestrictedDataSource.create((DataSource)TableDataSource.create((String)"somedatasource"), (Policy)NoRestrictionPolicy.instance()), (Object)dataSource);
    }

    @Test
    public void testQueryDataSource() throws IOException {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        String dataSourceJSON = "{\"type\":\"query\", \"query\":" + JSON_MAPPER.writeValueAsString((Object)query) + "}";
        DataSource dataSource = (DataSource)JSON_MAPPER.readValue(dataSourceJSON, DataSource.class);
        Assert.assertEquals((Object)new QueryDataSource((Query)query), (Object)dataSource);
    }

    @Test
    public void testUnionDataSource() throws Exception {
        DataSource dataSource = (DataSource)JSON_MAPPER.readValue("{\"type\":\"union\", \"dataSources\":[\"ds1\", \"ds2\"]}", DataSource.class);
        Assert.assertTrue((boolean)(dataSource instanceof UnionDataSource));
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new TableDataSource[]{new TableDataSource("ds1"), new TableDataSource("ds2")}), (Object)Lists.newArrayList((Iterable)dataSource.getChildren()));
        Assert.assertEquals((Object)ImmutableSet.of((Object)"ds1", (Object)"ds2"), (Object)dataSource.getTableNames());
        DataSource serde = (DataSource)JSON_MAPPER.readValue(JSON_MAPPER.writeValueAsString((Object)dataSource), DataSource.class);
        Assert.assertEquals((Object)dataSource, (Object)serde);
    }

    @Test
    public void testWithPolicies_onUnionDataSource() {
        TableDataSource table1 = TableDataSource.create((String)"table1");
        TableDataSource table2 = TableDataSource.create((String)"table2");
        InlineDataSource inlineDataSource = InlineDataSource.fromIterable((Iterable)ImmutableList.of(), (RowSignature)RowSignature.empty());
        UnionDataSource unionDataSource = new UnionDataSource((List)Lists.newArrayList((Object[])new DataSource[]{table1, table2, inlineDataSource}));
        ImmutableMap restrictions = ImmutableMap.of((Object)"table1", Optional.of(NoRestrictionPolicy.instance()), (Object)"table2", Optional.of(RowFilterPolicy.from((DimFilter)new NullFilter("some-column", null))));
        RestrictAllTablesPolicyEnforcer policyEnforcer = new RestrictAllTablesPolicyEnforcer(null);
        Assert.assertEquals((Object)unionDataSource.withPolicies((Map)restrictions, (PolicyEnforcer)policyEnforcer), (Object)new UnionDataSource((List)Lists.newArrayList((Object[])new DataSource[]{RestrictedDataSource.create((DataSource)table1, (Policy)NoRestrictionPolicy.instance()), RestrictedDataSource.create((DataSource)table2, (Policy)RowFilterPolicy.from((DimFilter)new NullFilter("some-column", null))), inlineDataSource})));
    }

    @Test
    public void testWithPolicies_onUnionDataSource_throwsOnValidation() {
        TableDataSource table1 = TableDataSource.create((String)"table1");
        TableDataSource table2 = TableDataSource.create((String)"table2");
        InlineDataSource inlineDataSource = InlineDataSource.fromIterable((Iterable)ImmutableList.of(), (RowSignature)RowSignature.empty());
        UnionDataSource unionDataSource = new UnionDataSource((List)Lists.newArrayList((Object[])new DataSource[]{table1, table2, inlineDataSource}));
        ImmutableMap restrictions = ImmutableMap.of((Object)"table1", Optional.of(NoRestrictionPolicy.instance()), (Object)"table2", Optional.of(RowFilterPolicy.from((DimFilter)new NullFilter("some-column", null))));
        RestrictAllTablesPolicyEnforcer policyEnforcer = new RestrictAllTablesPolicyEnforcer((List)ImmutableList.of((Object)NoRestrictionPolicy.class.getName()));
        DruidException e = (DruidException)Assert.assertThrows(DruidException.class, () -> DataSourceTest.lambda$testWithPolicies_onUnionDataSource_throwsOnValidation$0(unionDataSource, restrictions, (PolicyEnforcer)policyEnforcer));
        Assert.assertEquals((Object)DruidException.Category.FORBIDDEN, (Object)e.getCategory());
        Assert.assertEquals((Object)DruidException.Persona.OPERATOR, (Object)e.getTargetPersona());
        Assert.assertEquals((Object)"Failed security validation with dataSource [table2]", (Object)e.getMessage());
    }

    @Test
    public void testWithPolicies_onRestrictedDataSource_fromDruidSystem() {
        RestrictedDataSource restrictedDataSource = RestrictedDataSource.create((DataSource)TableDataSource.create((String)"table1"), (Policy)RowFilterPolicy.from((DimFilter)new NullFilter("some-column", null)));
        ImmutableMap noRestrictionPolicy = ImmutableMap.of((Object)"table1", Optional.of(NoRestrictionPolicy.instance()));
        RestrictAllTablesPolicyEnforcer policyEnforcer = new RestrictAllTablesPolicyEnforcer(null);
        Assert.assertEquals((Object)restrictedDataSource, (Object)restrictedDataSource.withPolicies((Map)noRestrictionPolicy, (PolicyEnforcer)policyEnforcer));
    }

    @Test
    public void testWithPolicies_onRestrictedDataSource_samePolicy() {
        RestrictedDataSource restrictedDataSource = RestrictedDataSource.create((DataSource)TableDataSource.create((String)"table1"), (Policy)RowFilterPolicy.from((DimFilter)new NullFilter("some-column", null)));
        ImmutableMap policyMap = ImmutableMap.of((Object)"table1", Optional.of(RowFilterPolicy.from((DimFilter)new NullFilter("some-column", null))));
        RestrictAllTablesPolicyEnforcer policyEnforcer = new RestrictAllTablesPolicyEnforcer(null);
        Assert.assertEquals((Object)restrictedDataSource, (Object)restrictedDataSource.withPolicies((Map)policyMap, (PolicyEnforcer)policyEnforcer));
    }

    @Test
    public void testWithPolicies_onRestrictedDataSource_alwaysThrows() {
        RestrictedDataSource restrictedDataSource = RestrictedDataSource.create((DataSource)TableDataSource.create((String)"table1"), (Policy)RowFilterPolicy.from((DimFilter)new NullFilter("random-column", null)));
        ImmutableMap anotherRestrictions = ImmutableMap.of((Object)"table1", Optional.of(RowFilterPolicy.from((DimFilter)new NullFilter("some-column", null))));
        ImmutableMap noPolicyFound = ImmutableMap.of((Object)"table1", Optional.empty());
        ImmutableMap policyWasNotChecked = ImmutableMap.of();
        RestrictAllTablesPolicyEnforcer policyEnforcer = new RestrictAllTablesPolicyEnforcer(null);
        ISE e = (ISE)Assert.assertThrows(ISE.class, () -> DataSourceTest.lambda$testWithPolicies_onRestrictedDataSource_alwaysThrows$1(restrictedDataSource, anotherRestrictions, (PolicyEnforcer)policyEnforcer));
        Assert.assertEquals((Object)"Different restrictions on table [table1]: previous policy [RowFilterPolicy{rowFilter=random-column IS NULL}] and new policy [RowFilterPolicy{rowFilter=some-column IS NULL}]", (Object)e.getMessage());
        ISE e3 = (ISE)Assert.assertThrows(ISE.class, () -> DataSourceTest.lambda$testWithPolicies_onRestrictedDataSource_alwaysThrows$2(restrictedDataSource, policyWasNotChecked, (PolicyEnforcer)policyEnforcer));
        Assert.assertEquals((Object)"Missing policy check result for table [table1]", (Object)e3.getMessage());
    }

    @Test
    public void testWithPolicies_onInlineDataSource() {
        InlineDataSource inlineDataSource = InlineDataSource.fromIterable((Iterable)ImmutableList.of(), (RowSignature)RowSignature.empty());
        DataSource withPolicies = inlineDataSource.withPolicies((Map)ImmutableMap.of(), (PolicyEnforcer)NoopPolicyEnforcer.instance());
        Assert.assertEquals((Object)inlineDataSource, (Object)withPolicies);
    }

    @Test
    public void testWithPolicies_onJoinDataSource() {
        JoinableFactoryWrapper joinableFactoryWrapper = new JoinableFactoryWrapper((JoinableFactory)NoopJoinableFactory.INSTANCE);
        JoinDataSource joinDataSource = JoinDataSource.create((DataSource)new TableDataSource("table1"), (DataSource)new TableDataSource("table2"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)joinableFactoryWrapper, (JoinAlgorithm)JoinAlgorithm.BROADCAST);
        NoopPolicyEnforcer policyEnforcer = NoopPolicyEnforcer.instance();
        DataSource mapped = joinDataSource.withPolicies((Map)ImmutableMap.of(), (PolicyEnforcer)policyEnforcer);
        Assert.assertEquals((Object)joinDataSource, (Object)mapped);
        RestrictAllTablesPolicyEnforcer restrictAllTablesPolicyEnforcer = new RestrictAllTablesPolicyEnforcer(null);
        Assert.assertThrows(DruidException.class, () -> DataSourceTest.lambda$testWithPolicies_onJoinDataSource$3(joinDataSource, (PolicyEnforcer)restrictAllTablesPolicyEnforcer));
        Assert.assertThrows(DruidException.class, () -> DataSourceTest.lambda$testWithPolicies_onJoinDataSource$4(joinDataSource, (PolicyEnforcer)restrictAllTablesPolicyEnforcer));
        DataSource mapped2 = joinDataSource.withPolicies((Map)ImmutableMap.of((Object)"table1", Optional.of(NoRestrictionPolicy.instance()), (Object)"table2", Optional.of(NoRestrictionPolicy.instance())), (PolicyEnforcer)restrictAllTablesPolicyEnforcer);
        JoinDataSource expected = JoinDataSource.create((DataSource)RestrictedDataSource.create((DataSource)new TableDataSource("table1"), (Policy)NoRestrictionPolicy.instance()), (DataSource)RestrictedDataSource.create((DataSource)new TableDataSource("table2"), (Policy)NoRestrictionPolicy.instance()), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)joinableFactoryWrapper, (JoinAlgorithm)JoinAlgorithm.BROADCAST);
        Assert.assertEquals((Object)expected, (Object)mapped2);
    }

    private static /* synthetic */ void lambda$testWithPolicies_onJoinDataSource$4(JoinDataSource joinDataSource, PolicyEnforcer restrictAllTablesPolicyEnforcer) throws Throwable {
        joinDataSource.withPolicies((Map)ImmutableMap.of((Object)"table1", Optional.of(NoRestrictionPolicy.instance())), restrictAllTablesPolicyEnforcer);
    }

    private static /* synthetic */ void lambda$testWithPolicies_onJoinDataSource$3(JoinDataSource joinDataSource, PolicyEnforcer restrictAllTablesPolicyEnforcer) throws Throwable {
        joinDataSource.withPolicies((Map)ImmutableMap.of(), restrictAllTablesPolicyEnforcer);
    }

    private static /* synthetic */ void lambda$testWithPolicies_onRestrictedDataSource_alwaysThrows$2(RestrictedDataSource restrictedDataSource, ImmutableMap policyWasNotChecked, PolicyEnforcer policyEnforcer) throws Throwable {
        restrictedDataSource.withPolicies((Map)policyWasNotChecked, policyEnforcer);
    }

    private static /* synthetic */ void lambda$testWithPolicies_onRestrictedDataSource_alwaysThrows$1(RestrictedDataSource restrictedDataSource, ImmutableMap anotherRestrictions, PolicyEnforcer policyEnforcer) throws Throwable {
        restrictedDataSource.withPolicies((Map)anotherRestrictions, policyEnforcer);
    }

    private static /* synthetic */ void lambda$testWithPolicies_onUnionDataSource_throwsOnValidation$0(UnionDataSource unionDataSource, ImmutableMap restrictions, PolicyEnforcer policyEnforcer) throws Throwable {
        unionDataSource.withPolicies((Map)restrictions, policyEnforcer);
    }
}

