/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.cache;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.junit.Assert;
import org.junit.Test;

public class CacheKeyBuilderTest {
    @Test
    public void testCacheKeyBuilder() {
        Cacheable cacheable = () -> new byte[]{10, 20};
        byte[] actual = new CacheKeyBuilder(10).appendBoolean(false).appendString("test").appendInt(10).appendLong(Long.MAX_VALUE).appendFloat(0.1f).appendDouble(2.3).appendByteArray(CacheKeyBuilder.STRING_SEPARATOR).appendFloatArray(new float[]{10.0f, 11.0f}).appendStrings((Collection)Lists.newArrayList((Object[])new String[]{"test1", "test2"})).appendCacheable(cacheable).appendCacheable(null).appendCacheables((Collection)Lists.newArrayList((Object[])new Cacheable[]{cacheable, null, cacheable})).build();
        int expectedSize = 30 + CacheKeyBuilder.STRING_SEPARATOR.length + 8 + 4 + 10 + 1 + cacheable.getCacheKey().length + 4 + 4 + 12;
        Assert.assertEquals((long)expectedSize, (long)actual.length);
        byte[] expected = ByteBuffer.allocate(expectedSize).put((byte)10).put((byte)2).put((byte)0).put((byte)7).put(StringUtils.toUtf8((String)"test")).put((byte)3).putInt(10).put((byte)12).putLong(Long.MAX_VALUE).put((byte)4).putFloat(0.1f).put((byte)6).putDouble(2.3).put((byte)1).put(CacheKeyBuilder.STRING_SEPARATOR).put((byte)5).putFloat(10.0f).putFloat(11.0f).put((byte)8).putInt(2).put(StringUtils.toUtf8((String)"test1")).put(CacheKeyBuilder.STRING_SEPARATOR).put(StringUtils.toUtf8((String)"test2")).put((byte)9).put(cacheable.getCacheKey()).put((byte)9).put((byte)10).putInt(3).put(cacheable.getCacheKey()).put(cacheable.getCacheKey()).array();
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    @Test
    public void testDifferentOrderList() {
        byte[] key1 = new CacheKeyBuilder(10).appendStringsIgnoringOrder((Collection)Lists.newArrayList((Object[])new String[]{"AB", "BA"})).build();
        byte[] key2 = new CacheKeyBuilder(10).appendStringsIgnoringOrder((Collection)Lists.newArrayList((Object[])new String[]{"BA", "AB"})).build();
        Assert.assertArrayEquals((byte[])key1, (byte[])key2);
        Cacheable cacheable1 = () -> new byte[]{1};
        Cacheable cacheable2 = () -> new byte[]{2};
        key1 = new CacheKeyBuilder(10).appendCacheablesIgnoringOrder((Collection)Lists.newArrayList((Object[])new Cacheable[]{cacheable1, cacheable2})).build();
        key2 = new CacheKeyBuilder(10).appendCacheablesIgnoringOrder((Collection)Lists.newArrayList((Object[])new Cacheable[]{cacheable2, cacheable1})).build();
        Assert.assertArrayEquals((byte[])key1, (byte[])key2);
    }

    @Test
    public void testNotEqualStrings() {
        ArrayList<byte[]> keys = new ArrayList<byte[]>();
        keys.add(new CacheKeyBuilder(10).appendString("test").appendString("test").build());
        keys.add(new CacheKeyBuilder(10).appendString("testtest").build());
        keys.add(new CacheKeyBuilder(10).appendString("testtest").appendString("").build());
        keys.add(new CacheKeyBuilder(10).appendString("").appendString("testtest").build());
        keys.add(new CacheKeyBuilder(10).appendStrings((Collection)ImmutableList.of((Object)"test", (Object)"test")).build());
        keys.add(new CacheKeyBuilder(10).appendStrings((Collection)ImmutableList.of((Object)"testtest")).build());
        keys.add(new CacheKeyBuilder(10).appendStrings((Collection)ImmutableList.of((Object)"testtest", (Object)"")).build());
        keys.add(new CacheKeyBuilder(10).appendStrings((Collection)ImmutableList.of((Object)"testtest")).appendStrings((Collection)ImmutableList.of()).build());
        keys.add(new CacheKeyBuilder(10).appendStrings((Collection)ImmutableList.of()).appendStrings((Collection)ImmutableList.of((Object)"testtest")).build());
        CacheKeyBuilderTest.assertNotEqualsEachOther(keys);
    }

    @Test
    public void testNotEqualCacheables() {
        Cacheable test = () -> StringUtils.toUtf8((String)"test");
        Cacheable testtest = () -> StringUtils.toUtf8((String)"testtest");
        ArrayList<byte[]> keys = new ArrayList<byte[]>();
        keys.add(new CacheKeyBuilder(10).appendCacheable(test).appendCacheable(test).build());
        keys.add(new CacheKeyBuilder(10).appendCacheable(testtest).build());
        keys.add(new CacheKeyBuilder(10).appendCacheables((Collection)Lists.newArrayList((Object[])new Cacheable[]{test, test})).build());
        keys.add(new CacheKeyBuilder(10).appendCacheables(Collections.singletonList(testtest)).build());
        keys.add(new CacheKeyBuilder(10).appendCacheables(Collections.singletonList(testtest)).appendCacheables(new ArrayList()).build());
        keys.add(new CacheKeyBuilder(10).appendCacheables(new ArrayList()).appendCacheables(Collections.singletonList(testtest)).build());
        CacheKeyBuilderTest.assertNotEqualsEachOther(keys);
    }

    private static void assertNotEqualsEachOther(List<byte[]> keys) {
        for (int i = 0; i < keys.size(); ++i) {
            for (int j = i + 1; j < keys.size(); ++j) {
                Assert.assertFalse((boolean)Arrays.equals(keys.get(i), keys.get(j)));
            }
        }
    }

    @Test
    public void testEmptyOrNullStringLists() {
        byte[] key1 = new CacheKeyBuilder(10).appendStrings((Collection)Lists.newArrayList((Object[])new String[]{"", ""})).build();
        byte[] key2 = new CacheKeyBuilder(10).appendStrings(Collections.singletonList("")).build();
        Assert.assertFalse((boolean)Arrays.equals(key1, key2));
        key1 = new CacheKeyBuilder(10).appendStrings(Collections.singletonList("")).build();
        key2 = new CacheKeyBuilder(10).appendStrings(Collections.singletonList(null)).build();
        Assert.assertArrayEquals((byte[])key1, (byte[])key2);
    }

    @Test
    public void testEmptyOrNullCacheables() {
        byte[] key1 = new CacheKeyBuilder(10).appendCacheables(new ArrayList()).build();
        byte[] key2 = new CacheKeyBuilder(10).appendCacheables(Collections.singletonList(null)).build();
        Assert.assertFalse((boolean)Arrays.equals(key1, key2));
    }

    @Test
    public void testIgnoringOrder() {
        byte[] actual = new CacheKeyBuilder(10).appendStringsIgnoringOrder((Collection)Lists.newArrayList((Object[])new String[]{"test2", "test1", "te"})).build();
        byte[] expected = ByteBuffer.allocate(20).put((byte)10).put((byte)8).putInt(3).put(StringUtils.toUtf8((String)"te")).put(CacheKeyBuilder.STRING_SEPARATOR).put(StringUtils.toUtf8((String)"test1")).put(CacheKeyBuilder.STRING_SEPARATOR).put(StringUtils.toUtf8((String)"test2")).array();
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        Cacheable c1 = () -> StringUtils.toUtf8((String)"te");
        Cacheable c2 = () -> StringUtils.toUtf8((String)"test1");
        Cacheable c3 = () -> StringUtils.toUtf8((String)"test2");
        actual = new CacheKeyBuilder(10).appendCacheablesIgnoringOrder((Collection)Lists.newArrayList((Object[])new Cacheable[]{c3, c2, c1})).build();
        expected = ByteBuffer.allocate(18).put((byte)10).put((byte)10).putInt(3).put(c1.getCacheKey()).put(c2.getCacheKey()).put(c3.getCacheKey()).array();
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
    }
}

