/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionProcessingException;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.ExpressionTypeFactory;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.query.expression.NestedDataExpressions;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class NestedDataExpressionsTest
extends InitializedNullHandlingTest {
    private static final ObjectMapper JSON_MAPPER = new DefaultObjectMapper();
    private static final ExprMacroTable MACRO_TABLE = new ExprMacroTable((List)ImmutableList.of((Object)new NestedDataExpressions.JsonPathsExprMacro(), (Object)new NestedDataExpressions.JsonKeysExprMacro(), (Object)new NestedDataExpressions.JsonObjectExprMacro(), (Object)new NestedDataExpressions.JsonMergeExprMacro(JSON_MAPPER), (Object)new NestedDataExpressions.JsonValueExprMacro(), (Object)new NestedDataExpressions.JsonQueryExprMacro(), (Object)new NestedDataExpressions.JsonQueryArrayExprMacro(), (Object)new NestedDataExpressions.ToJsonStringExprMacro(JSON_MAPPER), (Object)new NestedDataExpressions.ParseJsonExprMacro(JSON_MAPPER), (Object)new NestedDataExpressions.TryParseJsonExprMacro(JSON_MAPPER)));
    private static final Map<String, Object> NEST = ImmutableMap.of((Object)"x", (Object)100L, (Object)"y", (Object)200L, (Object)"z", (Object)300L);
    private static final Map<String, Object> NESTER = ImmutableMap.of((Object)"x", (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), (Object)"y", (Object)ImmutableMap.of((Object)"a", (Object)"hello", (Object)"b", (Object)"world"));
    private static final Map<String, Object> NESTERER = ImmutableMap.of((Object)"x", (Object)ImmutableMap.of((Object)"a1", Arrays.asList(1, null, 3), (Object)"a2", Arrays.asList(1.1, null, 3.3), (Object)"a3", Arrays.asList("a", null, "b", "100")), (Object)"y", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"x", (Object)1L, (Object)"y", (Object)1.1), (Object)ImmutableMap.of((Object)"x", (Object)2L, (Object)"y", (Object)2.2), (Object)ImmutableMap.of((Object)"x", (Object)3L, (Object)"y", (Object)3.3)));
    Expr.ObjectBinding inputBindings = InputBindings.forInputSuppliers((Map)new ImmutableMap.Builder().put((Object)"nest", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.NESTED_DATA, () -> NEST)).put((Object)"nestWrapped", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.NESTED_DATA, () -> new StructuredData(NEST))).put((Object)"nester", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.NESTED_DATA, () -> NESTER)).put((Object)"nesterer", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.NESTED_DATA, () -> NESTERER)).put((Object)"string", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.STRING, () -> "abcdef")).put((Object)"long", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.LONG, () -> 1234L)).put((Object)"double", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.DOUBLE, () -> 1.234)).put((Object)"nullString", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.STRING, () -> null)).put((Object)"nullLong", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.LONG, () -> null)).put((Object)"nullDouble", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.DOUBLE, () -> null)).build());

    @Test
    public void testJsonObjectExpression() {
        Expr expr = Parser.parse((String)"json_object('x',100,'y',200,'z',300)", (ExprMacroTable)MACRO_TABLE);
        ExprEval eval = expr.eval(this.inputBindings);
        Assert.assertEquals(NEST, (Object)eval.value());
        expr = Parser.parse((String)"json_object('x',array('a','b','c'),'y',json_object('a','hello','b','world'))", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertArrayEquals((Object[])new Object[]{"a", "b", "c"}, (Object[])((Object[])((Map)eval.value()).get("x")));
        Assert.assertEquals((Object)ImmutableMap.of((Object)"a", (Object)"hello", (Object)"b", (Object)"world"), ((Map)eval.value()).get("y"));
    }

    @Test
    public void testJsonMergeExpression() throws JsonProcessingException {
        Expr expr = Parser.parse((String)"json_merge('{\"a\":\"x\"}','{\"b\":\"y\"}')", (ExprMacroTable)MACRO_TABLE);
        ExprEval eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)"{\"a\":\"x\",\"b\":\"y\"}", (Object)JSON_MAPPER.writeValueAsString(eval.value()));
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)eval.type());
        expr = Parser.parse((String)"json_merge('{\"a\":\"x\"}', null)", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)"null", (Object)JSON_MAPPER.writeValueAsString(eval.value()));
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)eval.type());
        expr = Parser.parse((String)"json_merge('{\"a\":\"x\"}','{\"b\":\"y\"}','{\"c\":[1,2,3]}')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)"{\"a\":\"x\",\"b\":\"y\",\"c\":[1,2,3]}", (Object)JSON_MAPPER.writeValueAsString(eval.value()));
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)eval.type());
        expr = Parser.parse((String)"json_merge(json_object('a', 'x'),json_object('b', 'y'))", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)"{\"a\":\"x\",\"b\":\"y\"}", (Object)JSON_MAPPER.writeValueAsString(eval.value()));
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)eval.type());
        expr = Parser.parse((String)"json_merge('{\"a\":\"x\"}',json_merge('{\"a\":\"z\"}','{\"a\":\"y\"}'))", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)"{\"a\":\"y\"}", (Object)JSON_MAPPER.writeValueAsString(eval.value()));
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)eval.type());
        expr = Parser.parse((String)"json_merge('[\"a\", \"b\"]', '[\"c\", \"d\"]')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)"[\"a\",\"b\",\"c\",\"d\"]", (Object)JSON_MAPPER.writeValueAsString(eval.value()));
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)eval.type());
    }

    @Test
    public void testJsonMergeWithNullAndEmptyExpressions() throws JsonProcessingException {
        Expr expr = Parser.parse((String)"json_merge(null, null)", (ExprMacroTable)MACRO_TABLE);
        ExprEval eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)"null", (Object)JSON_MAPPER.writeValueAsString(eval.value()));
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)eval.type());
        expr = Parser.parse((String)"json_merge(null, '{\"a\":\"x\"}')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)"null", (Object)JSON_MAPPER.writeValueAsString(eval.value()));
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)eval.type());
        expr = Parser.parse((String)"json_merge('{\"a\":\"x\"}', null)", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)"null", (Object)JSON_MAPPER.writeValueAsString(eval.value()));
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)eval.type());
        expr = Parser.parse((String)"json_merge('{\"a\":\"x\"}', null, null, null)", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)"null", (Object)JSON_MAPPER.writeValueAsString(eval.value()));
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)eval.type());
        expr = Parser.parse((String)"json_merge('{\"a\":\"x\"}', null, null, json_object())", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)"null", (Object)JSON_MAPPER.writeValueAsString(eval.value()));
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)eval.type());
        expr = Parser.parse((String)"json_merge(json_object(), json_object(), json_object())", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)"{}", (Object)JSON_MAPPER.writeValueAsString(eval.value()));
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)eval.type());
        expr = Parser.parse((String)"json_merge(json_object(), json_object(), json_object(), null)", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)"null", (Object)JSON_MAPPER.writeValueAsString(eval.value()));
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)eval.type());
        expr = Parser.parse((String)"json_merge(json_object(), json_object(), json_object(), coalesce(null, '{}'))", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)"{}", (Object)JSON_MAPPER.writeValueAsString(eval.value()));
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)eval.type());
        expr = Parser.parse((String)"json_merge(coalesce(null, '{}'), '{\"a\":\"x\"}')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)"{\"a\":\"x\"}", (Object)JSON_MAPPER.writeValueAsString(eval.value()));
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)eval.type());
    }

    @Test
    public void testJsonMergeOverflow() throws JsonProcessingException {
        Expr.ObjectBinding input1 = InputBindings.forInputSuppliers((Map)new ImmutableMap.Builder().put((Object)"attr", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.NESTED_DATA, () -> ImmutableMap.of((Object)"key", (Object)"blah", (Object)"value", (Object)"blahblah"))).build());
        Expr.ObjectBinding input2 = InputBindings.forInputSuppliers((Map)new ImmutableMap.Builder().put((Object)"attr", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.NESTED_DATA, () -> ImmutableMap.of((Object)"key", (Object)"blah2", (Object)"value", (Object)"blahblah2"))).build());
        Expr expr = Parser.parse((String)"json_merge(json_object(), json_object(json_value(attr, '$.key'), json_value(attr, '$.value')))", (ExprMacroTable)MACRO_TABLE);
        ExprEval eval = expr.eval(input1);
        Assert.assertEquals((Object)"{\"blah\":\"blahblah\"}", (Object)JSON_MAPPER.writeValueAsString(eval.value()));
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)eval.type());
        eval = expr.eval(input2);
        Assert.assertEquals((Object)"{\"blah2\":\"blahblah2\"}", (Object)JSON_MAPPER.writeValueAsString(eval.value()));
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)eval.type());
    }

    @Test
    public void testJsonKeysExpression() {
        Expr expr = Parser.parse((String)"json_keys(nest, '$.')", (ExprMacroTable)MACRO_TABLE);
        ExprEval eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{"x", "y", "z"}, (Object[])((Object[])eval.value()));
        expr = Parser.parse((String)"json_keys(nester, '$.x')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{"0", "1", "2"}, (Object[])((Object[])eval.value()));
        expr = Parser.parse((String)"json_keys(nester, '$.y')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{"a", "b"}, (Object[])((Object[])eval.value()));
        expr = Parser.parse((String)"json_keys(nester, '$.x.a')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertNull((Object)eval.value());
        expr = Parser.parse((String)"json_keys(nester, '$.x.a.b')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertNull((Object)eval.value());
    }

    @Test
    public void testJsonPathsExpression() {
        Expr expr = Parser.parse((String)"json_paths(nest)", (ExprMacroTable)MACRO_TABLE);
        ExprEval eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{"$.x", "$.y", "$.z"}, (Object[])((Object[])eval.value()));
        expr = Parser.parse((String)"json_paths(nester)", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{"$.x", "$.y.a", "$.y.b"}, (Object[])((Object[])eval.value()));
    }

    @Test
    public void testJsonValueExpression() {
        Expr expr = Parser.parse((String)"json_value(nest, '$.x')", (ExprMacroTable)MACRO_TABLE);
        ExprEval eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)100L, (Object)eval.value());
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)eval.type());
        expr = Parser.parse((String)"json_value(nester, '$.x')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertArrayEquals((Object[])new Object[]{"a", "b", "c"}, (Object[])((Object[])eval.value()));
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)eval.type());
        expr = Parser.parse((String)"json_value(nester, '$.x[1]')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)"b", (Object)eval.value());
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)eval.type());
        expr = Parser.parse((String)"json_value(nester, '$.x[23]')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertNull((Object)eval.value());
        expr = Parser.parse((String)"json_value(nester, '$.x[1].b')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertNull((Object)eval.value());
        expr = Parser.parse((String)"json_value(nester, '$.y[1]')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertNull((Object)eval.value());
        expr = Parser.parse((String)"json_value(nester, '$.y.a')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)"hello", (Object)eval.value());
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)eval.type());
        expr = Parser.parse((String)"json_value(nester, '$.y.a', 'LONG')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertNull((Object)eval.value());
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)eval.type());
        expr = Parser.parse((String)"json_value(nester, '$.y.a.b.c[12]')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertNull((Object)eval.value());
        expr = Parser.parse((String)"json_value(long, '$')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)1234L, (Object)eval.value());
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)eval.type());
        expr = Parser.parse((String)"json_value(long, '$', 'STRING')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)"1234", (Object)eval.value());
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)eval.type());
        expr = Parser.parse((String)"json_value(nest, '$.x')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)100L, (Object)eval.value());
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)eval.type());
        expr = Parser.parse((String)"json_value(nest, '$.x', 'DOUBLE')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)100.0, (Object)eval.value());
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)eval.type());
        expr = Parser.parse((String)"json_value(nest, '$.x', 'STRING')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)"100", (Object)eval.value());
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)eval.type());
        expr = Parser.parse((String)"json_value(nesterer, '$.x.a1')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertArrayEquals((Object[])new Object[]{1L, null, 3L}, (Object[])((Object[])eval.value()));
        Assert.assertEquals((Object)ExpressionType.LONG_ARRAY, (Object)eval.type());
        expr = Parser.parse((String)"json_value(nesterer, '$.x.a1', 'ARRAY<STRING>')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertArrayEquals((Object[])new Object[]{"1", null, "3"}, (Object[])((Object[])eval.value()));
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)eval.type());
        expr = Parser.parse((String)"json_value(nesterer, '$.x.a1', 'ARRAY<DOUBLE>')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertArrayEquals((Object[])new Object[]{1.0, null, 3.0}, (Object[])((Object[])eval.value()));
        Assert.assertEquals((Object)ExpressionType.DOUBLE_ARRAY, (Object)eval.type());
        expr = Parser.parse((String)"json_value(nesterer, '$.x.a2')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertArrayEquals((Object[])new Object[]{1.1, null, 3.3}, (Object[])((Object[])eval.value()));
        Assert.assertEquals((Object)ExpressionType.DOUBLE_ARRAY, (Object)eval.type());
        expr = Parser.parse((String)"json_value(nesterer, '$.x.a2', 'ARRAY<LONG>')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertArrayEquals((Object[])new Object[]{1L, null, 3L}, (Object[])((Object[])eval.value()));
        Assert.assertEquals((Object)ExpressionType.LONG_ARRAY, (Object)eval.type());
        expr = Parser.parse((String)"json_value(nesterer, '$.x.a2', 'ARRAY<STRING>')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertArrayEquals((Object[])new Object[]{"1.1", null, "3.3"}, (Object[])((Object[])eval.value()));
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)eval.type());
        expr = Parser.parse((String)"json_value(nesterer, '$.x.a3')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertArrayEquals((Object[])new Object[]{"a", null, "b", "100"}, (Object[])((Object[])eval.value()));
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)eval.type());
        expr = Parser.parse((String)"json_value(nesterer, '$.x.a3', 'ARRAY<LONG>')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertArrayEquals((Object[])new Object[]{null, null, null, 100L}, (Object[])((Object[])eval.value()));
        Assert.assertEquals((Object)ExpressionType.LONG_ARRAY, (Object)eval.type());
        expr = Parser.parse((String)"json_value(nesterer, '$.y')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertNull((Object)eval.value());
        expr = Parser.parse((String)"json_value(json_object('k1', array(1,2,3), 'k2', array('a', 'b', 'c')), '$.k1', 'ARRAY<STRING>')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertArrayEquals((Object[])new Object[]{"1", "2", "3"}, (Object[])((Object[])eval.value()));
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)eval.type());
        expr = Parser.parse((String)"json_value(nester, array_offset(json_paths(nester), 0))", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertArrayEquals((Object[])new Object[]{"a", "b", "c"}, (Object[])((Object[])eval.value()));
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)eval.type());
    }

    @Test
    public void testJsonQueryExpression() {
        Expr expr = Parser.parse((String)"json_query(nest, '$.x')", (ExprMacroTable)MACRO_TABLE);
        ExprEval eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)100L, (Object)eval.value());
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)eval.type());
        expr = Parser.parse((String)"json_query(nester, '$.x')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)NESTER.get("x"), (Object)eval.value());
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)eval.type());
        expr = Parser.parse((String)"json_query(nester, '$.x[1]')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)"b", (Object)eval.value());
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)eval.type());
        expr = Parser.parse((String)"json_query(nester, '$.x[23]')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertNull((Object)eval.value());
        expr = Parser.parse((String)"json_query(nester, '$.x[1].b')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertNull((Object)eval.value());
        expr = Parser.parse((String)"json_query(nester, '$.y[1]')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertNull((Object)eval.value());
        expr = Parser.parse((String)"json_query(nester, '$.y.a')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)"hello", (Object)eval.value());
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)eval.type());
        expr = Parser.parse((String)"json_query(nester, '$.y.a.b.c[12]')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertNull((Object)eval.value());
        expr = Parser.parse((String)"json_query(long, '$')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)1234L, (Object)eval.value());
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)eval.type());
        expr = Parser.parse((String)"json_query(nester, array_offset(json_paths(nester), 0))", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)NESTER.get("x"), (Object)eval.value());
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)eval.type());
    }

    @Test
    public void testJsonQueryArrayExpression() {
        ExpressionType nestedArray = ExpressionTypeFactory.getInstance().ofArray(ExpressionType.NESTED_DATA);
        Expr expr = Parser.parse((String)"json_query_array(nest, '$.x')", (ExprMacroTable)MACRO_TABLE);
        ExprEval eval = expr.eval(this.inputBindings);
        Assert.assertArrayEquals((Object[])new Object[]{100L}, (Object[])((Object[])eval.value()));
        Assert.assertEquals((Object)nestedArray, (Object)eval.type());
        expr = Parser.parse((String)"json_query_array(nester, '$.x')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertArrayEquals((Object[])((List)NESTER.get("x")).toArray(), (Object[])((Object[])eval.value()));
        Assert.assertEquals((Object)nestedArray, (Object)eval.type());
        expr = Parser.parse((String)"json_query_array(nester, array_offset(json_paths(nester), 0))", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertArrayEquals((Object[])((List)NESTER.get("x")).toArray(), (Object[])((Object[])eval.value()));
        Assert.assertEquals((Object)nestedArray, (Object)eval.type());
        expr = Parser.parse((String)"json_query_array(nesterer, '$.y')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertArrayEquals((Object[])((List)NESTERER.get("y")).toArray(), (Object[])((Object[])eval.value()));
        Assert.assertEquals((Object)nestedArray, (Object)eval.type());
        expr = Parser.parse((String)"array_length(json_query_array(nesterer, '$.y'))", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)3L, (Object)eval.value());
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)eval.type());
        expr = Parser.parse((String)"array_contains(json_query_array(nest, '$.x'), 100)", (ExprMacroTable)MACRO_TABLE);
        expr = expr.asSingleThreaded((Expr.InputBindingInspector)this.inputBindings);
        Assert.assertEquals((Object)1L, (Object)expr.eval(this.inputBindings).value());
        expr = Parser.parse((String)"array_contains(json_query_array(nest, '$.x'), 101)", (ExprMacroTable)MACRO_TABLE);
        expr = expr.asSingleThreaded((Expr.InputBindingInspector)this.inputBindings);
        Assert.assertEquals((Object)0L, (Object)expr.eval(this.inputBindings).value());
        expr = Parser.parse((String)"array_overlap(json_query_array(nest, '$.x'), [100, 101])", (ExprMacroTable)MACRO_TABLE);
        expr = expr.asSingleThreaded((Expr.InputBindingInspector)this.inputBindings);
        Assert.assertEquals((Object)1L, (Object)expr.eval(this.inputBindings).value());
        expr = Parser.parse((String)"array_overlap(json_query_array(nest, '$.x'), [101, 102])", (ExprMacroTable)MACRO_TABLE);
        expr = expr.asSingleThreaded((Expr.InputBindingInspector)this.inputBindings);
        Assert.assertEquals((Object)0L, (Object)expr.eval(this.inputBindings).value());
    }

    @Test
    public void testParseJsonTryParseJson() throws JsonProcessingException {
        Expr expr = Parser.parse((String)"parse_json(null)", (ExprMacroTable)MACRO_TABLE);
        ExprEval eval = expr.eval(this.inputBindings);
        Assert.assertEquals(null, (Object)eval.value());
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)eval.type());
        expr = Parser.parse((String)"parse_json('null')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals(null, (Object)eval.value());
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)eval.type());
        Assert.assertThrows(ExpressionProcessingException.class, () -> Parser.parse((String)"parse_json('{')", (ExprMacroTable)MACRO_TABLE));
        expr = Parser.parse((String)"try_parse_json('{')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals(null, (Object)eval.value());
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)eval.type());
        Assert.assertThrows(ExpressionProcessingException.class, () -> Parser.parse((String)"parse_json('hello world')", (ExprMacroTable)MACRO_TABLE));
        expr = Parser.parse((String)"try_parse_json('hello world')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals(null, (Object)eval.value());
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)eval.type());
        expr = Parser.parse((String)"parse_json('\"hello world\"')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)"hello world", (Object)eval.value());
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)eval.type());
        expr = Parser.parse((String)"parse_json('1')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)1, (Object)eval.value());
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)eval.type());
        expr = Parser.parse((String)"parse_json('true')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)true, (Object)eval.value());
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)eval.type());
        expr = Parser.parse((String)"parse_json('{\"foo\":1}')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)"{\"foo\":1}", (Object)JSON_MAPPER.writeValueAsString(eval.value()));
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)eval.type());
    }

    @Test
    public void testToJsonStringParseJson() {
        Expr expr = Parser.parse((String)"to_json_string(nest)", (ExprMacroTable)MACRO_TABLE);
        ExprEval eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)"{\"x\":100,\"y\":200,\"z\":300}", (Object)eval.value());
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)eval.type());
        expr = Parser.parse((String)"parse_json(to_json_string(nest))", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        for (String key : NEST.keySet()) {
            Map val = (Map)eval.value();
            Assert.assertEquals((Object)NEST.get(key), (Object)((Integer)val.get(key)).longValue());
        }
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)eval.type());
        expr = Parser.parse((String)"json_value(parse_json('{\"x\":100,\"y\":200,\"z\":300}'), '$.x')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)100L, (Object)eval.value());
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)eval.type());
        expr = Parser.parse((String)"to_json_string(json_object('x', nestWrapped))", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)"{\"x\":{\"x\":100,\"y\":200,\"z\":300}}", (Object)eval.value());
        expr = Parser.parse((String)"to_json_string(json_object('xs', array(nest, nestWrapped)))", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)"{\"xs\":[{\"x\":100,\"y\":200,\"z\":300},{\"x\":100,\"y\":200,\"z\":300}]}", (Object)eval.value());
    }
}

