/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.druid.collections.BlockingPool;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.ListBasedInputRow;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.DirectQueryProcessingPool;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnnestDataSource;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.dimension.ExtractionDimensionSpec;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.StringFormatExtractionFn;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.EqualityFilter;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryQueryToolChest;
import org.apache.druid.query.groupby.GroupByQueryRunnerFactory;
import org.apache.druid.query.groupby.GroupByQueryRunnerTest;
import org.apache.druid.query.groupby.GroupByQueryRunnerTestHelper;
import org.apache.druid.query.groupby.GroupByResourcesReservationPool;
import org.apache.druid.query.groupby.GroupByStatsProvider;
import org.apache.druid.query.groupby.GroupingEngine;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.TestGroupByBuffers;
import org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.IncrementalIndexSegment;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.joda.time.DateTime;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class UnnestGroupByQueryRunnerTest
extends InitializedNullHandlingTest {
    private static TestGroupByBuffers BUFFER_POOLS = null;
    private final GroupByQueryRunnerFactory factory;
    private final GroupByQueryConfig config;
    private final boolean vectorize;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();

    public UnnestGroupByQueryRunnerTest(GroupByQueryConfig config, GroupByQueryRunnerFactory factory, boolean vectorize) {
        this.config = config;
        this.factory = factory;
        this.vectorize = vectorize;
    }

    public static List<GroupByQueryConfig> testConfigs() {
        GroupByQueryConfig v2Config = new GroupByQueryConfig(){

            public int getBufferGrouperInitialBuckets() {
                return 4;
            }

            public String toString() {
                return "v2";
            }
        };
        return ImmutableList.of((Object)v2Config);
    }

    public static GroupByQueryRunnerFactory makeQueryRunnerFactory(GroupByQueryConfig config, TestGroupByBuffers bufferPools) {
        return UnnestGroupByQueryRunnerTest.makeQueryRunnerFactory(GroupByQueryRunnerTest.DEFAULT_MAPPER, config, bufferPools, GroupByQueryRunnerTest.DEFAULT_PROCESSING_CONFIG);
    }

    public static GroupByQueryRunnerFactory makeQueryRunnerFactory(ObjectMapper mapper, GroupByQueryConfig config, TestGroupByBuffers bufferPools) {
        return UnnestGroupByQueryRunnerTest.makeQueryRunnerFactory(mapper, config, bufferPools, GroupByQueryRunnerTest.DEFAULT_PROCESSING_CONFIG);
    }

    public static GroupByQueryRunnerFactory makeQueryRunnerFactory(ObjectMapper mapper, GroupByQueryConfig config, TestGroupByBuffers bufferPools, DruidProcessingConfig processingConfig) {
        if (bufferPools.getBufferSize() != processingConfig.intermediateComputeSizeBytes()) {
            throw new ISE("Provided buffer size [%,d] does not match configured size [%,d]", new Object[]{bufferPools.getBufferSize(), processingConfig.intermediateComputeSizeBytes()});
        }
        if (bufferPools.getNumMergeBuffers() != processingConfig.getNumMergeBuffers()) {
            throw new ISE("Provided merge buffer count [%,d] does not match configured count [%,d]", new Object[]{bufferPools.getNumMergeBuffers(), processingConfig.getNumMergeBuffers()});
        }
        Supplier configSupplier = Suppliers.ofInstance((Object)config);
        GroupByStatsProvider groupByStatsProvider = new GroupByStatsProvider();
        GroupByResourcesReservationPool groupByResourcesReservationPool = new GroupByResourcesReservationPool((BlockingPool)bufferPools.getMergePool(), config);
        GroupingEngine groupingEngine = new GroupingEngine(processingConfig, configSupplier, groupByResourcesReservationPool, TestHelper.makeJsonMapper(), mapper, QueryRunnerTestHelper.NOOP_QUERYWATCHER, groupByStatsProvider);
        GroupByQueryQueryToolChest toolChest = new GroupByQueryQueryToolChest(groupingEngine, groupByResourcesReservationPool);
        return new GroupByQueryRunnerFactory(groupingEngine, toolChest, (NonBlockingPool)bufferPools.getProcessingPool());
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> constructorFeeder() {
        UnnestGroupByQueryRunnerTest.setUpClass();
        ArrayList<Object[]> constructors = new ArrayList<Object[]>();
        for (GroupByQueryConfig config : UnnestGroupByQueryRunnerTest.testConfigs()) {
            GroupByQueryRunnerFactory factory = UnnestGroupByQueryRunnerTest.makeQueryRunnerFactory(config, BUFFER_POOLS);
            UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)false).iterator();
            while (unmodifiableIterator.hasNext()) {
                boolean vectorize = (Boolean)unmodifiableIterator.next();
                constructors.add(new Object[]{config, factory, vectorize});
            }
        }
        return constructors;
    }

    @BeforeClass
    public static void setUpClass() {
        if (BUFFER_POOLS == null) {
            BUFFER_POOLS = TestGroupByBuffers.createDefault();
        }
    }

    @AfterClass
    public static void tearDownClass() {
        BUFFER_POOLS.close();
        BUFFER_POOLS = null;
    }

    private static ResultRow makeRow(GroupByQuery query, String timestamp, Object ... vals) {
        return GroupByQueryRunnerTestHelper.createExpectedRow(query, timestamp, vals);
    }

    private static ResultRow makeRow(GroupByQuery query, DateTime timestamp, Object ... vals) {
        return GroupByQueryRunnerTestHelper.createExpectedRow(query, timestamp, vals);
    }

    @Test
    public void testGroupBy() {
        GroupByQuery query = this.makeQueryBuilder().setDataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("testing"), (VirtualColumn)new ExpressionVirtualColumn("placementish_unnest", "\"placementish\"", null, ExprMacroTable.nil()), null)).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "automotive", "rows", 2L, "idx", 270L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "business", "rows", 2L, "idx", 236L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "entertainment", "rows", 2L, "idx", 316L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "health", "rows", 2L, "idx", 240L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 5740L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "news", "rows", 2L, "idx", 242L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "premium", "rows", 6L, "idx", 5800L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "technology", "rows", 2L, "idx", 156L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "travel", "rows", 2L, "idx", 238L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "automotive", "rows", 2L, "idx", 294L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "business", "rows", 2L, "idx", 224L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "entertainment", "rows", 2L, "idx", 332L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "health", "rows", 2L, "idx", 226L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "mezzanine", "rows", 6L, "idx", 4894L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "news", "rows", 2L, "idx", 228L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "premium", "rows", 6L, "idx", 5010L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "technology", "rows", 2L, "idx", 194L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "travel", "rows", 2L, "idx", 252L));
        Iterable<ResultRow> results = this.runQuery(query, TestIndex.getIncrementalTestIndex());
        TestHelper.assertExpectedObjects(expectedResults, results, "groupBy");
        results = this.runQuery(query, TestIndex.getMMappedTestIndex());
        TestHelper.assertExpectedObjects(expectedResults, results, "groupBy");
    }

    @Test
    public void testGroupByOnMissingColumn() {
        this.cannotVectorize();
        GroupByQuery query = this.makeQueryBuilder().setDataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("testing"), (VirtualColumn)new ExpressionVirtualColumn("placementish_unnest", "\"placementish\"", null, ExprMacroTable.nil()), null)).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("nonexistent0", "alias0"), new ExtractionDimensionSpec("nonexistent1", "alias1", (ExtractionFn)new StringFormatExtractionFn("foo"))}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        List<ResultRow> expectedResults = Collections.singletonList(UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", null, "alias1", "foo", "rows", 52L));
        Iterable<ResultRow> results = this.runQuery(query, TestIndex.getIncrementalTestIndex());
        TestHelper.assertExpectedObjects(expectedResults, results, "missing-column");
        results = this.runQuery(query, TestIndex.getMMappedTestIndex());
        TestHelper.assertExpectedObjects(expectedResults, results, "missing-column");
    }

    @Test
    public void testGroupByOnUnnestedColumn() {
        this.cannotVectorize();
        GroupByQuery query = this.makeQueryBuilder().setDataSource(QueryRunnerTestHelper.UNNEST_DATA_SOURCE).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("placementish_unnest", "alias0")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "a", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "b", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "e", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "h", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "m", "rows", 6L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "n", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "p", "rows", 6L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "preferred", "rows", 26L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "t", "rows", 4L));
        Iterable<ResultRow> results = this.runQuery(query, TestIndex.getIncrementalTestIndex());
        TestHelper.assertExpectedObjects(expectedResults, results, "groupBy-on-unnested-column");
        results = this.runQuery(query, TestIndex.getMMappedTestIndex());
        TestHelper.assertExpectedObjects(expectedResults, results, "groupBy-on-unnested-column");
    }

    @Test
    public void testGroupByOnUnnestedVirtualColumn() {
        this.cannotVectorize();
        UnnestDataSource unnestDataSource = UnnestDataSource.create((DataSource)new TableDataSource("testing"), (VirtualColumn)new ExpressionVirtualColumn("placementish_unnest", "mv_to_array(placementish)", ColumnType.STRING_ARRAY, TestExprMacroTable.INSTANCE), null);
        GroupByQuery query = this.makeQueryBuilder().setDataSource((DataSource)unnestDataSource).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("placementish_unnest", "alias0")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).addOrderByColumn("alias0", OrderByColumnSpec.Direction.ASCENDING).build();
        List<ResultRow> expectedResults = Arrays.asList(UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "a", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "b", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "e", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "h", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "m", "rows", 6L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "n", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "p", "rows", 6L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "preferred", "rows", 26L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "t", "rows", 4L));
        Iterable<ResultRow> results = this.runQuery(query, TestIndex.getIncrementalTestIndex());
        TestHelper.assertExpectedObjects(expectedResults, results, "groupBy-on-unnested-virtual-column");
        results = this.runQuery(query, TestIndex.getMMappedTestIndex());
        TestHelper.assertExpectedObjects(expectedResults, results, "groupBy-on-unnested-virtual-column");
    }

    @Test
    public void testGroupByOnUnnestedVirtualMultiColumn() {
        this.cannotVectorize();
        UnnestDataSource unnestDataSource = UnnestDataSource.create((DataSource)new TableDataSource("testing"), (VirtualColumn)new ExpressionVirtualColumn("placementish_unnest", "array(\"market\",\"quality\")", ColumnType.STRING, TestExprMacroTable.INSTANCE), null);
        GroupByQuery query = this.makeQueryBuilder().setDataSource((DataSource)unnestDataSource).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("placementish_unnest", "alias0")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).setLimit(3).build();
        List<ResultRow> expectedResults = Arrays.asList(UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "automotive", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "business", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "entertainment", "rows", 2L));
        Iterable<ResultRow> results = this.runQuery(query, TestIndex.getIncrementalTestIndex());
        TestHelper.assertExpectedObjects(expectedResults, results, "groupBy-on-unnested-virtual-columns");
        results = this.runQuery(query, TestIndex.getMMappedTestIndex());
        TestHelper.assertExpectedObjects(expectedResults, results, "groupBy-on-unnested-virtual-column");
    }

    @Test
    public void testGroupByOnUnnestedStringColumnWithNullStuff() throws IOException {
        this.cannotVectorize();
        String dim = "mvd";
        DateTime timestamp = DateTimes.nowUtc();
        RowSignature signature = RowSignature.builder().add("mvd", ColumnType.STRING).build();
        List<String> dims = Collections.singletonList("mvd");
        IndexBuilder bob = IndexBuilder.create().schema(IncrementalIndexSchema.builder().withRollup(false).build()).rows((Iterable<InputRow>)ImmutableList.of((Object)new ListBasedInputRow(signature, timestamp, dims, (List)ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"))), (Object)new ListBasedInputRow(signature, timestamp, dims, (List)ImmutableList.of()), (Object)new ListBasedInputRow(signature, timestamp, dims, (List)ImmutableList.of((Object)ImmutableList.of())), (Object)new ListBasedInputRow(signature, timestamp, dims, (List)ImmutableList.of((Object)""))));
        UnnestDataSource unnestDataSource = UnnestDataSource.create((DataSource)new TableDataSource("testing"), (VirtualColumn)new ExpressionVirtualColumn("v0", "mvd", ColumnType.STRING, TestExprMacroTable.INSTANCE), null);
        GroupByQuery query = this.makeQueryBuilder().setDataSource((DataSource)unnestDataSource).setQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.ETERNITY))).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "v0")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(UnnestGroupByQueryRunnerTest.makeRow(query, timestamp, "v0", null, "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, timestamp, "v0", "", "rows", 1L), UnnestGroupByQueryRunnerTest.makeRow(query, timestamp, "v0", "a", "rows", 1L), UnnestGroupByQueryRunnerTest.makeRow(query, timestamp, "v0", "b", "rows", 1L), UnnestGroupByQueryRunnerTest.makeRow(query, timestamp, "v0", "c", "rows", 1L));
        Iterable<ResultRow> results = this.runQuery(query, bob.buildIncrementalIndex());
        TestHelper.assertExpectedObjects(expectedResults, results, "group-by-unnested-string-nulls");
        results = this.runQuery(query, bob.tmpDir(this.tempFolder.newFolder()).buildMMappedIndex());
        TestHelper.assertExpectedObjects(expectedResults, results, "group-by-unnested-string-nulls");
    }

    @Test
    public void testGroupByOnUnnestedStringColumnWithMoreNullStuff() throws IOException {
        this.cannotVectorize();
        String dim = "mvd";
        DateTime timestamp = DateTimes.nowUtc();
        RowSignature signature = RowSignature.builder().add("mvd", ColumnType.STRING).build();
        List<String> dims = Collections.singletonList("mvd");
        IndexBuilder bob = IndexBuilder.create().schema(IncrementalIndexSchema.builder().withRollup(false).build()).rows((Iterable<InputRow>)ImmutableList.of((Object)new ListBasedInputRow(signature, timestamp, dims, Collections.singletonList(Arrays.asList("a", "b", "c"))), (Object)new ListBasedInputRow(signature, timestamp, dims, Collections.emptyList()), (Object)new ListBasedInputRow(signature, timestamp, dims, Collections.singletonList(null)), (Object)new ListBasedInputRow(signature, timestamp, dims, Collections.singletonList(Collections.emptyList())), (Object)new ListBasedInputRow(signature, timestamp, dims, Collections.singletonList(Arrays.asList(null, null))), (Object)new ListBasedInputRow(signature, timestamp, dims, Collections.singletonList(Collections.singletonList(null))), (Object)new ListBasedInputRow(signature, timestamp, dims, Collections.singletonList(Collections.singletonList("")))));
        UnnestDataSource unnestDataSource = UnnestDataSource.create((DataSource)new TableDataSource("testing"), (VirtualColumn)new ExpressionVirtualColumn("v0", "mvd", ColumnType.STRING, TestExprMacroTable.INSTANCE), null);
        GroupByQuery query = this.makeQueryBuilder().setDataSource((DataSource)unnestDataSource).setQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.ETERNITY))).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "v0")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        GroupByQuery regularQuery = this.makeQueryBuilder().setDataSource((DataSource)new TableDataSource("testing")).setQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.ETERNITY))).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("mvd", "v0")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(UnnestGroupByQueryRunnerTest.makeRow(query, timestamp, "v0", null, "rows", 6L), UnnestGroupByQueryRunnerTest.makeRow(query, timestamp, "v0", "", "rows", 1L), UnnestGroupByQueryRunnerTest.makeRow(query, timestamp, "v0", "a", "rows", 1L), UnnestGroupByQueryRunnerTest.makeRow(query, timestamp, "v0", "b", "rows", 1L), UnnestGroupByQueryRunnerTest.makeRow(query, timestamp, "v0", "c", "rows", 1L));
        Iterable<ResultRow> results = this.runQuery(query, bob.buildIncrementalIndex());
        TestHelper.assertExpectedObjects(expectedResults, results, "group-by-unnested-string-nulls");
        results = this.runQuery(regularQuery, bob.buildIncrementalIndex());
        TestHelper.assertExpectedObjects(expectedResults, results, "group-by-unnested-string-nulls");
        results = this.runQuery(query, bob.tmpDir(this.tempFolder.newFolder()).buildMMappedIndex());
        TestHelper.assertExpectedObjects(expectedResults, results, "group-by-unnested-string-nulls");
    }

    @Test
    public void testGroupByOnUnnestEmptyTable() {
        this.cannotVectorize();
        IndexBuilder bob = IndexBuilder.create().rows((Iterable<InputRow>)ImmutableList.of());
        UnnestDataSource unnestDataSource = UnnestDataSource.create((DataSource)new TableDataSource("testing"), (VirtualColumn)new ExpressionVirtualColumn("v0", "mvd", ColumnType.STRING, TestExprMacroTable.INSTANCE), null);
        GroupByQuery query = this.makeQueryBuilder().setDataSource((DataSource)unnestDataSource).setQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.ETERNITY))).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "v0")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        List expectedResults = Collections.emptyList();
        Iterable<ResultRow> results = this.runQuery(query, bob.buildIncrementalIndex());
        TestHelper.assertExpectedObjects(expectedResults, results, "group-by-unnested-empty");
    }

    @Test
    public void testGroupByOnUnnestEmptyRows() {
        this.cannotVectorize();
        String dim = "mvd";
        DateTime timestamp = DateTimes.nowUtc();
        RowSignature signature = RowSignature.builder().add("mvd", ColumnType.STRING).build();
        List<String> dims = Collections.singletonList("mvd");
        IndexBuilder bob = IndexBuilder.create().schema(IncrementalIndexSchema.builder().withRollup(false).build()).rows((Iterable<InputRow>)ImmutableList.of((Object)new ListBasedInputRow(signature, timestamp, dims, Collections.singletonList(Collections.emptyList()))));
        UnnestDataSource unnestDataSource = UnnestDataSource.create((DataSource)new TableDataSource("testing"), (VirtualColumn)new ExpressionVirtualColumn("v0", "mvd", ColumnType.STRING, TestExprMacroTable.INSTANCE), null);
        GroupByQuery query = this.makeQueryBuilder().setDataSource((DataSource)unnestDataSource).setQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.ETERNITY))).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "v0")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        GroupByQuery regularQuery = this.makeQueryBuilder().setDataSource((DataSource)new TableDataSource("testing")).setQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.ETERNITY))).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("mvd", "v0")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        List<ResultRow> expectedResults = Collections.singletonList(UnnestGroupByQueryRunnerTest.makeRow(query, timestamp, "v0", null, "rows", 1L));
        Iterable<ResultRow> results = this.runQuery(query, bob.buildIncrementalIndex());
        TestHelper.assertExpectedObjects(expectedResults, results, "group-by-unnested-empty");
        results = this.runQuery(regularQuery, bob.buildIncrementalIndex());
        TestHelper.assertExpectedObjects(expectedResults, results, "group-by-unnested-empty");
    }

    @Test
    public void testGroupByOnUnnestedStringColumnDoubleUnnest() throws IOException {
        this.cannotVectorize();
        String dim = "mvd";
        DateTime timestamp = DateTimes.nowUtc();
        RowSignature signature = RowSignature.builder().add("mvd", ColumnType.STRING).build();
        List<String> dims = Collections.singletonList("mvd");
        IndexBuilder bob = IndexBuilder.create().schema(IncrementalIndexSchema.builder().withRollup(false).build()).rows((Iterable<InputRow>)ImmutableList.of((Object)new ListBasedInputRow(signature, timestamp, dims, (List)ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"))), (Object)new ListBasedInputRow(signature, timestamp, dims, (List)ImmutableList.of()), (Object)new ListBasedInputRow(signature, timestamp, dims, (List)ImmutableList.of((Object)ImmutableList.of())), (Object)new ListBasedInputRow(signature, timestamp, dims, (List)ImmutableList.of((Object)""))));
        UnnestDataSource unnestDataSource = UnnestDataSource.create((DataSource)new TableDataSource("testing"), (VirtualColumn)new ExpressionVirtualColumn("v0", "mvd", ColumnType.STRING, TestExprMacroTable.INSTANCE), null);
        UnnestDataSource extraUnnested = UnnestDataSource.create((DataSource)unnestDataSource, (VirtualColumn)new ExpressionVirtualColumn("v1", "v0", ColumnType.STRING, TestExprMacroTable.INSTANCE), null);
        GroupByQuery query = this.makeQueryBuilder().setDataSource((DataSource)extraUnnested).setQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.ETERNITY))).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("v1", "v1")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(UnnestGroupByQueryRunnerTest.makeRow(query, timestamp, "v1", null, "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, timestamp, "v1", "", "rows", 1L), UnnestGroupByQueryRunnerTest.makeRow(query, timestamp, "v1", "a", "rows", 1L), UnnestGroupByQueryRunnerTest.makeRow(query, timestamp, "v1", "b", "rows", 1L), UnnestGroupByQueryRunnerTest.makeRow(query, timestamp, "v1", "c", "rows", 1L));
        Iterable<ResultRow> results = this.runQuery(query, bob.buildIncrementalIndex());
        TestHelper.assertExpectedObjects(expectedResults, results, "group-by-unnested-string-nulls-double-unnest");
        results = this.runQuery(query, bob.tmpDir(this.tempFolder.newFolder()).buildMMappedIndex());
        TestHelper.assertExpectedObjects(expectedResults, results, "group-by-unnested-string-nulls-double-unnest");
    }

    @Test
    public void testGroupByOnUnnestedFilterMatch() {
        this.cannotVectorize();
        UnnestDataSource unnestDataSource = UnnestDataSource.create((DataSource)new TableDataSource("testing"), (VirtualColumn)new ExpressionVirtualColumn("placementish_unnest", "\"placementish\"", null, ExprMacroTable.nil()), null);
        GroupByQuery query = this.makeQueryBuilder().setDataSource((DataSource)unnestDataSource).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("placementish_unnest", "alias0")}).setDimFilter((DimFilter)new EqualityFilter("placementish_unnest", ColumnType.STRING, (Object)"a", null)).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).addOrderByColumn("alias0", OrderByColumnSpec.Direction.ASCENDING).build();
        List<ResultRow> expectedResults = Collections.singletonList(UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "a", "rows", 2L));
        Iterable<ResultRow> results = this.runQuery(query, TestIndex.getIncrementalTestIndex());
        TestHelper.assertExpectedObjects(expectedResults, results, "groupBy-on-unnested-virtual-column");
        results = this.runQuery(query, TestIndex.getMMappedTestIndex());
        TestHelper.assertExpectedObjects(expectedResults, results, "groupBy-on-unnested-virtual-column");
    }

    @Test
    public void testGroupByOnUnnestedNotFilterMatch() {
        this.cannotVectorize();
        UnnestDataSource unnestDataSource = UnnestDataSource.create((DataSource)new TableDataSource("testing"), (VirtualColumn)new ExpressionVirtualColumn("placementish_unnest", "\"placementish\"", null, ExprMacroTable.nil()), null);
        GroupByQuery query = this.makeQueryBuilder().setDataSource((DataSource)unnestDataSource).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("placementish_unnest", "alias0")}).setDimFilter((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("placementish_unnest", ColumnType.STRING, (Object)"a", null))).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).addOrderByColumn("alias0", OrderByColumnSpec.Direction.ASCENDING).build();
        List<ResultRow> expectedResults = Arrays.asList(UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "b", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "e", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "h", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "m", "rows", 6L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "n", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "p", "rows", 6L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "preferred", "rows", 26L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "t", "rows", 4L));
        Iterable<ResultRow> results = this.runQuery(query, TestIndex.getIncrementalTestIndex());
        TestHelper.assertExpectedObjects(expectedResults, results, "groupBy-on-unnested-virtual-column");
        results = this.runQuery(query, TestIndex.getMMappedTestIndex());
        TestHelper.assertExpectedObjects(expectedResults, results, "groupBy-on-unnested-virtual-column");
    }

    @Test
    public void testGroupByOnUnnestedNotFilterMatchNonexistentValue() {
        this.cannotVectorize();
        UnnestDataSource unnestDataSource = UnnestDataSource.create((DataSource)new TableDataSource("testing"), (VirtualColumn)new ExpressionVirtualColumn("placementish_unnest", "\"placementish\"", null, ExprMacroTable.nil()), null);
        GroupByQuery query = this.makeQueryBuilder().setDataSource((DataSource)unnestDataSource).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("placementish_unnest", "alias0")}).setDimFilter((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("placementish_unnest", ColumnType.STRING, (Object)"noexist", null))).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).addOrderByColumn("alias0", OrderByColumnSpec.Direction.ASCENDING).build();
        List<ResultRow> expectedResults = Arrays.asList(UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "a", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "b", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "e", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "h", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "m", "rows", 6L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "n", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "p", "rows", 6L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "preferred", "rows", 26L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "t", "rows", 4L));
        Iterable<ResultRow> results = this.runQuery(query, TestIndex.getIncrementalTestIndex());
        TestHelper.assertExpectedObjects(expectedResults, results, "groupBy-on-unnested-virtual-column");
    }

    private GroupByQuery.Builder makeQueryBuilder() {
        return GroupByQuery.builder().overrideContext(this.makeContext());
    }

    private Iterable<ResultRow> runQuery(GroupByQuery query, IncrementalIndex index) {
        QueryRunner queryRunner = this.factory.mergeRunners((QueryProcessingPool)DirectQueryProcessingPool.INSTANCE, Collections.singletonList(QueryRunnerTestHelper.makeQueryRunnerWithSegmentMapFn(this.factory, (Segment)new IncrementalIndexSegment(index, QueryRunnerTestHelper.SEGMENT_ID), query, "rtIndexvc")));
        return GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, queryRunner, query);
    }

    private Iterable<ResultRow> runQuery(GroupByQuery query, QueryableIndex index) {
        QueryRunner queryRunner = this.factory.mergeRunners((QueryProcessingPool)DirectQueryProcessingPool.INSTANCE, Collections.singletonList(QueryRunnerTestHelper.makeQueryRunnerWithSegmentMapFn(this.factory, (Segment)new QueryableIndexSegment(index, QueryRunnerTestHelper.SEGMENT_ID), query, "mmapIndexvc")));
        return GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, queryRunner, query);
    }

    private Map<String, Object> makeContext() {
        return ImmutableMap.builder().put((Object)"vectorize", (Object)(this.vectorize ? "force" : "false")).put((Object)"vectorizeVirtualColumns", (Object)(this.vectorize ? "force" : "false")).put((Object)"vectorSize", (Object)16).build();
    }

    private void cannotVectorize() {
        if (this.vectorize) {
            this.expectedException.expect(RuntimeException.class);
            this.expectedException.expectMessage("Cannot vectorize!");
        }
    }
}

