/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator.window.value;

import java.util.LinkedHashMap;
import org.apache.druid.query.operator.window.ComposingProcessor;
import org.apache.druid.query.operator.window.Processor;
import org.apache.druid.query.operator.window.RowsAndColumnsHelper;
import org.apache.druid.query.operator.window.value.WindowOffsetProcessor;
import org.apache.druid.query.rowsandcols.MapOfColumnsRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.DoubleArrayColumn;
import org.apache.druid.query.rowsandcols.column.IntArrayColumn;
import org.apache.druid.query.rowsandcols.column.ObjectArrayColumn;
import org.apache.druid.segment.column.ColumnType;
import org.junit.Test;

public class WindowLeadProcessorTest {
    @Test
    public void testLeadProcessing() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("intCol", new IntArrayColumn(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}));
        map.put("doubleCol", new DoubleArrayColumn(new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0}));
        map.put("objectCol", new ObjectArrayColumn((Object[])new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j"}, ColumnType.STRING));
        MapOfColumnsRowsAndColumns rac = MapOfColumnsRowsAndColumns.fromMap(map);
        ComposingProcessor processor = new ComposingProcessor(new Processor[]{new WindowOffsetProcessor("intCol", "LeadingIntCol", 2), new WindowOffsetProcessor("doubleCol", "LeadingDoubleCol", 4), new WindowOffsetProcessor("objectCol", "LeadingObjectCol", 1)});
        RowsAndColumns results = processor.process((RowsAndColumns)rac);
        RowsAndColumnsHelper expectations = new RowsAndColumnsHelper().expectColumn("intCol", new int[]{88, 1, 2, 3, 4, 5, 6, 7, 8, 9}).expectColumn("doubleCol", new double[]{0.4728, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0});
        expectations.columnHelper("LeadingIntCol", 10, ColumnType.LONG).setExpectation(new int[]{2, 3, 4, 5, 6, 7, 8, 9, 0, 0}).setNulls(new int[]{8, 9});
        expectations.columnHelper("LeadingDoubleCol", 10, ColumnType.DOUBLE).setExpectation(new double[]{4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0, 0.0, 0.0, 0.0}).setNulls(new int[]{6, 7, 8, 9});
        expectations.columnHelper("LeadingObjectCol", 10, ColumnType.STRING).setExpectation(new String[]{"b", "c", "d", "e", "f", "g", "h", "i", "j", null}).setNulls(new int[]{9});
    }
}

