/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.policy;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.RestrictedDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.NullFilter;
import org.apache.druid.query.policy.NoRestrictionPolicy;
import org.apache.druid.query.policy.Policy;
import org.apache.druid.query.policy.PolicyEnforcer;
import org.apache.druid.query.policy.RestrictAllTablesPolicyEnforcer;
import org.apache.druid.query.policy.RowFilterPolicy;
import org.apache.druid.segment.ReferenceCountedObjectProvider;
import org.apache.druid.segment.ReferenceCountedSegmentProvider;
import org.apache.druid.segment.RowBasedSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.TestSegmentUtils;
import org.apache.druid.segment.column.RowSignature;
import org.junit.Assert;
import org.junit.Test;

public class RestrictAllTablesPolicyEnforcerTest {
    @Test
    public void test_serialize() throws Exception {
        RestrictAllTablesPolicyEnforcer policyEnforcer = new RestrictAllTablesPolicyEnforcer((List)ImmutableList.of((Object)NoRestrictionPolicy.class.getName()));
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        String expected = "{\"type\":\"restrictAllTables\",\"allowedPolicies\":[\"org.apache.druid.query.policy.NoRestrictionPolicy\"]}";
        Assert.assertEquals((Object)expected, (Object)jsonMapper.writeValueAsString((Object)policyEnforcer));
    }

    @Test
    public void test_serde_roundTrip() throws Exception {
        RestrictAllTablesPolicyEnforcer policyEnforcer = new RestrictAllTablesPolicyEnforcer(null);
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        PolicyEnforcer deserialized = (PolicyEnforcer)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)policyEnforcer), PolicyEnforcer.class);
        Assert.assertEquals((Object)policyEnforcer, (Object)deserialized);
    }

    @Test
    public void test_validate() throws Exception {
        RestrictAllTablesPolicyEnforcer policyEnforcer = new RestrictAllTablesPolicyEnforcer(null);
        RowFilterPolicy policy = RowFilterPolicy.from((DimFilter)new NullFilter("some-col", null));
        TableDataSource table = TableDataSource.create((String)"table");
        RestrictedDataSource restricted = RestrictedDataSource.create((DataSource)table, (Policy)policy);
        Assert.assertFalse((boolean)policyEnforcer.validate(null));
        Assert.assertTrue((boolean)policyEnforcer.validate((Policy)policy));
        DruidException e = (DruidException)Assert.assertThrows(DruidException.class, () -> policyEnforcer.validateOrElseThrow(table, null));
        Assert.assertEquals((Object)DruidException.Category.FORBIDDEN, (Object)e.getCategory());
        Assert.assertEquals((Object)DruidException.Persona.OPERATOR, (Object)e.getTargetPersona());
        Assert.assertEquals((Object)"Failed security validation with dataSource [table]", (Object)e.getMessage());
        policyEnforcer.validateOrElseThrow(restricted.getBase(), restricted.getPolicy());
        TestSegmentUtils.SegmentForTesting segment = new TestSegmentUtils.SegmentForTesting("table", Intervals.ETERNITY, "1");
        Assert.assertFalse((boolean)policyEnforcer.validate(null));
        Assert.assertTrue((boolean)policyEnforcer.validate((Policy)policy));
        DruidException e2 = (DruidException)Assert.assertThrows(DruidException.class, () -> RestrictAllTablesPolicyEnforcerTest.lambda$test_validate$1(policyEnforcer, (Segment)segment));
        Assert.assertEquals((Object)DruidException.Category.FORBIDDEN, (Object)e2.getCategory());
        Assert.assertEquals((Object)DruidException.Persona.OPERATOR, (Object)e2.getTargetPersona());
        Assert.assertEquals((Object)"Failed security validation with segment [table_-146136543-09-08T08:23:32.096Z_146140482-04-24T15:36:27.903Z_1]", (Object)e2.getMessage());
        policyEnforcer.validateOrElseThrow((Segment)segment, (Policy)policy);
    }

    @Test
    public void test_validate_allowNonTableSegments() throws Exception {
        RestrictAllTablesPolicyEnforcer policyEnforcer = new RestrictAllTablesPolicyEnforcer(null);
        InlineDataSource inlineDataSource = InlineDataSource.fromIterable((Iterable)ImmutableList.of(), (RowSignature)RowSignature.empty());
        RowBasedSegment inlineSegment = new RowBasedSegment(Sequences.simple((Iterable)inlineDataSource.getRows()), inlineDataSource.rowAdapter(), inlineDataSource.getRowSignature());
        ReferenceCountedObjectProvider segment = ReferenceCountedSegmentProvider.wrapUnmanaged((Segment)inlineSegment);
        policyEnforcer.validateOrElseThrow((Segment)segment.acquireReference().orElseThrow(), null);
    }

    @Test
    public void test_validate_withAllowedPolicies() throws Exception {
        RestrictAllTablesPolicyEnforcer policyEnforcer = new RestrictAllTablesPolicyEnforcer((List)ImmutableList.of((Object)NoRestrictionPolicy.class.getName()));
        RowFilterPolicy policy = RowFilterPolicy.from((DimFilter)new NullFilter("some-col", null));
        TableDataSource table = TableDataSource.create((String)"table");
        RestrictedDataSource restricted = RestrictedDataSource.create((DataSource)table, (Policy)policy);
        Assert.assertThrows(DruidException.class, () -> policyEnforcer.validateOrElseThrow(table, null));
        Assert.assertThrows(DruidException.class, () -> policyEnforcer.validateOrElseThrow(restricted.getBase(), restricted.getPolicy()));
        policyEnforcer.validateOrElseThrow(table, (Policy)NoRestrictionPolicy.instance());
        TestSegmentUtils.SegmentForTesting segment = new TestSegmentUtils.SegmentForTesting("table", Intervals.ETERNITY, "1");
        Assert.assertThrows(DruidException.class, () -> RestrictAllTablesPolicyEnforcerTest.lambda$test_validate_withAllowedPolicies$4(policyEnforcer, (Segment)segment));
        Assert.assertThrows(DruidException.class, () -> RestrictAllTablesPolicyEnforcerTest.lambda$test_validate_withAllowedPolicies$5(policyEnforcer, (Segment)segment, policy));
        policyEnforcer.validateOrElseThrow((Segment)segment, (Policy)NoRestrictionPolicy.instance());
    }

    private static /* synthetic */ void lambda$test_validate_withAllowedPolicies$5(RestrictAllTablesPolicyEnforcer policyEnforcer, Segment segment, RowFilterPolicy policy) throws Throwable {
        policyEnforcer.validateOrElseThrow(segment, (Policy)policy);
    }

    private static /* synthetic */ void lambda$test_validate_withAllowedPolicies$4(RestrictAllTablesPolicyEnforcer policyEnforcer, Segment segment) throws Throwable {
        policyEnforcer.validateOrElseThrow(segment, null);
    }

    private static /* synthetic */ void lambda$test_validate$1(RestrictAllTablesPolicyEnforcer policyEnforcer, Segment segment) throws Throwable {
        policyEnforcer.validateOrElseThrow(segment, null);
    }
}

