/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.semantic;

import java.util.function.Function;
import org.apache.druid.query.operator.ColumnWithDirection;
import org.apache.druid.query.operator.window.RowsAndColumnsHelper;
import org.apache.druid.query.rowsandcols.MapOfColumnsRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.IntArrayColumn;
import org.apache.druid.query.rowsandcols.column.ObjectArrayColumn;
import org.apache.druid.query.rowsandcols.semantic.DefaultNaiveSortMaker;
import org.apache.druid.query.rowsandcols.semantic.NaiveSortMaker;
import org.apache.druid.query.rowsandcols.semantic.SemanticTestBase;
import org.apache.druid.segment.column.ColumnType;
import org.junit.Test;

public class NaiveSortMakerTest
extends SemanticTestBase {
    public NaiveSortMakerTest(String name, Function<MapOfColumnsRowsAndColumns, RowsAndColumns> fn) {
        super(name, fn);
    }

    @Test
    public void testSortMultipleChunks() {
        RowsAndColumns first = this.make(MapOfColumnsRowsAndColumns.of((String)"ints", (Column)new IntArrayColumn(new int[]{1, 7, 13, 0, 19}), (String)"strs", (Column)new ObjectArrayColumn(new Object[]{"b", "h", "n", "a", "t"}, ColumnType.STRING)));
        NaiveSortMaker maker = (NaiveSortMaker)first.as(NaiveSortMaker.class);
        if (maker == null) {
            maker = new DefaultNaiveSortMaker(first);
        }
        NaiveSortMaker.NaiveSorter intSorter = maker.make(new ColumnWithDirection[]{ColumnWithDirection.ascending((String)"ints")});
        NaiveSortMaker.NaiveSorter stringSorter = maker.make(new ColumnWithDirection[]{ColumnWithDirection.ascending((String)"strs")});
        NaiveSortMaker.NaiveSorter intSorterDesc = maker.make(new ColumnWithDirection[]{ColumnWithDirection.descending((String)"ints")});
        NaiveSortMaker.NaiveSorter stringSorterDesc = maker.make(new ColumnWithDirection[]{ColumnWithDirection.descending((String)"strs")});
        RowsAndColumns intermediate = this.make(MapOfColumnsRowsAndColumns.of((String)"ints", (Column)new IntArrayColumn(new int[]{2, 3, 16, 4, 5}), (String)"strs", (Column)new ObjectArrayColumn(new Object[]{"c", "d", "q", "e", "f"}, ColumnType.STRING)));
        intSorter.moreData(intermediate);
        stringSorter.moreData(intermediate);
        intSorterDesc.moreData(intermediate);
        stringSorterDesc.moreData(intermediate);
        intermediate = this.make(MapOfColumnsRowsAndColumns.of((String)"ints", (Column)new IntArrayColumn(new int[]{10, 17, 12, 8, 14, 15}), (String)"strs", (Column)new ObjectArrayColumn(new Object[]{"k", "r", "m", "i", "o", "p"}, ColumnType.STRING)));
        intSorter.moreData(intermediate);
        stringSorter.moreData(intermediate);
        intSorterDesc.moreData(intermediate);
        stringSorterDesc.moreData(intermediate);
        intermediate = this.make(MapOfColumnsRowsAndColumns.of((String)"ints", (Column)new IntArrayColumn(new int[]{6, 18, 11, 14, 9}), (String)"strs", (Column)new ObjectArrayColumn(new Object[]{"g", "s", "l", "o", "j"}, ColumnType.STRING)));
        intSorter.moreData(intermediate);
        stringSorter.moreData(intermediate);
        intSorterDesc.moreData(intermediate);
        stringSorterDesc.moreData(intermediate);
        RowsAndColumnsHelper helper = new RowsAndColumnsHelper().expectColumn("ints", new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 14, 15, 16, 17, 18, 19}).expectColumn("strs", new Object[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "o", "p", "q", "r", "s", "t"}, ColumnType.STRING).allColumnsRegistered();
        RowsAndColumns intSorted = intSorter.complete();
        helper.validate(intSorted);
        RowsAndColumns strSorted = stringSorter.complete();
        helper.validate(strSorted);
        RowsAndColumnsHelper descendingHelper = new RowsAndColumnsHelper().expectColumn("ints", new int[]{19, 18, 17, 16, 15, 14, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0}).expectColumn("strs", new Object[]{"t", "s", "r", "q", "p", "o", "o", "n", "m", "l", "k", "j", "i", "h", "g", "f", "e", "d", "c", "b", "a"}, ColumnType.STRING).allColumnsRegistered();
        RowsAndColumns intSortedDesc = intSorterDesc.complete();
        descendingHelper.validate(intSortedDesc);
        RowsAndColumns strSortedDesc = stringSorterDesc.complete();
        descendingHelper.validate(strSortedDesc);
    }

    @Test
    public void testSortOneChunk() {
        RowsAndColumns first = this.make(MapOfColumnsRowsAndColumns.of((String)"ints", (Column)new IntArrayColumn(new int[]{1, 7, 13, 0, 19}), (String)"strs", (Column)new ObjectArrayColumn(new Object[]{"b", "h", "n", "a", "t"}, ColumnType.STRING)));
        NaiveSortMaker maker = (NaiveSortMaker)first.as(NaiveSortMaker.class);
        if (maker == null) {
            maker = new DefaultNaiveSortMaker(first);
        }
        NaiveSortMaker.NaiveSorter sorter = maker.make(new ColumnWithDirection[]{ColumnWithDirection.ascending((String)"ints")});
        NaiveSortMaker.NaiveSorter stringSorter = maker.make(new ColumnWithDirection[]{ColumnWithDirection.ascending((String)"strs")});
        NaiveSortMaker.NaiveSorter sorterDesc = maker.make(new ColumnWithDirection[]{ColumnWithDirection.descending((String)"ints")});
        NaiveSortMaker.NaiveSorter stringSorterDesc = maker.make(new ColumnWithDirection[]{ColumnWithDirection.descending((String)"strs")});
        RowsAndColumnsHelper helper = new RowsAndColumnsHelper().expectColumn("ints", new int[]{0, 1, 7, 13, 19}).expectColumn("strs", new Object[]{"a", "b", "h", "n", "t"}, ColumnType.STRING).allColumnsRegistered();
        RowsAndColumns sorted = sorter.complete();
        helper.validate(sorted);
        RowsAndColumns stringSorted = stringSorter.complete();
        helper.validate(stringSorted);
        RowsAndColumnsHelper descendingHelper = new RowsAndColumnsHelper().expectColumn("ints", new int[]{19, 13, 7, 1, 0}).expectColumn("strs", new Object[]{"t", "n", "h", "b", "a"}, ColumnType.STRING).allColumnsRegistered();
        RowsAndColumns sortedDesc = sorterDesc.complete();
        descendingHelper.validate(sortedDesc);
        RowsAndColumns stringSortedDesc = stringSorterDesc.complete();
        descendingHelper.validate(stringSortedDesc);
    }
}

