/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import it.unimi.dsi.fastutil.objects.ObjectAVLTreeSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.segment.AggregateProjectionMetadata;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class AggregateProjectionMetadataTest
extends InitializedNullHandlingTest {
    private static final ObjectMapper JSON_MAPPER = TestHelper.makeJsonMapper();

    AggregateProjectionMetadataTest() {
    }

    @Test
    void testSerde() throws JsonProcessingException {
        AggregateProjectionMetadata spec = new AggregateProjectionMetadata(new AggregateProjectionMetadata.Schema("some_projection", "time", VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"time")}), Arrays.asList("a", "b", "time", "c", "d"), new AggregatorFactory[]{new CountAggregatorFactory("count"), new LongSumAggregatorFactory("e", "e")}, Arrays.asList(OrderBy.ascending((String)"a"), OrderBy.ascending((String)"b"), OrderBy.ascending((String)"time"), OrderBy.ascending((String)"c"), OrderBy.ascending((String)"d"))), 12345);
        Assertions.assertEquals((Object)spec, (Object)JSON_MAPPER.readValue(JSON_MAPPER.writeValueAsString((Object)spec), AggregateProjectionMetadata.class));
    }

    @Test
    void testComparator() {
        ObjectAVLTreeSet metadataBest = new ObjectAVLTreeSet(AggregateProjectionMetadata.COMPARATOR);
        AggregateProjectionMetadata good = new AggregateProjectionMetadata(new AggregateProjectionMetadata.Schema("good", "theTime", VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"theTime")}), Arrays.asList("theTime", "a", "b", "c"), new AggregatorFactory[]{new CountAggregatorFactory("chocula")}, Arrays.asList(OrderBy.ascending((String)"theTime"), OrderBy.ascending((String)"a"), OrderBy.ascending((String)"b"), OrderBy.ascending((String)"c"))), 123);
        AggregateProjectionMetadata betterLessGroupingColumns = new AggregateProjectionMetadata(new AggregateProjectionMetadata.Schema("betterLessGroupingColumns", "theTime", VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"theTime")}), Arrays.asList("c", "d", "theTime"), new AggregatorFactory[]{new CountAggregatorFactory("chocula")}, Arrays.asList(OrderBy.ascending((String)"c"), OrderBy.ascending((String)"d"), OrderBy.ascending((String)"theTime"))), 123);
        AggregateProjectionMetadata evenBetterMoreAggs = new AggregateProjectionMetadata(new AggregateProjectionMetadata.Schema("evenBetterMoreAggs", "theTime", VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"theTime")}), Arrays.asList("c", "d", "theTime"), new AggregatorFactory[]{new CountAggregatorFactory("chocula"), new LongSumAggregatorFactory("e", "e")}, Arrays.asList(OrderBy.ascending((String)"c"), OrderBy.ascending((String)"d"), OrderBy.ascending((String)"theTime"))), 123);
        AggregateProjectionMetadata best = new AggregateProjectionMetadata(new AggregateProjectionMetadata.Schema("best", null, VirtualColumns.EMPTY, Arrays.asList("f", "g"), new AggregatorFactory[0], Arrays.asList(OrderBy.ascending((String)"f"), OrderBy.ascending((String)"g"))), 10);
        metadataBest.add(good);
        metadataBest.add(betterLessGroupingColumns);
        metadataBest.add(evenBetterMoreAggs);
        metadataBest.add(best);
        Assertions.assertEquals((Object)best, metadataBest.first());
        Assertions.assertArrayEquals((Object[])new AggregateProjectionMetadata[]{best, evenBetterMoreAggs, betterLessGroupingColumns, good}, (Object[])metadataBest.toArray());
    }

    @Test
    void testInvalidName() {
        Throwable t = Assertions.assertThrows(DruidException.class, () -> new AggregateProjectionMetadata(new AggregateProjectionMetadata.Schema(null, null, null, null, new AggregatorFactory[]{new CountAggregatorFactory("count")}, List.of(OrderBy.ascending((String)"__time"), OrderBy.ascending((String)"count"))), 0));
        Assertions.assertEquals((Object)"projection schema name cannot be null or empty", (Object)t.getMessage());
        t = Assertions.assertThrows(DruidException.class, () -> new AggregateProjectionMetadata(new AggregateProjectionMetadata.Schema("", null, null, null, new AggregatorFactory[]{new CountAggregatorFactory("count")}, List.of(OrderBy.ascending((String)"__time"), OrderBy.ascending((String)"count"))), 0));
        Assertions.assertEquals((Object)"projection schema name cannot be null or empty", (Object)t.getMessage());
    }

    @Test
    void testInvalidGrouping() {
        Throwable t = Assertions.assertThrows(DruidException.class, () -> new AggregateProjectionMetadata(new AggregateProjectionMetadata.Schema("other_projection", null, null, null, null, null), 0));
        Assertions.assertEquals((Object)"projection schema[other_projection] groupingColumns and aggregators must not both be null or empty", (Object)t.getMessage());
        t = Assertions.assertThrows(DruidException.class, () -> new AggregateProjectionMetadata(new AggregateProjectionMetadata.Schema("other_projection", null, null, Collections.emptyList(), null, null), 0));
        Assertions.assertEquals((Object)"projection schema[other_projection] groupingColumns and aggregators must not both be null or empty", (Object)t.getMessage());
    }

    @Test
    void testInvalidOrdering() {
        Throwable t = Assertions.assertThrows(DruidException.class, () -> new AggregateProjectionMetadata(new AggregateProjectionMetadata.Schema("no order", null, null, null, new AggregatorFactory[]{new CountAggregatorFactory("count")}, null), 0));
        Assertions.assertEquals((Object)"projection schema[no order] ordering must not be null", (Object)t.getMessage());
        t = Assertions.assertThrows(DruidException.class, () -> new AggregateProjectionMetadata(new AggregateProjectionMetadata.Schema("", null, null, null, new AggregatorFactory[]{new CountAggregatorFactory("count")}, List.of(OrderBy.ascending((String)"__time"), OrderBy.ascending((String)"count"))), 0));
        Assertions.assertEquals((Object)"projection schema name cannot be null or empty", (Object)t.getMessage());
    }

    @Test
    void testEqualsAndHashcode() {
        EqualsVerifier.forClass(AggregateProjectionMetadata.class).usingGetClass().verify();
    }

    @Test
    void testEqualsAndHashcodeSchema() {
        EqualsVerifier.forClass(AggregateProjectionMetadata.Schema.class).withIgnoredFields(new String[]{"orderingWithTimeSubstitution", "timeColumnPosition", "granularity"}).usingGetClass().verify();
    }
}

