/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.collections.BlockingPool;
import org.apache.druid.collections.CloseableDefaultBlockingPool;
import org.apache.druid.collections.CloseableStupidPool;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.ListBasedInputRow;
import org.apache.druid.data.input.impl.AggregateProjectionSpec;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.DoubleDimensionSchema;
import org.apache.druid.data.input.impl.FloatDimensionSchema;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Result;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.FloatSumAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.last.LongLastAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.EqualityFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByResourcesReservationPool;
import org.apache.druid.query.groupby.GroupByStatsProvider;
import org.apache.druid.query.groupby.GroupingEngine;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.druid.query.groupby.orderby.LimitSpec;
import org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryEngine;
import org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.druid.segment.AutoTypeColumnSchema;
import org.apache.druid.segment.CloserRule;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.IncrementalIndexTimeBoundaryInspector;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexCursorFactory;
import org.apache.druid.segment.QueryableIndexTimeBoundaryInspector;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.TimeBoundaryInspector;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexCursorFactory;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.joda.time.DateTime;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CursorFactoryProjectionTest
extends InitializedNullHandlingTest {
    private static final Closer CLOSER = Closer.create();
    static final DateTime TIMESTAMP = Granularities.DAY.bucket(DateTimes.nowUtc()).getStart();
    static final RowSignature ROW_SIGNATURE = RowSignature.builder().add("a", ColumnType.STRING).add("b", ColumnType.STRING).add("c", ColumnType.LONG).add("d", ColumnType.DOUBLE).add("e", ColumnType.FLOAT).build();
    static final List<InputRow> ROWS = CursorFactoryProjectionTest.makeRows(ROW_SIGNATURE.getColumnNames());
    static final List<InputRow> ROLLUP_ROWS = CursorFactoryProjectionTest.makeRows((List<String>)ImmutableList.of((Object)"a", (Object)"b"));
    private static final List<AggregateProjectionSpec> PROJECTIONS = Arrays.asList(new AggregateProjectionSpec("ab_hourly_cd_sum", VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"__gran")}), Arrays.asList(new StringDimensionSchema("a"), new StringDimensionSchema("b"), new LongDimensionSchema("__gran")), new AggregatorFactory[]{new LongSumAggregatorFactory("_c_sum", "c"), new DoubleSumAggregatorFactory("d", "d")}), new AggregateProjectionSpec("a_hourly_c_sum_with_count_latest", VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"__gran")}), Arrays.asList(new LongDimensionSchema("__gran"), new StringDimensionSchema("a")), new AggregatorFactory[]{new CountAggregatorFactory("chocula"), new LongSumAggregatorFactory("_c_sum", "c"), new LongLastAggregatorFactory("_c_last", "c", null)}), new AggregateProjectionSpec("b_hourly_c_sum_non_time_ordered", VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"__gran")}), Arrays.asList(new StringDimensionSchema("b"), new LongDimensionSchema("__gran")), new AggregatorFactory[]{new CountAggregatorFactory("chocula"), new LongSumAggregatorFactory("_c_sum", "c"), new LongLastAggregatorFactory("_c_last", "c", null)}), new AggregateProjectionSpec("bf_daily_c_sum", VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.DAY, (String)"__gran")}), Arrays.asList(new LongDimensionSchema("__gran"), new StringDimensionSchema("b"), new FloatDimensionSchema("e")), new AggregatorFactory[]{new LongSumAggregatorFactory("_c_sum", "c")}), new AggregateProjectionSpec("ab", null, Arrays.asList(new StringDimensionSchema("a"), new StringDimensionSchema("b")), null), new AggregateProjectionSpec("abfoo", VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{new ExpressionVirtualColumn("bfoo", "concat(b, 'foo')", ColumnType.STRING, TestExprMacroTable.INSTANCE)}), Arrays.asList(new StringDimensionSchema("a"), new StringDimensionSchema("bfoo")), null), new AggregateProjectionSpec("c_sum_daily", VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.DAY, (String)"__gran")}), Collections.singletonList(new LongDimensionSchema("__gran")), new AggregatorFactory[]{new LongSumAggregatorFactory("_c_sum", "c")}), new AggregateProjectionSpec("c_sum", VirtualColumns.EMPTY, Collections.emptyList(), new AggregatorFactory[]{new LongSumAggregatorFactory("_c_sum", "c")}), new AggregateProjectionSpec("missing_column", VirtualColumns.EMPTY, List.of(new StringDimensionSchema("missing")), new AggregatorFactory[]{new LongSumAggregatorFactory("csum", "c")}));
    private static final List<AggregateProjectionSpec> ROLLUP_PROJECTIONS = Arrays.asList(new AggregateProjectionSpec("a_hourly_c_sum_with_count", VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"__gran")}), Arrays.asList(new LongDimensionSchema("__gran"), new StringDimensionSchema("a")), new AggregatorFactory[]{new CountAggregatorFactory("chocula"), new LongSumAggregatorFactory("sum_c", "sum_c")}), new AggregateProjectionSpec("afoo", VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{new ExpressionVirtualColumn("afoo", "concat(a, 'foo')", ColumnType.STRING, TestExprMacroTable.INSTANCE)}), List.of(new StringDimensionSchema("afoo")), new AggregatorFactory[]{new LongSumAggregatorFactory("sum_c", "sum_c")}));
    private static final List<AggregateProjectionSpec> AUTO_PROJECTIONS = PROJECTIONS.stream().map(projection -> new AggregateProjectionSpec(projection.getName(), projection.getVirtualColumns(), projection.getGroupingColumns().stream().map(x -> new AutoTypeColumnSchema(x.getName(), null)).collect(Collectors.toList()), projection.getAggregators())).collect(Collectors.toList());
    private static final List<AggregateProjectionSpec> AUTO_ROLLUP_PROJECTIONS = ROLLUP_PROJECTIONS.stream().map(projection -> new AggregateProjectionSpec(projection.getName(), projection.getVirtualColumns(), projection.getGroupingColumns().stream().map(x -> new AutoTypeColumnSchema(x.getName(), null)).collect(Collectors.toList()), projection.getAggregators())).collect(Collectors.toList());
    public final CursorFactory projectionsCursorFactory;
    public final TimeBoundaryInspector projectionsTimeBoundaryInspector;
    public final CursorFactory rollupProjectionsCursorFactory;
    public final TimeBoundaryInspector rollupProjectionsTimeBoundaryInspector;
    private final GroupingEngine groupingEngine;
    private final TimeseriesQueryEngine timeseriesEngine;
    private final NonBlockingPool<ByteBuffer> nonBlockingPool;
    public final boolean segmentSortedByTime;
    public final boolean autoSchema;
    @Rule
    public final CloserRule closer = new CloserRule(false);

    public static List<InputRow> makeRows(List<String> dimensions) {
        return Arrays.asList(new ListBasedInputRow(ROW_SIGNATURE, TIMESTAMP, dimensions, Arrays.asList("a", "aa", 1L, 1.0)), new ListBasedInputRow(ROW_SIGNATURE, TIMESTAMP.plusMinutes(2), dimensions, Arrays.asList("a", "bb", 1L, 1.1, Float.valueOf(1.1f))), new ListBasedInputRow(ROW_SIGNATURE, TIMESTAMP.plusMinutes(4), dimensions, Arrays.asList("a", "cc", 2L, 2.2, Float.valueOf(2.2f))), new ListBasedInputRow(ROW_SIGNATURE, TIMESTAMP.plusMinutes(6), dimensions, Arrays.asList("b", "aa", 3L, 3.3, Float.valueOf(3.3f))), new ListBasedInputRow(ROW_SIGNATURE, TIMESTAMP.plusMinutes(8), dimensions, Arrays.asList("b", "aa", 4L, 4.4, Float.valueOf(4.4f))), new ListBasedInputRow(ROW_SIGNATURE, TIMESTAMP.plusMinutes(10), dimensions, Arrays.asList("b", "bb", 5L, 5.5, Float.valueOf(5.5f))), new ListBasedInputRow(ROW_SIGNATURE, TIMESTAMP.plusHours(1), dimensions, Arrays.asList("a", "aa", 1L, 1.1, Float.valueOf(1.1f))), new ListBasedInputRow(ROW_SIGNATURE, TIMESTAMP.plusHours(1).plusMinutes(1), dimensions, Arrays.asList("a", "dd", 2L, 2.2, Float.valueOf(2.2f))));
    }

    @Parameterized.Parameters(name="name: {0}, segmentTimeOrdered: {5}, autoSchema: {6}")
    public static Collection<?> constructorFeeder() {
        ArrayList<Object[]> constructors = new ArrayList<Object[]>();
        DimensionsSpec.Builder dimensionsBuilder = DimensionsSpec.builder().setDimensions(Arrays.asList(new StringDimensionSchema("a"), new StringDimensionSchema("b"), new LongDimensionSchema("c"), new DoubleDimensionSchema("d"), new FloatDimensionSchema("e"), new StringDimensionSchema("missing")));
        DimensionsSpec.Builder rollupDimensionsBuilder = DimensionsSpec.builder().setDimensions(Arrays.asList(new StringDimensionSchema("a"), new StringDimensionSchema("b")));
        AggregatorFactory[] rollupAggs = new AggregatorFactory[]{new LongSumAggregatorFactory("sum_c", "c"), new DoubleSumAggregatorFactory("sum_d", "d"), new FloatSumAggregatorFactory("sum_e", "e")};
        DimensionsSpec dimsTimeOrdered = dimensionsBuilder.build();
        DimensionsSpec dimsOrdered = dimensionsBuilder.setForceSegmentSortByTime(Boolean.valueOf(false)).build();
        DimensionsSpec rollupDimsTimeOrdered = rollupDimensionsBuilder.build();
        DimensionsSpec rollupDimsOrdered = rollupDimensionsBuilder.setForceSegmentSortByTime(Boolean.valueOf(false)).build();
        List autoDims = dimsOrdered.getDimensions().stream().map(x -> new AutoTypeColumnSchema(x.getName(), null)).collect(Collectors.toList());
        List rollupAutoDims = rollupDimsOrdered.getDimensions().stream().map(x -> new AutoTypeColumnSchema(x.getName(), null)).collect(Collectors.toList());
        for (boolean incremental : new boolean[]{true, false}) {
            for (boolean sortByDim : new boolean[]{true, false}) {
                for (boolean autoSchema : new boolean[]{false, true}) {
                    for (boolean writeNullColumns : new boolean[]{true, false}) {
                        IncrementalIndex rollupIndex;
                        IncrementalIndex index;
                        DimensionsSpec rollupDims;
                        DimensionsSpec dims;
                        if (sortByDim) {
                            if (autoSchema) {
                                dims = dimsOrdered.withDimensions(autoDims);
                                rollupDims = rollupDimsOrdered.withDimensions(rollupAutoDims);
                            } else {
                                dims = dimsOrdered;
                                rollupDims = rollupDimsOrdered;
                            }
                        } else if (autoSchema) {
                            dims = dimsTimeOrdered.withDimensions(autoDims);
                            rollupDims = rollupDimsTimeOrdered.withDimensions(autoDims);
                        } else {
                            dims = dimsTimeOrdered;
                            rollupDims = rollupDimsTimeOrdered;
                        }
                        if (incremental) {
                            index = (IncrementalIndex)CLOSER.register((Closeable)CursorFactoryProjectionTest.makeBuilder(dims, autoSchema, writeNullColumns).buildIncrementalIndex());
                            rollupIndex = (IncrementalIndex)CLOSER.register((Closeable)CursorFactoryProjectionTest.makeRollupBuilder(rollupDims, rollupAggs, autoSchema).buildIncrementalIndex());
                            constructors.add(new Object[]{"incrementalIndex", new IncrementalIndexCursorFactory(index), new IncrementalIndexTimeBoundaryInspector(index), new IncrementalIndexCursorFactory(rollupIndex), new IncrementalIndexTimeBoundaryInspector(rollupIndex), !sortByDim, autoSchema});
                            continue;
                        }
                        index = (QueryableIndex)CLOSER.register((Closeable)CursorFactoryProjectionTest.makeBuilder(dims, autoSchema, writeNullColumns).buildMMappedIndex());
                        rollupIndex = (QueryableIndex)CLOSER.register((Closeable)CursorFactoryProjectionTest.makeRollupBuilder(rollupDims, rollupAggs, autoSchema).buildMMappedIndex());
                        constructors.add(new Object[]{"queryableIndex", new QueryableIndexCursorFactory((QueryableIndex)index), QueryableIndexTimeBoundaryInspector.create((QueryableIndex)index), new QueryableIndexCursorFactory((QueryableIndex)rollupIndex), QueryableIndexTimeBoundaryInspector.create((QueryableIndex)rollupIndex), !sortByDim, autoSchema});
                    }
                }
            }
        }
        return constructors;
    }

    @AfterClass
    public static void cleanup() throws IOException {
        CLOSER.close();
    }

    public CursorFactoryProjectionTest(String name, CursorFactory projectionsCursorFactory, TimeBoundaryInspector projectionsTimeBoundaryInspector, CursorFactory rollupProjectionsCursorFactory, TimeBoundaryInspector rollupProjectionsTimeBoundaryInspector, boolean segmentSortedByTime, boolean autoSchema) {
        this.projectionsCursorFactory = projectionsCursorFactory;
        this.projectionsTimeBoundaryInspector = projectionsTimeBoundaryInspector;
        this.rollupProjectionsCursorFactory = rollupProjectionsCursorFactory;
        this.rollupProjectionsTimeBoundaryInspector = rollupProjectionsTimeBoundaryInspector;
        this.segmentSortedByTime = segmentSortedByTime;
        this.autoSchema = autoSchema;
        this.nonBlockingPool = (NonBlockingPool)this.closer.closeLater(new CloseableStupidPool("GroupByQueryEngine-bufferPool", () -> ByteBuffer.allocate(50000)));
        this.groupingEngine = new GroupingEngine(new DruidProcessingConfig(), GroupByQueryConfig::new, new GroupByResourcesReservationPool((BlockingPool)this.closer.closeLater(new CloseableDefaultBlockingPool(() -> ByteBuffer.allocate(50000), 5)), new GroupByQueryConfig()), TestHelper.makeJsonMapper(), TestHelper.makeSmileMapper(), (query, future) -> {}, new GroupByStatsProvider());
        this.timeseriesEngine = new TimeseriesQueryEngine(this.nonBlockingPool);
    }

    @Test
    public void testProjectionSelectionTwoDims() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).addDimension("a").addDimension("b").build();
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, null);
        try (CursorHolder cursorHolder = this.projectionsCursorFactory.makeCursorHolder(buildSpec);){
            Cursor cursor = cursorHolder.asCursor();
            int rowCount = 0;
            while (!cursor.isDone()) {
                ++rowCount;
                cursor.advance();
            }
            Assert.assertEquals((long)6L, (long)rowCount);
        }
        Sequence resultRows = this.groupingEngine.process(query, this.projectionsCursorFactory, this.projectionsTimeBoundaryInspector, this.nonBlockingPool, null);
        List results = resultRows.toList();
        Assert.assertEquals((long)6L, (long)results.size());
        if (this.projectionsCursorFactory instanceof QueryableIndexCursorFactory) {
            if (this.autoSchema) {
                Assert.assertArrayEquals((Object[])new Object[]{"b", "bb"}, (Object[])((ResultRow)results.get(0)).getArray());
                Assert.assertArrayEquals((Object[])new Object[]{"a", "dd"}, (Object[])((ResultRow)results.get(1)).getArray());
                Assert.assertArrayEquals((Object[])new Object[]{"b", "aa"}, (Object[])((ResultRow)results.get(2)).getArray());
                Assert.assertArrayEquals((Object[])new Object[]{"a", "cc"}, (Object[])((ResultRow)results.get(3)).getArray());
                Assert.assertArrayEquals((Object[])new Object[]{"a", "bb"}, (Object[])((ResultRow)results.get(4)).getArray());
                Assert.assertArrayEquals((Object[])new Object[]{"a", "aa"}, (Object[])((ResultRow)results.get(5)).getArray());
            } else {
                Assert.assertArrayEquals((Object[])new Object[]{"a", "dd"}, (Object[])((ResultRow)results.get(0)).getArray());
                Assert.assertArrayEquals((Object[])new Object[]{"a", "aa"}, (Object[])((ResultRow)results.get(1)).getArray());
                Assert.assertArrayEquals((Object[])new Object[]{"b", "aa"}, (Object[])((ResultRow)results.get(2)).getArray());
                Assert.assertArrayEquals((Object[])new Object[]{"a", "cc"}, (Object[])((ResultRow)results.get(3)).getArray());
                Assert.assertArrayEquals((Object[])new Object[]{"a", "bb"}, (Object[])((ResultRow)results.get(4)).getArray());
                Assert.assertArrayEquals((Object[])new Object[]{"b", "bb"}, (Object[])((ResultRow)results.get(5)).getArray());
            }
        } else {
            Assert.assertArrayEquals((Object[])new Object[]{"a", "aa"}, (Object[])((ResultRow)results.get(0)).getArray());
            Assert.assertArrayEquals((Object[])new Object[]{"a", "bb"}, (Object[])((ResultRow)results.get(1)).getArray());
            Assert.assertArrayEquals((Object[])new Object[]{"a", "cc"}, (Object[])((ResultRow)results.get(2)).getArray());
            Assert.assertArrayEquals((Object[])new Object[]{"a", "dd"}, (Object[])((ResultRow)results.get(3)).getArray());
            Assert.assertArrayEquals((Object[])new Object[]{"b", "aa"}, (Object[])((ResultRow)results.get(4)).getArray());
            Assert.assertArrayEquals((Object[])new Object[]{"b", "bb"}, (Object[])((ResultRow)results.get(5)).getArray());
        }
    }

    @Test
    public void testProjectionSelectionTwoDimsVirtual() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).addDimension("a").addDimension("v0").setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "concat(b, 'foo')", ColumnType.STRING, TestExprMacroTable.INSTANCE)}).setLimitSpec((LimitSpec)new DefaultLimitSpec(Arrays.asList(new OrderByColumnSpec("a", OrderByColumnSpec.Direction.ASCENDING, StringComparators.LEXICOGRAPHIC), new OrderByColumnSpec("v0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.LEXICOGRAPHIC)), Integer.valueOf(10))).setContext((Map)ImmutableMap.of((Object)"useProjection", (Object)"abfoo")).build();
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, null);
        try (CursorHolder cursorHolder = this.projectionsCursorFactory.makeCursorHolder(buildSpec);){
            Cursor cursor = cursorHolder.asCursor();
            int rowCount = 0;
            while (!cursor.isDone()) {
                ++rowCount;
                cursor.advance();
            }
            Assert.assertEquals((long)6L, (long)rowCount);
        }
        Sequence resultRows = this.groupingEngine.process(query, this.projectionsCursorFactory, this.projectionsTimeBoundaryInspector, this.nonBlockingPool, null);
        List results = resultRows.toList();
        Assert.assertEquals((long)6L, (long)results.size());
        if (this.projectionsCursorFactory instanceof QueryableIndexCursorFactory) {
            if (this.autoSchema) {
                Assert.assertArrayEquals((Object[])new Object[]{"b", "bbfoo"}, (Object[])((ResultRow)results.get(0)).getArray());
                Assert.assertArrayEquals((Object[])new Object[]{"a", "ddfoo"}, (Object[])((ResultRow)results.get(1)).getArray());
                Assert.assertArrayEquals((Object[])new Object[]{"b", "aafoo"}, (Object[])((ResultRow)results.get(2)).getArray());
                Assert.assertArrayEquals((Object[])new Object[]{"a", "ccfoo"}, (Object[])((ResultRow)results.get(3)).getArray());
                Assert.assertArrayEquals((Object[])new Object[]{"a", "bbfoo"}, (Object[])((ResultRow)results.get(4)).getArray());
                Assert.assertArrayEquals((Object[])new Object[]{"a", "aafoo"}, (Object[])((ResultRow)results.get(5)).getArray());
            } else {
                Assert.assertArrayEquals((Object[])new Object[]{"a", "ddfoo"}, (Object[])((ResultRow)results.get(0)).getArray());
                Assert.assertArrayEquals((Object[])new Object[]{"a", "aafoo"}, (Object[])((ResultRow)results.get(1)).getArray());
                Assert.assertArrayEquals((Object[])new Object[]{"b", "aafoo"}, (Object[])((ResultRow)results.get(2)).getArray());
                Assert.assertArrayEquals((Object[])new Object[]{"a", "ccfoo"}, (Object[])((ResultRow)results.get(3)).getArray());
                Assert.assertArrayEquals((Object[])new Object[]{"a", "bbfoo"}, (Object[])((ResultRow)results.get(4)).getArray());
                Assert.assertArrayEquals((Object[])new Object[]{"b", "bbfoo"}, (Object[])((ResultRow)results.get(5)).getArray());
            }
        } else {
            Assert.assertArrayEquals((Object[])new Object[]{"a", "aafoo"}, (Object[])((ResultRow)results.get(0)).getArray());
            Assert.assertArrayEquals((Object[])new Object[]{"a", "bbfoo"}, (Object[])((ResultRow)results.get(1)).getArray());
            Assert.assertArrayEquals((Object[])new Object[]{"a", "ccfoo"}, (Object[])((ResultRow)results.get(2)).getArray());
            Assert.assertArrayEquals((Object[])new Object[]{"a", "ddfoo"}, (Object[])((ResultRow)results.get(3)).getArray());
            Assert.assertArrayEquals((Object[])new Object[]{"b", "aafoo"}, (Object[])((ResultRow)results.get(4)).getArray());
            Assert.assertArrayEquals((Object[])new Object[]{"b", "bbfoo"}, (Object[])((ResultRow)results.get(5)).getArray());
        }
    }

    @Test
    public void testProjectionSelectionTwoDimsCount() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).addDimension("a").addDimension("b").addAggregator((AggregatorFactory)new CountAggregatorFactory("count")).build();
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, null);
        try (CursorHolder cursorHolder = this.projectionsCursorFactory.makeCursorHolder(buildSpec);){
            Cursor cursor = cursorHolder.asCursor();
            int rowCount = 0;
            while (!cursor.isDone()) {
                ++rowCount;
                cursor.advance();
            }
            Assert.assertEquals((long)8L, (long)rowCount);
        }
        Sequence resultRows = this.groupingEngine.process(query, this.projectionsCursorFactory, this.projectionsTimeBoundaryInspector, this.nonBlockingPool, null);
        List results = resultRows.toList();
        Assert.assertEquals((long)6L, (long)results.size());
        if (this.projectionsCursorFactory instanceof QueryableIndexCursorFactory) {
            if (this.autoSchema) {
                Assert.assertArrayEquals((Object[])new Object[]{"b", "aa", 2L}, (Object[])((ResultRow)results.get(0)).getArray());
                Assert.assertArrayEquals((Object[])new Object[]{"a", "cc", 1L}, (Object[])((ResultRow)results.get(1)).getArray());
                Assert.assertArrayEquals((Object[])new Object[]{"a", "bb", 1L}, (Object[])((ResultRow)results.get(2)).getArray());
                Assert.assertArrayEquals((Object[])new Object[]{"b", "bb", 1L}, (Object[])((ResultRow)results.get(3)).getArray());
                Assert.assertArrayEquals((Object[])new Object[]{"a", "dd", 1L}, (Object[])((ResultRow)results.get(4)).getArray());
                Assert.assertArrayEquals((Object[])new Object[]{"a", "aa", 2L}, (Object[])((ResultRow)results.get(5)).getArray());
            } else {
                Assert.assertArrayEquals((Object[])new Object[]{"a", "dd", 1L}, (Object[])((ResultRow)results.get(0)).getArray());
                Assert.assertArrayEquals((Object[])new Object[]{"a", "aa", 2L}, (Object[])((ResultRow)results.get(1)).getArray());
                Assert.assertArrayEquals((Object[])new Object[]{"a", "bb", 1L}, (Object[])((ResultRow)results.get(2)).getArray());
                Assert.assertArrayEquals((Object[])new Object[]{"b", "aa", 2L}, (Object[])((ResultRow)results.get(3)).getArray());
                Assert.assertArrayEquals((Object[])new Object[]{"a", "cc", 1L}, (Object[])((ResultRow)results.get(4)).getArray());
                Assert.assertArrayEquals((Object[])new Object[]{"b", "bb", 1L}, (Object[])((ResultRow)results.get(5)).getArray());
            }
        } else {
            Assert.assertArrayEquals((Object[])new Object[]{"a", "aa", 2L}, (Object[])((ResultRow)results.get(0)).getArray());
            Assert.assertArrayEquals((Object[])new Object[]{"a", "bb", 1L}, (Object[])((ResultRow)results.get(1)).getArray());
            Assert.assertArrayEquals((Object[])new Object[]{"a", "cc", 1L}, (Object[])((ResultRow)results.get(2)).getArray());
            Assert.assertArrayEquals((Object[])new Object[]{"b", "aa", 2L}, (Object[])((ResultRow)results.get(3)).getArray());
            Assert.assertArrayEquals((Object[])new Object[]{"b", "bb", 1L}, (Object[])((ResultRow)results.get(4)).getArray());
            Assert.assertArrayEquals((Object[])new Object[]{"a", "dd", 1L}, (Object[])((ResultRow)results.get(5)).getArray());
        }
    }

    @Test
    public void testProjectionSelectionTwoDimsCountForce() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).addDimension("a").addDimension("b").addAggregator((AggregatorFactory)new CountAggregatorFactory("count")).setContext((Map)ImmutableMap.of((Object)"forceProjections", (Object)true)).build();
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, null);
        Throwable t = Assert.assertThrows(DruidException.class, () -> this.projectionsCursorFactory.makeCursorHolder(buildSpec));
        Assert.assertEquals((Object)"Force projections specified, but none satisfy query", (Object)t.getMessage());
    }

    @Test
    public void testProjectionSkipContext() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).addDimension("a").addAggregator((AggregatorFactory)new LongSumAggregatorFactory("c_sum", "c")).addAggregator((AggregatorFactory)new LongLastAggregatorFactory("c_last", "c", null)).setContext((Map)ImmutableMap.of((Object)"noProjections", (Object)true)).build();
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, null);
        try (CursorHolder cursorHolder = this.projectionsCursorFactory.makeCursorHolder(buildSpec);){
            Cursor cursor = cursorHolder.asCursor();
            int rowCount = 0;
            while (!cursor.isDone()) {
                ++rowCount;
                cursor.advance();
            }
            Assert.assertEquals((long)8L, (long)rowCount);
        }
        Sequence resultRows = this.groupingEngine.process(query, this.projectionsCursorFactory, this.projectionsTimeBoundaryInspector, this.nonBlockingPool, null);
        List results = resultRows.toList();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertArrayEquals((Object[])new Object[]{"a", 7L, Pair.of((Object)TIMESTAMP.plusHours(1).plusMinutes(1).getMillis(), (Object)2L)}, (Object[])((ResultRow)results.get(0)).getArray());
        Assert.assertArrayEquals((Object[])new Object[]{"b", 12L, Pair.of((Object)TIMESTAMP.plusMinutes(10).getMillis(), (Object)5L)}, (Object[])((ResultRow)results.get(1)).getArray());
    }

    @Test
    public void testProjectionSingleDim() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).addDimension("a").addAggregator((AggregatorFactory)new LongSumAggregatorFactory("c_sum", "c")).addAggregator((AggregatorFactory)new LongLastAggregatorFactory("c_last", "c", null)).build();
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, null);
        try (CursorHolder cursorHolder = this.projectionsCursorFactory.makeCursorHolder(buildSpec);){
            Cursor cursor = cursorHolder.asCursor();
            int rowCount = 0;
            while (!cursor.isDone()) {
                ++rowCount;
                cursor.advance();
            }
            Assert.assertEquals((long)3L, (long)rowCount);
        }
        Sequence resultRows = this.groupingEngine.process(query, this.projectionsCursorFactory, this.projectionsTimeBoundaryInspector, this.nonBlockingPool, null);
        List results = resultRows.toList();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertArrayEquals((Object[])new Object[]{"a", 7L, Pair.of((Object)TIMESTAMP.plusHours(1).plusMinutes(1).getMillis(), (Object)2L)}, (Object[])((ResultRow)results.get(0)).getArray());
        Assert.assertArrayEquals((Object[])new Object[]{"b", 12L, Pair.of((Object)TIMESTAMP.plusMinutes(10).getMillis(), (Object)5L)}, (Object[])((ResultRow)results.get(1)).getArray());
    }

    @Test
    public void testProjectionSingleDimMissing() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).addDimension("missing").addAggregator((AggregatorFactory)new LongSumAggregatorFactory("c_sum", "c")).build();
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, null);
        try (CursorHolder cursorHolder = this.projectionsCursorFactory.makeCursorHolder(buildSpec);){
            Cursor cursor = cursorHolder.asCursor();
            int rowCount = 0;
            while (!cursor.isDone()) {
                ++rowCount;
                cursor.advance();
            }
            Assert.assertEquals((long)1L, (long)rowCount);
        }
        Sequence resultRows = this.groupingEngine.process(query, this.projectionsCursorFactory, this.projectionsTimeBoundaryInspector, this.nonBlockingPool, null);
        List results = resultRows.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertArrayEquals((Object[])new Object[]{null, 19L}, (Object[])((ResultRow)results.get(0)).getArray());
    }

    @Test
    public void testProjectionSingleDimFilter() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).addDimension("a").setDimFilter((DimFilter)new EqualityFilter("a", ColumnType.STRING, (Object)"a", null)).addAggregator((AggregatorFactory)new LongSumAggregatorFactory("c_sum", "c")).addAggregator((AggregatorFactory)new LongLastAggregatorFactory("c_last", "c", null)).build();
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, null);
        try (CursorHolder cursorHolder = this.projectionsCursorFactory.makeCursorHolder(buildSpec);){
            Cursor cursor = cursorHolder.asCursor();
            int rowCount = 0;
            while (!cursor.isDone()) {
                ++rowCount;
                cursor.advance();
            }
            Assert.assertEquals((long)2L, (long)rowCount);
        }
        Sequence resultRows = this.groupingEngine.process(query, this.projectionsCursorFactory, this.projectionsTimeBoundaryInspector, this.nonBlockingPool, null);
        List results = resultRows.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertArrayEquals((Object[])new Object[]{"a", 7L, Pair.of((Object)TIMESTAMP.plusHours(1).plusMinutes(1).getMillis(), (Object)2L)}, (Object[])((ResultRow)results.get(0)).getArray());
    }

    @Test
    public void testProjectionSingleDimCount() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).addDimension("a").addAggregator((AggregatorFactory)new LongSumAggregatorFactory("c_sum", "c")).addAggregator((AggregatorFactory)new CountAggregatorFactory("cnt")).build();
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, null);
        try (CursorHolder cursorHolder = this.projectionsCursorFactory.makeCursorHolder(buildSpec);){
            Cursor cursor = cursorHolder.asCursor();
            int rowCount = 0;
            while (!cursor.isDone()) {
                ++rowCount;
                cursor.advance();
            }
            Assert.assertEquals((long)3L, (long)rowCount);
        }
        Sequence resultRows = this.groupingEngine.process(query, this.projectionsCursorFactory, this.projectionsTimeBoundaryInspector, this.nonBlockingPool, null);
        List results = resultRows.toList();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertArrayEquals((Object[])new Object[]{"a", 7L, 5L}, (Object[])((ResultRow)results.get(0)).getArray());
        Assert.assertArrayEquals((Object[])new Object[]{"b", 12L, 3L}, (Object[])((ResultRow)results.get(1)).getArray());
    }

    @Test
    public void testProjectionSingleDimMultipleSameAggs() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).addDimension("a").addAggregator((AggregatorFactory)new LongSumAggregatorFactory("c_sum", "c")).addAggregator((AggregatorFactory)new LongSumAggregatorFactory("c_sum_2", "c")).build();
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, null);
        try (CursorHolder cursorHolder = this.projectionsCursorFactory.makeCursorHolder(buildSpec);){
            Cursor cursor = cursorHolder.asCursor();
            int rowCount = 0;
            while (!cursor.isDone()) {
                ++rowCount;
                cursor.advance();
            }
            Assert.assertEquals((long)3L, (long)rowCount);
        }
        Sequence resultRows = this.groupingEngine.process(query, this.projectionsCursorFactory, this.projectionsTimeBoundaryInspector, this.nonBlockingPool, null);
        List results = resultRows.toList();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertArrayEquals((Object[])new Object[]{"a", 7L, 7L}, (Object[])((ResultRow)results.get(0)).getArray());
        Assert.assertArrayEquals((Object[])new Object[]{"b", 12L, 12L}, (Object[])((ResultRow)results.get(1)).getArray());
    }

    /*
     * Exception decompiling
     */
    @Test
    public void testQueryGranularityFinerThanProjectionGranularity() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    public void testQueryGranularityFitsProjectionGranularity() {
        GroupByQuery.Builder queryBuilder = GroupByQuery.builder().setDataSource("test").setInterval(Intervals.ETERNITY).addAggregator((AggregatorFactory)new LongSumAggregatorFactory("c_sum", "c"));
        if (this.segmentSortedByTime) {
            queryBuilder.addDimension("a").setGranularity(Granularities.HOUR);
        } else {
            queryBuilder.setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"__gran", (ColumnType)ColumnType.LONG), DefaultDimensionSpec.of((String)"a")}).setVirtualColumns(new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"__gran")});
        }
        GroupByQuery query = queryBuilder.build();
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, null);
        try (CursorHolder cursorHolder = this.projectionsCursorFactory.makeCursorHolder(buildSpec);){
            Cursor cursor = cursorHolder.asCursor();
            int rowCount = 0;
            while (!cursor.isDone()) {
                ++rowCount;
                cursor.advance();
            }
            Assert.assertEquals((long)3L, (long)rowCount);
        }
        Sequence resultRows = this.groupingEngine.process(query, this.projectionsCursorFactory, this.projectionsTimeBoundaryInspector, this.nonBlockingPool, null);
        List results = resultRows.toList();
        Assert.assertEquals((long)3L, (long)results.size());
        if (!this.segmentSortedByTime && this.projectionsCursorFactory instanceof QueryableIndexCursorFactory) {
            Set<Object[]> resultsInNoParticularOrder = CursorFactoryProjectionTest.makeArrayResultSet({TIMESTAMP.getMillis(), "a", 4L}, {TIMESTAMP.getMillis(), "b", 12L}, {TIMESTAMP.plusHours(1).getMillis(), "a", 3L});
            for (ResultRow row : results) {
                Assert.assertTrue((boolean)resultsInNoParticularOrder.contains(row.getArray()));
            }
        } else {
            Assert.assertArrayEquals((Object[])new Object[]{TIMESTAMP.getMillis(), "a", 4L}, (Object[])((ResultRow)results.get(0)).getArray());
            Assert.assertArrayEquals((Object[])new Object[]{TIMESTAMP.getMillis(), "b", 12L}, (Object[])((ResultRow)results.get(1)).getArray());
            Assert.assertArrayEquals((Object[])new Object[]{TIMESTAMP.plusHours(1).getMillis(), "a", 3L}, (Object[])((ResultRow)results.get(2)).getArray());
        }
    }

    @Test
    public void testQueryGranularityFitsProjectionGranularityNotTimeOrdered() {
        GroupByQuery.Builder queryBuilder = GroupByQuery.builder().setDataSource("test").setInterval(Intervals.ETERNITY).addAggregator((AggregatorFactory)new LongSumAggregatorFactory("c_sum", "c"));
        if (this.segmentSortedByTime) {
            queryBuilder.addDimension("b").setGranularity(Granularities.HOUR);
        } else {
            queryBuilder.setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"__gran", (ColumnType)ColumnType.LONG), DefaultDimensionSpec.of((String)"b")}).setVirtualColumns(new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"__gran")});
        }
        GroupByQuery query = queryBuilder.build();
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, null);
        try (CursorHolder cursorHolder = this.projectionsCursorFactory.makeCursorHolder(buildSpec);){
            Cursor cursor = cursorHolder.asCursor();
            int rowCount = 0;
            while (!cursor.isDone()) {
                ++rowCount;
                cursor.advance();
            }
            Assert.assertEquals((long)(this.segmentSortedByTime ? 8L : 5L), (long)rowCount);
        }
        Sequence resultRows = this.groupingEngine.process(query, this.projectionsCursorFactory, this.projectionsTimeBoundaryInspector, this.nonBlockingPool, null);
        List results = resultRows.toList();
        Assert.assertEquals((long)5L, (long)results.size());
        Set<Object[]> resultsInNoParticularOrder = CursorFactoryProjectionTest.makeArrayResultSet({TIMESTAMP.getMillis(), "aa", 8L}, {TIMESTAMP.getMillis(), "bb", 6L}, {TIMESTAMP.getMillis(), "cc", 2L}, {TIMESTAMP.plusHours(1).getMillis(), "aa", 1L}, {TIMESTAMP.plusHours(1).getMillis(), "dd", 2L});
        for (ResultRow row : results) {
            Assert.assertTrue((String)("missing row" + row.toString()), (boolean)resultsInNoParticularOrder.contains(row.getArray()));
        }
    }

    @Test
    public void testQueryGranularityLargerProjectionGranularity() {
        GroupByQuery.Builder queryBuilder = GroupByQuery.builder().setDataSource("test").setInterval(Intervals.ETERNITY).addAggregator((AggregatorFactory)new LongSumAggregatorFactory("c_sum", "c"));
        if (this.segmentSortedByTime) {
            queryBuilder.addDimension("a").setGranularity(Granularities.DAY);
        } else {
            queryBuilder.setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"__gran", (ColumnType)ColumnType.LONG), DefaultDimensionSpec.of((String)"a")}).setVirtualColumns(new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.DAY, (String)"__gran")});
        }
        GroupByQuery query = queryBuilder.build();
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, null);
        try (CursorHolder cursorHolder = this.projectionsCursorFactory.makeCursorHolder(buildSpec);){
            Cursor cursor = cursorHolder.asCursor();
            int rowCount = 0;
            while (!cursor.isDone()) {
                ++rowCount;
                cursor.advance();
            }
            Assert.assertEquals((long)3L, (long)rowCount);
        }
        Sequence resultRows = this.groupingEngine.process(query, this.projectionsCursorFactory, this.projectionsTimeBoundaryInspector, this.nonBlockingPool, null);
        List results = resultRows.toList();
        Assert.assertEquals((long)2L, (long)results.size());
        if (!this.segmentSortedByTime && this.projectionsCursorFactory instanceof QueryableIndexCursorFactory) {
            Set<Object[]> resultsInNoParticularOrder = CursorFactoryProjectionTest.makeArrayResultSet({TIMESTAMP.getMillis(), "a", 7L}, {TIMESTAMP.getMillis(), "b", 12L});
            for (ResultRow row : results) {
                Assert.assertTrue((boolean)resultsInNoParticularOrder.contains(row.getArray()));
            }
        } else {
            Assert.assertArrayEquals((Object[])new Object[]{TIMESTAMP.getMillis(), "a", 7L}, (Object[])((ResultRow)results.get(0)).getArray());
            Assert.assertArrayEquals((Object[])new Object[]{TIMESTAMP.getMillis(), "b", 12L}, (Object[])((ResultRow)results.get(1)).getArray());
        }
    }

    @Test
    public void testProjectionSelectionMissingAggregatorButHasAggregatorInput() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).addDimension("b").addAggregator((AggregatorFactory)new LongSumAggregatorFactory("c_sum", "c")).addAggregator((AggregatorFactory)new FloatSumAggregatorFactory("e_sum", "e")).build();
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, null);
        try (CursorHolder cursorHolder = this.projectionsCursorFactory.makeCursorHolder(buildSpec);){
            Cursor cursor = cursorHolder.asCursor();
            int rowCount = 0;
            while (!cursor.isDone()) {
                ++rowCount;
                cursor.advance();
            }
            Assert.assertEquals((long)8L, (long)rowCount);
        }
        Sequence resultRows = this.groupingEngine.process(query, this.projectionsCursorFactory, this.projectionsTimeBoundaryInspector, this.nonBlockingPool, null);
        List results = resultRows.toList();
        Assert.assertEquals((long)4L, (long)results.size());
        Assert.assertArrayEquals((Object[])new Object[]{"aa", 9L, Float.valueOf(8.8f)}, (Object[])((ResultRow)results.get(0)).getArray());
        Assert.assertArrayEquals((Object[])new Object[]{"bb", 6L, Float.valueOf(6.6f)}, (Object[])((ResultRow)results.get(1)).getArray());
        Assert.assertArrayEquals((Object[])new Object[]{"cc", 2L, Float.valueOf(2.2f)}, (Object[])((ResultRow)results.get(2)).getArray());
        Assert.assertArrayEquals((Object[])new Object[]{"dd", 2L, Float.valueOf(2.2f)}, (Object[])((ResultRow)results.get(3)).getArray());
    }

    @Test
    public void testProjectionSelectionMissingAggregatorAndAggregatorInput() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).addDimension("a").addAggregator((AggregatorFactory)new LongSumAggregatorFactory("c_sum", "c")).addAggregator((AggregatorFactory)new DoubleSumAggregatorFactory("d_sum", "d")).build();
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, null);
        try (CursorHolder cursorHolder = this.projectionsCursorFactory.makeCursorHolder(buildSpec);){
            Cursor cursor = cursorHolder.asCursor();
            int rowCount = 0;
            while (!cursor.isDone()) {
                ++rowCount;
                cursor.advance();
            }
            Assert.assertEquals((long)7L, (long)rowCount);
        }
        Sequence resultRows = this.groupingEngine.process(query, this.projectionsCursorFactory, this.projectionsTimeBoundaryInspector, this.nonBlockingPool, null);
        List results = resultRows.toList();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertArrayEquals((Object[])new Object[]{"a", 7L, 7.6000000000000005}, (Object[])((ResultRow)results.get(0)).getArray());
        Assert.assertArrayEquals((Object[])new Object[]{"b", 12L, 13.2}, (Object[])((ResultRow)results.get(1)).getArray());
    }

    @Test
    public void testProjectionSelectionMissingColumnOnBaseTableToo() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).addDimension("a").addDimension("z").addAggregator((AggregatorFactory)new LongSumAggregatorFactory("c_sum", "c")).addAggregator((AggregatorFactory)new DoubleSumAggregatorFactory("d_sum", "d")).build();
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, null);
        try (CursorHolder cursorHolder = this.projectionsCursorFactory.makeCursorHolder(buildSpec);){
            Cursor cursor = cursorHolder.asCursor();
            int rowCount = 0;
            while (!cursor.isDone()) {
                ++rowCount;
                cursor.advance();
            }
            Assert.assertEquals((long)7L, (long)rowCount);
        }
        Sequence resultRows = this.groupingEngine.process(query, this.projectionsCursorFactory, this.projectionsTimeBoundaryInspector, this.nonBlockingPool, null);
        List results = resultRows.toList();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertArrayEquals((Object[])new Object[]{"a", null, 7L, 7.6000000000000005}, (Object[])((ResultRow)results.get(0)).getArray());
        Assert.assertArrayEquals((Object[])new Object[]{"b", null, 12L, 13.2}, (Object[])((ResultRow)results.get(1)).getArray());
    }

    @Test
    public void testTimeseriesQueryGranularityFitsProjectionGranularity() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test").intervals((List)ImmutableList.of((Object)Intervals.ETERNITY)).granularity(Granularities.HOUR).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("c_sum", "c")}).build();
        CursorBuildSpec buildSpec = TimeseriesQueryEngine.makeCursorBuildSpec((TimeseriesQuery)query, null);
        try (CursorHolder cursorHolder = this.projectionsCursorFactory.makeCursorHolder(buildSpec);){
            Cursor cursor = cursorHolder.asCursor();
            int rowCount = 0;
            while (!cursor.isDone()) {
                ++rowCount;
                cursor.advance();
            }
            Assert.assertEquals((long)3L, (long)rowCount);
        }
        Sequence resultRows = this.timeseriesEngine.process(query, this.projectionsCursorFactory, this.projectionsTimeBoundaryInspector, null);
        List results = resultRows.toList();
        Assert.assertEquals((long)2L, (long)results.size());
        RowSignature querySignature = query.getResultRowSignature(RowSignature.Finalization.YES);
        Assert.assertArrayEquals((Object[])new Object[]{TIMESTAMP, 16L}, (Object[])CursorFactoryProjectionTest.getResultArray((Result<TimeseriesResultValue>)((Result)results.get(0)), querySignature));
        Assert.assertArrayEquals((Object[])new Object[]{TIMESTAMP.plusHours(1), 3L}, (Object[])CursorFactoryProjectionTest.getResultArray((Result<TimeseriesResultValue>)((Result)results.get(1)), querySignature));
    }

    @Test
    public void testTimeseriesQueryGranularityAllFitsProjectionGranularityWithSegmentGranularity() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test").intervals((List)ImmutableList.of((Object)Intervals.ETERNITY)).granularity(Granularities.ALL).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("c_sum", "c")}).context((Map)ImmutableMap.of((Object)"useProjection", (Object)"c_sum_daily")).build();
        CursorBuildSpec buildSpec = TimeseriesQueryEngine.makeCursorBuildSpec((TimeseriesQuery)query, null);
        try (CursorHolder cursorHolder = this.projectionsCursorFactory.makeCursorHolder(buildSpec);){
            Cursor cursor = cursorHolder.asCursor();
            int rowCount = 0;
            while (!cursor.isDone()) {
                ++rowCount;
                cursor.advance();
            }
            Assert.assertEquals((long)1L, (long)rowCount);
        }
        Sequence resultRows = this.timeseriesEngine.process(query, this.projectionsCursorFactory, this.projectionsTimeBoundaryInspector, null);
        List results = resultRows.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        RowSignature querySignature = query.getResultRowSignature(RowSignature.Finalization.YES);
        Assert.assertArrayEquals((Object[])new Object[]{TIMESTAMP, 19L}, (Object[])CursorFactoryProjectionTest.getResultArray((Result<TimeseriesResultValue>)((Result)results.get(0)), querySignature));
    }

    @Test
    public void testTimeseriesQueryGranularityAllFitsProjectionGranularityWithNoGrouping() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test").intervals((List)ImmutableList.of((Object)Intervals.ETERNITY)).granularity(Granularities.ALL).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("c_sum", "c")}).context((Map)ImmutableMap.of((Object)"useProjection", (Object)"c_sum")).build();
        CursorBuildSpec buildSpec = TimeseriesQueryEngine.makeCursorBuildSpec((TimeseriesQuery)query, null);
        try (CursorHolder cursorHolder = this.projectionsCursorFactory.makeCursorHolder(buildSpec);){
            Cursor cursor = cursorHolder.asCursor();
            int rowCount = 0;
            while (!cursor.isDone()) {
                ++rowCount;
                cursor.advance();
            }
            Assert.assertEquals((long)1L, (long)rowCount);
        }
        Sequence resultRows = this.timeseriesEngine.process(query, this.projectionsCursorFactory, this.projectionsTimeBoundaryInspector, null);
        List results = resultRows.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        RowSignature querySignature = query.getResultRowSignature(RowSignature.Finalization.YES);
        Assert.assertArrayEquals((Object[])new Object[]{TIMESTAMP, 19L}, (Object[])CursorFactoryProjectionTest.getResultArray((Result<TimeseriesResultValue>)((Result)results.get(0)), querySignature));
    }

    @Test
    public void testTimeseriesQueryGranularityFinerThanProjectionGranularity() {
        Assume.assumeTrue((boolean)this.segmentSortedByTime);
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test").intervals((List)ImmutableList.of((Object)Intervals.ETERNITY)).granularity(Granularities.MINUTE).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("c_sum", "c")}).context((Map)ImmutableMap.of((Object)"skipEmptyBuckets", (Object)true)).build();
        CursorBuildSpec buildSpec = TimeseriesQueryEngine.makeCursorBuildSpec((TimeseriesQuery)query, null);
        try (CursorHolder cursorHolder = this.projectionsCursorFactory.makeCursorHolder(buildSpec);){
            Cursor cursor = cursorHolder.asCursor();
            int rowCount = 0;
            while (!cursor.isDone()) {
                ++rowCount;
                cursor.advance();
            }
            Assert.assertEquals((long)8L, (long)rowCount);
        }
        Sequence resultRows = this.timeseriesEngine.process(query, this.projectionsCursorFactory, this.projectionsTimeBoundaryInspector, null);
        List results = resultRows.toList();
        Assert.assertEquals((long)8L, (long)results.size());
        RowSignature querySignature = query.getResultRowSignature(RowSignature.Finalization.YES);
        Assert.assertArrayEquals((Object[])new Object[]{TIMESTAMP, 1L}, (Object[])CursorFactoryProjectionTest.getResultArray((Result<TimeseriesResultValue>)((Result)results.get(0)), querySignature));
        Assert.assertArrayEquals((Object[])new Object[]{TIMESTAMP.plusMinutes(2), 1L}, (Object[])CursorFactoryProjectionTest.getResultArray((Result<TimeseriesResultValue>)((Result)results.get(1)), querySignature));
        Assert.assertArrayEquals((Object[])new Object[]{TIMESTAMP.plusMinutes(4), 2L}, (Object[])CursorFactoryProjectionTest.getResultArray((Result<TimeseriesResultValue>)((Result)results.get(2)), querySignature));
        Assert.assertArrayEquals((Object[])new Object[]{TIMESTAMP.plusMinutes(6), 3L}, (Object[])CursorFactoryProjectionTest.getResultArray((Result<TimeseriesResultValue>)((Result)results.get(3)), querySignature));
        Assert.assertArrayEquals((Object[])new Object[]{TIMESTAMP.plusMinutes(8), 4L}, (Object[])CursorFactoryProjectionTest.getResultArray((Result<TimeseriesResultValue>)((Result)results.get(4)), querySignature));
        Assert.assertArrayEquals((Object[])new Object[]{TIMESTAMP.plusMinutes(10), 5L}, (Object[])CursorFactoryProjectionTest.getResultArray((Result<TimeseriesResultValue>)((Result)results.get(5)), querySignature));
        Assert.assertArrayEquals((Object[])new Object[]{TIMESTAMP.plusHours(1), 1L}, (Object[])CursorFactoryProjectionTest.getResultArray((Result<TimeseriesResultValue>)((Result)results.get(6)), querySignature));
        Assert.assertArrayEquals((Object[])new Object[]{TIMESTAMP.plusHours(1).plusMinutes(1), 2L}, (Object[])CursorFactoryProjectionTest.getResultArray((Result<TimeseriesResultValue>)((Result)results.get(7)), querySignature));
    }

    @Test
    public void testProjectionSingleDimRollupTable() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).addDimension("a").addAggregator((AggregatorFactory)new LongSumAggregatorFactory("c_sum", "sum_c")).build();
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, null);
        try (CursorHolder cursorHolder = this.rollupProjectionsCursorFactory.makeCursorHolder(buildSpec);){
            Cursor cursor = cursorHolder.asCursor();
            int rowCount = 0;
            while (!cursor.isDone()) {
                ++rowCount;
                cursor.advance();
            }
            Assert.assertEquals((long)3L, (long)rowCount);
        }
        Sequence resultRows = this.groupingEngine.process(query, this.rollupProjectionsCursorFactory, this.rollupProjectionsTimeBoundaryInspector, this.nonBlockingPool, null);
        List results = resultRows.toList();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertArrayEquals((Object[])new Object[]{"a", 7L}, (Object[])((ResultRow)results.get(0)).getArray());
        Assert.assertArrayEquals((Object[])new Object[]{"b", 12L}, (Object[])((ResultRow)results.get(1)).getArray());
    }

    @Test
    public void testProjectionSingleDimVirtualColumnRollupTable() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).addDimension("v0").setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "concat(a, 'foo')", ColumnType.STRING, TestExprMacroTable.INSTANCE)}).addAggregator((AggregatorFactory)new LongSumAggregatorFactory("c_sum", "sum_c")).build();
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, null);
        try (CursorHolder cursorHolder = this.rollupProjectionsCursorFactory.makeCursorHolder(buildSpec);){
            Cursor cursor = cursorHolder.asCursor();
            int rowCount = 0;
            while (!cursor.isDone()) {
                ++rowCount;
                cursor.advance();
            }
            Assert.assertEquals((long)2L, (long)rowCount);
        }
        Sequence resultRows = this.groupingEngine.process(query, this.rollupProjectionsCursorFactory, this.rollupProjectionsTimeBoundaryInspector, this.nonBlockingPool, null);
        List results = resultRows.toList();
        Assert.assertEquals((long)2L, (long)results.size());
        if (!(this.projectionsCursorFactory instanceof QueryableIndexCursorFactory) || !this.autoSchema) {
            Assert.assertArrayEquals((Object[])new Object[]{"afoo", 7L}, (Object[])((ResultRow)results.get(0)).getArray());
            Assert.assertArrayEquals((Object[])new Object[]{"bfoo", 12L}, (Object[])((ResultRow)results.get(1)).getArray());
        } else {
            Assert.assertArrayEquals((Object[])new Object[]{"bfoo", 12L}, (Object[])((ResultRow)results.get(0)).getArray());
            Assert.assertArrayEquals((Object[])new Object[]{"afoo", 7L}, (Object[])((ResultRow)results.get(1)).getArray());
        }
    }

    private static IndexBuilder makeBuilder(DimensionsSpec dimensionsSpec, boolean autoSchema, boolean writeNullColumns) {
        File tmp = FileUtils.createTempDir();
        CLOSER.register(tmp::delete);
        return IndexBuilder.create().tmpDir(tmp).schema(IncrementalIndexSchema.builder().withDimensionsSpec(dimensionsSpec).withRollup(false).withMinTimestamp(TIMESTAMP.getMillis()).withProjections(autoSchema ? AUTO_PROJECTIONS : PROJECTIONS).build()).writeNullColumns(writeNullColumns).rows(ROWS);
    }

    private static IndexBuilder makeRollupBuilder(DimensionsSpec dimensionsSpec, AggregatorFactory[] aggs, boolean autoSchema) {
        File tmp = FileUtils.createTempDir();
        CLOSER.register(tmp::delete);
        return IndexBuilder.create().tmpDir(tmp).schema(IncrementalIndexSchema.builder().withDimensionsSpec(dimensionsSpec).withMetrics(aggs).withRollup(true).withMinTimestamp(TIMESTAMP.getMillis()).withProjections(autoSchema ? AUTO_ROLLUP_PROJECTIONS : ROLLUP_PROJECTIONS).build()).writeNullColumns(true).rows(ROLLUP_ROWS);
    }

    private static Set<Object[]> makeArrayResultSet() {
        ObjectOpenCustomHashSet resultsInNoParticularOrder = new ObjectOpenCustomHashSet((Hash.Strategy)new Hash.Strategy<Object[]>(){

            public int hashCode(Object[] o) {
                return Arrays.hashCode(o);
            }

            public boolean equals(Object[] a, Object[] b) {
                return Arrays.deepEquals(a, b);
            }
        });
        return resultsInNoParticularOrder;
    }

    private static Set<Object[]> makeArrayResultSet(Object[] ... values) {
        Set<Object[]> resultsInNoParticularOrder = CursorFactoryProjectionTest.makeArrayResultSet();
        resultsInNoParticularOrder.addAll(Arrays.asList(values));
        return resultsInNoParticularOrder;
    }

    private static Object[] getResultArray(Result<TimeseriesResultValue> result, RowSignature rowSignature) {
        Object[] rowArray = new Object[rowSignature.size()];
        for (int i = 0; i < rowSignature.size(); ++i) {
            rowArray[i] = i == 0 ? result.getTimestamp() : ((TimeseriesResultValue)result.getValue()).getMetric(rowSignature.getColumnName(i));
        }
        return rowArray;
    }
}

