/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.druid.collections.spatial.search.Bound;
import org.apache.druid.collections.spatial.search.RadiusBound;
import org.apache.druid.collections.spatial.search.RectangularBound;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.SpatialDimensionSchema;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.Druids;
import org.apache.druid.query.FinalizeResultsQueryRunner;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.Result;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SpatialDimFilter;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryEngine;
import org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.druid.query.timeseries.TimeseriesQueryRunnerFactory;
import org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.druid.segment.IncrementalIndexSegment;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMergerV9;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.joda.time.Interval;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IndexMergerV9WithSpatialIndexTest
extends InitializedNullHandlingTest {
    public static final int NUM_POINTS = 5000;
    private static Interval DATA_INTERVAL = Intervals.of((String)"2013-01-01/2013-01-07");
    private static AggregatorFactory[] METRIC_AGGS = new AggregatorFactory[]{new CountAggregatorFactory("rows"), new LongSumAggregatorFactory("val", "val")};
    private static List<String> DIMS = Lists.newArrayList((Object[])new String[]{"dim", "lat", "long", "lat2", "long2"});
    private final Segment segment;

    @Parameterized.Parameters
    public static Collection<?> constructorFeeder() throws IOException {
        ArrayList<Object[]> argumentArrays = new ArrayList<Object[]>();
        for (SegmentWriteOutMediumFactory segmentWriteOutMediumFactory : SegmentWriteOutMediumFactory.builtInFactories()) {
            IndexMergerV9 indexMergerV9 = TestHelper.getTestIndexMergerV9(segmentWriteOutMediumFactory);
            IndexIO indexIO = TestHelper.getTestIndexIO();
            IndexSpec indexSpec = IndexSpec.DEFAULT;
            IncrementalIndex rtIndex = IndexMergerV9WithSpatialIndexTest.makeIncrementalIndex();
            QueryableIndex mMappedTestIndex = IndexMergerV9WithSpatialIndexTest.makeQueryableIndex(indexSpec, indexMergerV9, indexIO);
            QueryableIndex mergedRealtimeIndex = IndexMergerV9WithSpatialIndexTest.makeMergedQueryableIndex(indexSpec, indexMergerV9, indexIO);
            argumentArrays.add(new Object[]{new IncrementalIndexSegment(rtIndex, null)});
            argumentArrays.add(new Object[]{new QueryableIndexSegment(mMappedTestIndex, null)});
            argumentArrays.add(new Object[]{new QueryableIndexSegment(mergedRealtimeIndex, null)});
        }
        return argumentArrays;
    }

    private static IncrementalIndex makeIncrementalIndex() {
        IncrementalIndex theIndex = new OnheapIncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withMinTimestamp(DATA_INTERVAL.getStartMillis()).withQueryGranularity(Granularities.DAY).withMetrics(METRIC_AGGS).withDimensionsSpec(DimensionsSpec.builder().setSpatialDimensions(Arrays.asList(new SpatialDimensionSchema("dim.geo", Arrays.asList("lat", "long")), new SpatialDimensionSchema("spatialIsRad", Arrays.asList("lat2", "long2")))).build()).build()).setMaxRowCount(5000).build();
        theIndex.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-01").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-01").toString(), (Object)"dim", (Object)"foo", (Object)"lat", (Object)Float.valueOf(0.0f), (Object)"long", (Object)Float.valueOf(0.0f), (Object)"val", (Object)17L)));
        theIndex.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-02").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-02").toString(), (Object)"dim", (Object)"foo", (Object)"lat", (Object)Float.valueOf(1.0f), (Object)"long", (Object)Float.valueOf(3.0f), (Object)"val", (Object)29L)));
        theIndex.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-03").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-03").toString(), (Object)"dim", (Object)"foo", (Object)"lat", (Object)Float.valueOf(4.0f), (Object)"long", (Object)Float.valueOf(2.0f), (Object)"val", (Object)13L)));
        theIndex.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-04").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-04").toString(), (Object)"dim", (Object)"foo", (Object)"lat", (Object)Float.valueOf(7.0f), (Object)"long", (Object)Float.valueOf(3.0f), (Object)"val", (Object)91L)));
        theIndex.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-05").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-05").toString(), (Object)"dim", (Object)"foo", (Object)"lat", (Object)Float.valueOf(8.0f), (Object)"long", (Object)Float.valueOf(6.0f), (Object)"val", (Object)47L)));
        theIndex.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-05").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-05").toString(), (Object)"dim", (Object)"foo", (Object)"lat", (Object)"_mmx.unknown", (Object)"long", (Object)"_mmx.unknown", (Object)"val", (Object)101L)));
        theIndex.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-05").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-05").toString(), (Object)"dim", (Object)"foo", (Object)"dim.geo", (Object)"_mmx.unknown", (Object)"val", (Object)501L)));
        theIndex.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-05").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-05").toString(), (Object)"lat2", (Object)Float.valueOf(0.0f), (Object)"long2", (Object)Float.valueOf(0.0f), (Object)"val", (Object)13L)));
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        for (int i = 8; i < 5000; ++i) {
            theIndex.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-01").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-01").toString(), (Object)"dim", (Object)"boo", (Object)"lat", (Object)Float.valueOf((float)((double)(((Random)rand).nextFloat() * 10.0f) + 10.0)), (Object)"long", (Object)Float.valueOf((float)((double)(((Random)rand).nextFloat() * 10.0f) + 10.0)), (Object)"val", (Object)i)));
        }
        return theIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static QueryableIndex makeQueryableIndex(IndexSpec indexSpec, IndexMergerV9 indexMergerV9, IndexIO indexIO) throws IOException {
        IncrementalIndex theIndex = IndexMergerV9WithSpatialIndexTest.makeIncrementalIndex();
        File tmpFile = File.createTempFile("billy", "yay");
        tmpFile.delete();
        FileUtils.mkdirp((File)tmpFile);
        try {
            indexMergerV9.persist(theIndex, tmpFile, indexSpec, null);
            QueryableIndex queryableIndex = indexIO.loadIndex(tmpFile);
            return queryableIndex;
        }
        finally {
            FileUtils.deleteDirectory((File)tmpFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static QueryableIndex makeMergedQueryableIndex(IndexSpec indexSpec, IndexMergerV9 indexMergerV9, IndexIO indexIO) {
        QueryableIndex queryableIndex;
        IncrementalIndex first = new OnheapIncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withMinTimestamp(DATA_INTERVAL.getStartMillis()).withQueryGranularity(Granularities.DAY).withMetrics(METRIC_AGGS).withDimensionsSpec(DimensionsSpec.builder().setSpatialDimensions(Arrays.asList(new SpatialDimensionSchema("dim.geo", Arrays.asList("lat", "long")), new SpatialDimensionSchema("spatialIsRad", Arrays.asList("lat2", "long2")))).build()).build()).setMaxRowCount(1000).build();
        IncrementalIndex second = new OnheapIncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withMinTimestamp(DATA_INTERVAL.getStartMillis()).withQueryGranularity(Granularities.DAY).withMetrics(METRIC_AGGS).withDimensionsSpec(DimensionsSpec.builder().setSpatialDimensions(Arrays.asList(new SpatialDimensionSchema("dim.geo", Arrays.asList("lat", "long")), new SpatialDimensionSchema("spatialIsRad", Arrays.asList("lat2", "long2")))).build()).build()).setMaxRowCount(1000).build();
        IncrementalIndex third = new OnheapIncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withMinTimestamp(DATA_INTERVAL.getStartMillis()).withQueryGranularity(Granularities.DAY).withMetrics(METRIC_AGGS).withDimensionsSpec(DimensionsSpec.builder().setSpatialDimensions(Arrays.asList(new SpatialDimensionSchema("dim.geo", Arrays.asList("lat", "long")), new SpatialDimensionSchema("spatialIsRad", Arrays.asList("lat2", "long2")))).build()).build()).setMaxRowCount(5000).build();
        first.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-01").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-01").toString(), (Object)"dim", (Object)"foo", (Object)"lat", (Object)Float.valueOf(0.0f), (Object)"long", (Object)Float.valueOf(0.0f), (Object)"val", (Object)17L)));
        first.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-02").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-02").toString(), (Object)"dim", (Object)"foo", (Object)"lat", (Object)Float.valueOf(1.0f), (Object)"long", (Object)Float.valueOf(3.0f), (Object)"val", (Object)29L)));
        first.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-03").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-03").toString(), (Object)"dim", (Object)"foo", (Object)"lat", (Object)Float.valueOf(4.0f), (Object)"long", (Object)Float.valueOf(2.0f), (Object)"val", (Object)13L)));
        first.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-05").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-05").toString(), (Object)"dim", (Object)"foo", (Object)"lat", (Object)"_mmx.unknown", (Object)"long", (Object)"_mmx.unknown", (Object)"val", (Object)101L)));
        first.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-05").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-05").toString(), (Object)"dim", (Object)"foo", (Object)"dim.geo", (Object)"_mmx.unknown", (Object)"val", (Object)501L)));
        second.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-04").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-04").toString(), (Object)"dim", (Object)"foo", (Object)"lat", (Object)Float.valueOf(7.0f), (Object)"long", (Object)Float.valueOf(3.0f), (Object)"val", (Object)91L)));
        second.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-05").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-05").toString(), (Object)"dim", (Object)"foo", (Object)"lat", (Object)Float.valueOf(8.0f), (Object)"long", (Object)Float.valueOf(6.0f), (Object)"val", (Object)47L)));
        second.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-05").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-05").toString(), (Object)"lat2", (Object)Float.valueOf(0.0f), (Object)"long2", (Object)Float.valueOf(0.0f), (Object)"val", (Object)13L)));
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        for (int i = 8; i < 5000; ++i) {
            third.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-01").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-01").toString(), (Object)"dim", (Object)"boo", (Object)"lat", (Object)Float.valueOf((float)((double)(((Random)rand).nextFloat() * 10.0f) + 10.0)), (Object)"long", (Object)Float.valueOf((float)((double)(((Random)rand).nextFloat() * 10.0f) + 10.0)), (Object)"val", (Object)i)));
        }
        File tmpFile = File.createTempFile("yay", "who");
        tmpFile.delete();
        File firstFile = new File(tmpFile, "first");
        File secondFile = new File(tmpFile, "second");
        File thirdFile = new File(tmpFile, "third");
        File mergedFile = new File(tmpFile, "merged");
        FileUtils.mkdirp((File)firstFile);
        FileUtils.mkdirp((File)secondFile);
        FileUtils.mkdirp((File)thirdFile);
        FileUtils.mkdirp((File)mergedFile);
        indexMergerV9.persist(first, DATA_INTERVAL, firstFile, indexSpec, null);
        indexMergerV9.persist(second, DATA_INTERVAL, secondFile, indexSpec, null);
        indexMergerV9.persist(third, DATA_INTERVAL, thirdFile, indexSpec, null);
        try {
            QueryableIndex mergedRealtime;
            queryableIndex = mergedRealtime = indexIO.loadIndex(indexMergerV9.mergeQueryableIndex(Arrays.asList(indexIO.loadIndex(firstFile), indexIO.loadIndex(secondFile), indexIO.loadIndex(thirdFile)), true, METRIC_AGGS, mergedFile, indexSpec, null, -1));
        }
        catch (Throwable throwable) {
            try {
                FileUtils.deleteDirectory((File)firstFile);
                FileUtils.deleteDirectory((File)secondFile);
                FileUtils.deleteDirectory((File)thirdFile);
                FileUtils.deleteDirectory((File)mergedFile);
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        FileUtils.deleteDirectory((File)firstFile);
        FileUtils.deleteDirectory((File)secondFile);
        FileUtils.deleteDirectory((File)thirdFile);
        FileUtils.deleteDirectory((File)mergedFile);
        return queryableIndex;
    }

    public IndexMergerV9WithSpatialIndexTest(Segment segment) {
        this.segment = segment;
    }

    @Test
    public void testSpatialQuery() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test").granularity(Granularities.ALL).intervals(Collections.singletonList(Intervals.of((String)"2013-01-01/2013-01-07"))).filters((DimFilter)new SpatialDimFilter("dim.geo", (Bound)new RadiusBound(new float[]{0.0f, 0.0f}, 5.0f))).aggregators(Arrays.asList(new CountAggregatorFactory("rows"), new LongSumAggregatorFactory("val", "val"))).build();
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2013-01-01T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)3L).put((Object)"val", (Object)59L).build())));
        try {
            TimeseriesQueryRunnerFactory factory = new TimeseriesQueryRunnerFactory(new TimeseriesQueryQueryToolChest(), new TimeseriesQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
            FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(factory.createRunner(this.segment), factory.getToolchest());
            TestHelper.assertExpectedResults(expectedResults, runner.run(QueryPlus.wrap((Query)query)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testSpatialQueryWithOtherSpatialDim() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test").granularity(Granularities.ALL).intervals(Collections.singletonList(Intervals.of((String)"2013-01-01/2013-01-07"))).filters((DimFilter)new SpatialDimFilter("spatialIsRad", (Bound)new RadiusBound(new float[]{0.0f, 0.0f}, 5.0f))).aggregators(Arrays.asList(new CountAggregatorFactory("rows"), new LongSumAggregatorFactory("val", "val"))).build();
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2013-01-01T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"val", (Object)13L).build())));
        try {
            TimeseriesQueryRunnerFactory factory = new TimeseriesQueryRunnerFactory(new TimeseriesQueryQueryToolChest(), new TimeseriesQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
            FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(factory.createRunner(this.segment), factory.getToolchest());
            TestHelper.assertExpectedResults(expectedResults, runner.run(QueryPlus.wrap((Query)query)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testSpatialQueryMorePoints() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test").granularity(Granularities.DAY).intervals(Collections.singletonList(Intervals.of((String)"2013-01-01/2013-01-07"))).filters((DimFilter)new SpatialDimFilter("dim.geo", (Bound)new RectangularBound(new float[]{0.0f, 0.0f}, new float[]{9.0f, 9.0f}))).aggregators(Arrays.asList(new CountAggregatorFactory("rows"), new LongSumAggregatorFactory("val", "val"))).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2013-01-01T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"val", (Object)17L).build())), new Result(DateTimes.of((String)"2013-01-02T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"val", (Object)29L).build())), new Result(DateTimes.of((String)"2013-01-03T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"val", (Object)13L).build())), new Result(DateTimes.of((String)"2013-01-04T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"val", (Object)91L).build())), new Result(DateTimes.of((String)"2013-01-05T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"val", (Object)47L).build())));
        try {
            TimeseriesQueryRunnerFactory factory = new TimeseriesQueryRunnerFactory(new TimeseriesQueryQueryToolChest(), new TimeseriesQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
            FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(factory.createRunner(this.segment), factory.getToolchest());
            TestHelper.assertExpectedResults(expectedResults, runner.run(QueryPlus.wrap((Query)query)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

