/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.io.Closeable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.ReferenceCountedSegmentProvider;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.join.table.IndexedTable;
import org.apache.druid.timeline.SegmentId;
import org.easymock.EasyMock;
import org.joda.time.Days;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReferenceCountingSegmentTest {
    private ReferenceCountedSegmentProvider segment;
    private ExecutorService exec;
    private final SegmentId segmentId = SegmentId.dummy((String)"test_segment");
    private final Interval dataInterval = new Interval((ReadableInstant)DateTimes.nowUtc().minus((ReadablePeriod)Days.days((int)1)), (ReadableInstant)DateTimes.nowUtc());
    private QueryableIndex index;
    private CursorFactory cursorFactory;
    private IndexedTable indexedTable;
    private int underlyingSegmentClosedCount;

    @Before
    public void setUp() {
        this.underlyingSegmentClosedCount = 0;
        this.index = (QueryableIndex)EasyMock.createNiceMock(QueryableIndex.class);
        this.cursorFactory = (CursorFactory)EasyMock.createNiceMock(CursorFactory.class);
        this.indexedTable = (IndexedTable)EasyMock.createNiceMock(IndexedTable.class);
        this.segment = ReferenceCountedSegmentProvider.wrapRootGenerationSegment((Segment)new Segment(){

            public SegmentId getId() {
                return ReferenceCountingSegmentTest.this.segmentId;
            }

            public Interval getDataInterval() {
                return ReferenceCountingSegmentTest.this.dataInterval;
            }

            public <T> T as(Class<T> clazz) {
                if (clazz.equals(QueryableIndex.class)) {
                    return (T)ReferenceCountingSegmentTest.this.index;
                }
                if (clazz.equals(CursorFactory.class)) {
                    return (T)ReferenceCountingSegmentTest.this.cursorFactory;
                }
                if (clazz.equals(IndexedTable.class)) {
                    return (T)ReferenceCountingSegmentTest.this.indexedTable;
                }
                return null;
            }

            public void close() {
                ++ReferenceCountingSegmentTest.this.underlyingSegmentClosedCount;
            }
        });
        this.exec = Executors.newSingleThreadExecutor();
    }

    @Test
    public void testMultipleClose() throws Exception {
        Assert.assertEquals((long)0L, (long)this.underlyingSegmentClosedCount);
        Assert.assertFalse((boolean)this.segment.isClosed());
        Assert.assertTrue((boolean)this.segment.increment());
        Assert.assertEquals((long)1L, (long)this.segment.getNumReferences());
        Closeable closeable = this.segment.decrementOnceCloseable();
        Assert.assertEquals((long)0L, (long)this.underlyingSegmentClosedCount);
        closeable.close();
        Assert.assertEquals((long)0L, (long)this.underlyingSegmentClosedCount);
        closeable.close();
        Assert.assertEquals((long)0L, (long)this.underlyingSegmentClosedCount);
        this.exec.submit(() -> {
            try {
                closeable.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).get();
        Assert.assertEquals((long)0L, (long)this.segment.getNumReferences());
        Assert.assertEquals((long)0L, (long)this.underlyingSegmentClosedCount);
        Assert.assertFalse((boolean)this.segment.isClosed());
        this.segment.close();
        Assert.assertTrue((boolean)this.segment.isClosed());
        Assert.assertEquals((long)1L, (long)this.underlyingSegmentClosedCount);
        this.segment.close();
        Assert.assertEquals((long)1L, (long)this.underlyingSegmentClosedCount);
        this.exec.submit(() -> {
            try {
                this.segment.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).get();
        Assert.assertEquals((long)0L, (long)this.segment.getNumReferences());
        Assert.assertTrue((boolean)this.segment.isClosed());
        Assert.assertEquals((long)1L, (long)this.underlyingSegmentClosedCount);
        this.segment.increment();
        this.segment.increment();
        this.segment.increment();
        Assert.assertEquals((long)0L, (long)this.segment.getNumReferences());
        Assert.assertEquals((long)1L, (long)this.underlyingSegmentClosedCount);
        this.segment.close();
        Assert.assertEquals((long)0L, (long)this.segment.getNumReferences());
        Assert.assertEquals((long)1L, (long)this.underlyingSegmentClosedCount);
    }
}

