/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.segment.DataSegmentsWithSchemas;
import org.apache.druid.segment.SchemaPayload;
import org.apache.druid.segment.SchemaPayloadPlus;
import org.apache.druid.segment.SegmentSchemaMapping;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.junit.Assert;
import org.junit.Test;

public class DataSegmentsWithSchemasTest {
    private ObjectMapper mapper = TestHelper.makeJsonMapper();

    @Test
    public void testSerde() throws IOException {
        DataSegment segment = new DataSegment("foo", Intervals.of((String)"2023-01-01/2023-01-02"), "2023-01-01", (Map)ImmutableMap.of((Object)"path", (Object)"a-1"), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
        SegmentSchemaMapping segmentSchemaMapping = new SegmentSchemaMapping(0);
        segmentSchemaMapping.addSchema(segment.getId(), new SchemaPayloadPlus(new SchemaPayload(RowSignature.builder().add("c", ColumnType.FLOAT).build()), Long.valueOf(20L)), "fp");
        DataSegmentsWithSchemas dataSegmentsWithSchemas = new DataSegmentsWithSchemas(Collections.singleton(segment), segmentSchemaMapping);
        byte[] bytes = this.mapper.writeValueAsBytes((Object)dataSegmentsWithSchemas);
        DataSegmentsWithSchemas deserialized = (DataSegmentsWithSchemas)this.mapper.readValue(bytes, DataSegmentsWithSchemas.class);
        Assert.assertEquals((Object)deserialized, (Object)dataSegmentsWithSchemas);
    }

    @Test
    public void testEquals() {
        DataSegment segment = new DataSegment("foo", Intervals.of((String)"2023-01-01/2023-01-02"), "2023-01-01", (Map)ImmutableMap.of((Object)"path", (Object)"a-1"), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
        SegmentSchemaMapping segmentSchemaMapping = new SegmentSchemaMapping(0);
        segmentSchemaMapping.addSchema(segment.getId(), new SchemaPayloadPlus(new SchemaPayload(RowSignature.builder().add("c", ColumnType.FLOAT).build()), Long.valueOf(20L)), "fp");
        DataSegmentsWithSchemas dataSegmentsWithSchemas = new DataSegmentsWithSchemas(Collections.singleton(segment), segmentSchemaMapping);
        DataSegmentsWithSchemas emptySegmentWithSchemas = new DataSegmentsWithSchemas(0);
        Assert.assertNotEquals((Object)dataSegmentsWithSchemas, (Object)emptySegmentWithSchemas);
    }
}

