/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.incremental;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.guice.BuiltInTypesModule;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorAndSize;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.LongMaxAggregator;
import org.apache.druid.query.aggregation.LongMaxAggregatorFactory;
import org.apache.druid.segment.CloserRule;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexCreator;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.easymock.EasyMock;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IncrementalIndexIngestionTest
extends InitializedNullHandlingTest {
    private static final int MAX_ROWS = 100000;
    public final IncrementalIndexCreator indexCreator;
    @Rule
    public final CloserRule closer = new CloserRule(false);

    public IncrementalIndexIngestionTest(String indexType) throws JsonProcessingException {
        BuiltInTypesModule.registerHandlersAndSerde();
        this.indexCreator = this.closer.closeLater(new IncrementalIndexCreator(indexType, (builder, args) -> builder.setIndexSchema((IncrementalIndexSchema)args[0]).setMaxRowCount(100000).build()));
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<?> constructorFeeder() {
        return IncrementalIndexCreator.getAppendableIndexTypes();
    }

    @Test
    public void testOnHeapIncrementalIndexClose() throws Exception {
        final Aggregator mockedAggregator = (Aggregator)EasyMock.createMock(LongMaxAggregator.class);
        EasyMock.expect((Object)mockedAggregator.aggregateWithSize()).andReturn((Object)0L).anyTimes();
        mockedAggregator.close();
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{mockedAggregator});
        IncrementalIndex incrementalIndex = this.indexCreator.createIndex(new IncrementalIndexSchema.Builder().withQueryGranularity(Granularities.MINUTE).withMetrics(new AggregatorFactory[]{new LongMaxAggregatorFactory("max", "max"){

            protected Aggregator factorize(ColumnSelectorFactory metricFactory, ColumnValueSelector selector) {
                return mockedAggregator;
            }

            public AggregatorAndSize factorizeWithSize(ColumnSelectorFactory metricFactory) {
                return new AggregatorAndSize(mockedAggregator, 8L);
            }
        }}).build());
        if (!(incrementalIndex instanceof OnheapIncrementalIndex)) {
            return;
        }
        OnheapIncrementalIndex index = (OnheapIncrementalIndex)incrementalIndex;
        index.add((InputRow)new MapBasedInputRow(0L, Collections.singletonList("billy"), (Map)ImmutableMap.of((Object)"billy", (Object)1, (Object)"max", (Object)1)));
        index.close();
        EasyMock.verify((Object[])new Object[]{mockedAggregator});
    }
}

