/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.join.PossiblyNullDimensionSelector;
import org.junit.Assert;
import org.junit.Test;

public class PossiblyNullDimensionSelectorTest {
    private boolean isNull = false;
    private final DimensionSelector onNullSelector = this.makeSelector(DimensionSelector.constant(null));
    private final DimensionSelector onNonnullSelector = this.makeSelector(DimensionSelector.constant((String)"foo"));

    @Test
    public void test_getRow_normalOnNullSelector() {
        this.isNull = false;
        PossiblyNullDimensionSelectorTest.assertRowsEqual(new int[]{0}, this.onNullSelector.getRow());
    }

    @Test
    public void test_getRow_nullOnNullSelector() {
        this.isNull = true;
        PossiblyNullDimensionSelectorTest.assertRowsEqual(new int[]{0}, this.onNullSelector.getRow());
    }

    @Test
    public void test_getRow_normalOnNonnullSelector() {
        this.isNull = false;
        PossiblyNullDimensionSelectorTest.assertRowsEqual(new int[]{1}, this.onNonnullSelector.getRow());
    }

    @Test
    public void test_getRow_nullOnNonnullSelector() {
        this.isNull = true;
        PossiblyNullDimensionSelectorTest.assertRowsEqual(new int[]{0}, this.onNonnullSelector.getRow());
    }

    @Test
    public void test_getValueCardinality_onNullSelector() {
        Assert.assertEquals((long)1L, (long)this.onNullSelector.getValueCardinality());
    }

    @Test
    public void test_getValueCardinality_onNonnullSelector() {
        Assert.assertEquals((long)2L, (long)this.onNonnullSelector.getValueCardinality());
    }

    @Test
    public void test_lookupName_onNullSelector() {
        Assert.assertNull((Object)this.onNullSelector.lookupName(0));
    }

    @Test
    public void test_lookupName_onNonnullSelector() {
        Assert.assertNull((Object)this.onNonnullSelector.lookupName(0));
        Assert.assertEquals((Object)"foo", (Object)this.onNonnullSelector.lookupName(1));
    }

    @Test
    public void test_lookupId_onNullSelector() {
        Assert.assertEquals((long)0L, (long)this.onNullSelector.idLookup().lookupId(null));
    }

    @Test
    public void test_lookupId_onNonnullSelector() {
        Assert.assertEquals((long)0L, (long)this.onNonnullSelector.idLookup().lookupId(null));
        Assert.assertEquals((long)1L, (long)this.onNonnullSelector.idLookup().lookupId("foo"));
    }

    @Test
    public void test_nameLookupPossibleInAdvance_onNullSelector() {
        Assert.assertTrue((boolean)this.onNonnullSelector.nameLookupPossibleInAdvance());
    }

    @Test
    public void test_nameLookupPossibleInAdvance_onNonnullSelector() {
        Assert.assertTrue((boolean)this.onNonnullSelector.nameLookupPossibleInAdvance());
    }

    private DimensionSelector makeSelector(DimensionSelector baseSelector) {
        return new PossiblyNullDimensionSelector(baseSelector, () -> this.isNull);
    }

    private static void assertRowsEqual(int[] expected, IndexedInts actual) {
        Assert.assertEquals((Object)IntArrayList.wrap((int[])expected), (Object)PossiblyNullDimensionSelectorTest.toList(actual));
    }

    private static IntList toList(IndexedInts ints) {
        IntArrayList retVal = new IntArrayList(ints.size());
        int size = ints.size();
        for (int i = 0; i < size; ++i) {
            retVal.add(ints.get(i));
        }
        return retVal;
    }
}

