/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.writeout;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.segment.writeout.HeapByteBufferWriteOutBytes;
import org.apache.druid.segment.writeout.LazilyAllocatingHeapWriteOutBytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LazilyAllocatingHeapWriteOutBytesTest {
    private LazilyAllocatingHeapWriteOutBytes target;
    private Closer closer;
    private HeapByteBufferWriteOutBytes heapByteBufferWriteOutBytes;

    @Before
    public void setUp() {
        this.closer = Closer.create();
        this.heapByteBufferWriteOutBytes = new HeapByteBufferWriteOutBytes();
        this.target = new LazilyAllocatingHeapWriteOutBytes(() -> this.heapByteBufferWriteOutBytes, this.closer);
    }

    @Test
    public void testWritingToBuffer() throws IOException {
        Assert.assertNull((Object)this.target.getTmpBuffer());
        this.target.write(ByteBuffer.allocate(512));
        Assert.assertNotNull((Object)this.target.getTmpBuffer());
        Assert.assertEquals((long)4096L, (long)this.target.getTmpBuffer().limit());
        Assert.assertNull((Object)this.target.getDelegate());
        this.target.write(ByteBuffer.allocate(16385));
        Assert.assertNull((Object)this.target.getTmpBuffer());
        Assert.assertNotNull((Object)this.target.getDelegate());
        Assert.assertEquals((long)16897L, (long)this.target.getDelegate().size());
    }

    @Test
    public void testClosingWriteOutBytes() throws IOException {
        Assert.assertNull((Object)this.target.getTmpBuffer());
        this.target.writeInt(5);
        Assert.assertNotNull((Object)this.target.getTmpBuffer());
        Assert.assertEquals((long)128L, (long)this.target.getTmpBuffer().limit());
        Assert.assertNull((Object)this.target.getDelegate());
        this.closer.close();
        Assert.assertNull((Object)this.target.getTmpBuffer());
    }
}

