/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.utils;

import org.apache.druid.java.util.common.ISE;
import org.apache.druid.utils.Throwables;
import org.junit.Assert;
import org.junit.Test;

public class ThrowablesTest {
    @Test
    public void testGetCauseOfType_Itself() {
        NoClassDefFoundError th = new NoClassDefFoundError();
        Assert.assertSame((Object)th, (Object)Throwables.getCauseOfType((Throwable)th, NoClassDefFoundError.class));
    }

    @Test
    public void testGetCauseOfType_NestedThrowable() {
        NoClassDefFoundError th = new NoClassDefFoundError();
        Assert.assertSame((Object)th, (Object)Throwables.getCauseOfType((Throwable)new RuntimeException(th), NoClassDefFoundError.class));
    }

    @Test
    public void testGetCauseOfType_NestedThrowableSubclass() {
        ISE th = new ISE("something", new Object[0]);
        Assert.assertSame((Object)((Object)th), (Object)Throwables.getCauseOfType((Throwable)new RuntimeException(th), IllegalStateException.class));
    }

    @Test
    public void testGetCauseOfType_NonTarget() {
        Assert.assertNull((Object)Throwables.getCauseOfType((Throwable)new RuntimeException(new ClassNotFoundException()), NoClassDefFoundError.class));
    }
}

