/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.firstlast;

import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.SerializablePairLongDouble;
import org.apache.druid.query.aggregation.SerializablePairLongFloat;
import org.apache.druid.query.aggregation.SerializablePairLongLong;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ValueType;

public class FirstLastUtils {
    public static boolean selectorNeedsFoldCheck(BaseObjectColumnValueSelector<?> valueSelector, @Nullable ColumnCapabilities valueSelectorCapabilities, Class pairClass) {
        if (valueSelectorCapabilities != null && !valueSelectorCapabilities.is(ValueType.COMPLEX)) {
            return false;
        }
        if (valueSelector instanceof NilColumnValueSelector) {
            return false;
        }
        Class<?> clazz = valueSelector.classOfObject();
        return clazz.isAssignableFrom(pairClass) || pairClass.isAssignableFrom(clazz);
    }

    @Nullable
    public static SerializablePairLongDouble readDoublePairFromVectorSelectors(@Nullable boolean[] timeNullityVector, long[] timeVector, Object[] objectVector, int index) {
        Object object = objectVector[index];
        if (object instanceof SerializablePairLongDouble) {
            SerializablePairLongDouble pair = (SerializablePairLongDouble)object;
            if (pair.lhs == null) {
                return null;
            }
            return pair;
        }
        if (timeNullityVector != null && timeNullityVector[index]) {
            return null;
        }
        long time = timeVector[index];
        Double value = DimensionHandlerUtils.convertObjectToDouble(object);
        return new SerializablePairLongDouble(time, value);
    }

    @Nullable
    public static SerializablePairLongFloat readFloatPairFromVectorSelectors(@Nullable boolean[] timeNullityVector, long[] timeVector, Object[] objectVector, int index) {
        Object object = objectVector[index];
        if (object instanceof SerializablePairLongFloat) {
            SerializablePairLongFloat pair = (SerializablePairLongFloat)object;
            if (pair.lhs == null) {
                return null;
            }
            return pair;
        }
        if (timeNullityVector != null && timeNullityVector[index]) {
            return null;
        }
        long time = timeVector[index];
        Float value = DimensionHandlerUtils.convertObjectToFloat(object);
        return new SerializablePairLongFloat(time, value);
    }

    @Nullable
    public static SerializablePairLongLong readLongPairFromVectorSelectors(@Nullable boolean[] timeNullityVector, long[] timeVector, Object[] objectVector, int index) {
        Object object = objectVector[index];
        if (object instanceof SerializablePairLongLong) {
            SerializablePairLongLong pair = (SerializablePairLongLong)object;
            if (pair.lhs == null) {
                return null;
            }
            return pair;
        }
        if (timeNullityVector != null && timeNullityVector[index]) {
            return null;
        }
        long time = timeVector[index];
        Long value = DimensionHandlerUtils.convertObjectToLong(object);
        return new SerializablePairLongLong(time, value);
    }
}

