/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.lookup;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.query.lookup.LookupExtractorFactory;

public class LookupExtractorFactoryContainer {
    private final String version;
    private final LookupExtractorFactory lookupExtractorFactory;

    @JsonCreator
    public LookupExtractorFactoryContainer(@JsonProperty(value="version") String version, @JsonProperty(value="lookupExtractorFactory") LookupExtractorFactory lookupExtractorFactory) {
        this.version = version;
        this.lookupExtractorFactory = (LookupExtractorFactory)Preconditions.checkNotNull((Object)lookupExtractorFactory, (Object)"null factory");
    }

    @JsonProperty
    public String getVersion() {
        return this.version;
    }

    @JsonProperty
    public LookupExtractorFactory getLookupExtractorFactory() {
        return this.lookupExtractorFactory;
    }

    public boolean replaces(LookupExtractorFactoryContainer other) {
        if (this.version == null && other.getVersion() == null) {
            return this.lookupExtractorFactory.replaces(other.getLookupExtractorFactory());
        }
        return Comparators.naturalNullsFirst().compare((Object)this.version, (Object)other.getVersion()) > 0;
    }

    public String toString() {
        return "LookupExtractorFactoryContainer{version='" + this.version + "', lookupExtractorFactory=" + String.valueOf(this.lookupExtractorFactory) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LookupExtractorFactoryContainer that = (LookupExtractorFactoryContainer)o;
        return Objects.equals(this.version, that.version) && Objects.equals(this.lookupExtractorFactory, that.lookupExtractorFactory);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.lookupExtractorFactory);
    }
}

