/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.audit;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.druid.audit.AuditEntry;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.audit.RequestInfo;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.junit.Assert;
import org.junit.Test;

public class AuditInfoTest {
    private final ObjectMapper mapper = new DefaultObjectMapper();

    @Test
    public void testAuditInfoEquality() {
        AuditInfo auditInfo1 = new AuditInfo("druid", "id", "test equality", "127.0.0.1");
        AuditInfo auditInfo2 = new AuditInfo("druid", "id", "test equality", "127.0.0.1");
        Assert.assertEquals((Object)auditInfo1, (Object)auditInfo2);
        Assert.assertEquals((long)auditInfo1.hashCode(), (long)auditInfo2.hashCode());
    }

    @Test
    public void testAuditInfoSerde() throws IOException {
        AuditInfo auditInfo = new AuditInfo("author", null, "comment", "ip");
        AuditInfo deserialized = (AuditInfo)this.mapper.readValue(this.mapper.writeValueAsString((Object)auditInfo), AuditInfo.class);
        Assert.assertEquals((Object)auditInfo, (Object)deserialized);
        AuditInfo auditInfoWithIdentity = new AuditInfo("author", "identity", "comment", "ip");
        deserialized = (AuditInfo)this.mapper.readValue(this.mapper.writeValueAsString((Object)auditInfoWithIdentity), AuditInfo.class);
        Assert.assertEquals((Object)auditInfoWithIdentity, (Object)deserialized);
        Assert.assertNotEquals((Object)auditInfo, (Object)auditInfoWithIdentity);
    }

    @Test(timeout=60000L)
    public void testAuditEntrySerde() throws IOException {
        AuditEntry original = new AuditEntry("testKey", "testType", new AuditInfo("testAuthor", "testIdentity", "testComment", "127.0.0.1"), new RequestInfo("overlord", "GET", "/segments", "?abc=1"), AuditEntry.Payload.fromString((String)"testPayload"), DateTimes.of((String)"2013-01-01T00:00:00Z"));
        AuditEntry deserialized = (AuditEntry)this.mapper.readValue(this.mapper.writeValueAsString((Object)original), AuditEntry.class);
        Assert.assertEquals((Object)original, (Object)deserialized);
    }

    @Test
    public void testAuditEntrySerdeIsBackwardsCompatible() throws IOException {
        String json = "{\"key\": \"a\", \"type\": \"b\", \"auditInfo\": {}, \"payload\":\"Truncated\"}";
        AuditEntry entry = (AuditEntry)this.mapper.readValue("{\"key\": \"a\", \"type\": \"b\", \"auditInfo\": {}, \"payload\":\"Truncated\"}", AuditEntry.class);
        Assert.assertEquals((Object)"a", (Object)entry.getKey());
        Assert.assertEquals((Object)"b", (Object)entry.getType());
        Assert.assertEquals((Object)AuditEntry.Payload.fromString((String)"Truncated"), (Object)entry.getPayload());
    }

    @Test
    public void testRequestInfoEquality() throws IOException {
        RequestInfo requestInfo = new RequestInfo("overlord", "GET", "/uri", "a=b");
        RequestInfo deserialized = (RequestInfo)this.mapper.readValue(this.mapper.writeValueAsString((Object)requestInfo), RequestInfo.class);
        Assert.assertEquals((Object)requestInfo, (Object)deserialized);
    }
}

