/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections.bitmap;

import java.io.IOException;
import java.util.BitSet;
import org.apache.druid.collections.bitmap.BitmapOperationTestBase;
import org.apache.druid.collections.bitmap.WrappedImmutableConciseBitmap;
import org.apache.druid.collections.bitmap.WrappedImmutableRoaringBitmap;
import org.apache.druid.extendedset.intset.ConciseSet;
import org.apache.druid.extendedset.intset.ImmutableConciseSet;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class BitmapOperationAgainstUniformDistributionTest
extends BitmapOperationTestBase {
    public static final double DENSITY = 0.01;
    public static final int MIN_INTERSECT = 50;

    @BeforeClass
    public static void prepareMostlyUniform() throws Exception {
        int i;
        BitmapOperationAgainstUniformDistributionTest.reset();
        BitSet expectedUnion = new BitSet();
        int[] knownTrue = new int[50];
        for (i = 0; i < knownTrue.length; ++i) {
            knownTrue[i] = rand.nextInt(500000);
        }
        for (i = 0; i < 1000; ++i) {
            ConciseSet c = new ConciseSet();
            MutableRoaringBitmap r = new MutableRoaringBitmap();
            for (int k = 0; k < 500000; ++k) {
                if (!(rand.nextDouble() < 0.01)) continue;
                c.add(k);
                r.add(k);
                expectedUnion.set(k);
            }
            for (int k : knownTrue) {
                c.add(k);
                r.add(k);
                expectedUnion.set(k);
            }
            BitmapOperationAgainstUniformDistributionTest.CONCISE[i] = ImmutableConciseSet.newImmutableFromMutable((ConciseSet)c);
            BitmapOperationAgainstUniformDistributionTest.OFF_HEAP_CONCISE[i] = BitmapOperationAgainstUniformDistributionTest.makeOffheapConcise(CONCISE[i]);
            BitmapOperationAgainstUniformDistributionTest.ROARING[i] = r;
            BitmapOperationAgainstUniformDistributionTest.IMMUTABLE_ROARING[i] = BitmapOperationAgainstUniformDistributionTest.makeImmutableRoaring(r);
            BitmapOperationAgainstUniformDistributionTest.OFF_HEAP_ROARING[i] = BitmapOperationAgainstUniformDistributionTest.makeOffheapRoaring(r);
            BitmapOperationAgainstUniformDistributionTest.GENERIC_CONCISE[i] = new WrappedImmutableConciseBitmap((ImmutableConciseSet)OFF_HEAP_CONCISE[i].get());
            BitmapOperationAgainstUniformDistributionTest.GENERIC_ROARING[i] = new WrappedImmutableRoaringBitmap((ImmutableRoaringBitmap)OFF_HEAP_ROARING[i].get());
        }
        unionCount = expectedUnion.cardinality();
        minIntersection = knownTrue.length;
        BitmapOperationAgainstUniformDistributionTest.printSizeStats(0.01, "Uniform Bitmap");
    }

    @AfterClass
    public static void tearDownClass() throws IOException {
        BitmapOperationAgainstUniformDistributionTest.reset();
    }
}

