/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.data.input.ColumnsFilter;
import org.junit.Assert;
import org.junit.Test;

public class ColumnsFilterTest {
    private static final List<String> COLUMNS = ImmutableList.of((Object)"a", (Object)"b", (Object)"c");

    @Test
    public void testAll() {
        Assert.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), this.apply(ColumnsFilter.all(), COLUMNS));
    }

    @Test
    public void testInclusionBased() {
        Assert.assertEquals((Object)ImmutableList.of((Object)"b"), this.apply(ColumnsFilter.inclusionBased((Set)ImmutableSet.of((Object)"b")), COLUMNS));
    }

    @Test
    public void testInclusionBasedPlus() {
        Assert.assertEquals((Object)ColumnsFilter.inclusionBased((Set)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c")), (Object)ColumnsFilter.inclusionBased((Set)ImmutableSet.of((Object)"b", (Object)"c")).plus("a").plus("c"));
    }

    @Test
    public void testExclusionBased() {
        Assert.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"c"), this.apply(ColumnsFilter.exclusionBased((Set)ImmutableSet.of((Object)"b")), COLUMNS));
    }

    @Test
    public void testExclusionBasedPlus() {
        Assert.assertEquals((Object)ColumnsFilter.exclusionBased((Set)ImmutableSet.of((Object)"b")), (Object)ColumnsFilter.exclusionBased((Set)ImmutableSet.of((Object)"b", (Object)"c")).plus("a").plus("c"));
    }

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(ColumnsFilter.InclusionBased.class).usingGetClass().verify();
        EqualsVerifier.forClass(ColumnsFilter.ExclusionBased.class).usingGetClass().verify();
    }

    private List<String> apply(ColumnsFilter columnsFilter, List<String> columns) {
        return columns.stream().filter(arg_0 -> ((ColumnsFilter)columnsFilter).apply(arg_0)).collect(Collectors.toList());
    }
}

