/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.druid.data.input.ColumnsFilter;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputEntityReader;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.impl.ByteEntity;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.JsonInputFormat;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.java.util.common.parsers.JSONPathFieldSpec;
import org.apache.druid.java.util.common.parsers.JSONPathFieldType;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;
import org.junit.Assert;
import org.junit.Test;

public class JsonLineReaderTest {
    @Test
    public void testParseRow() throws IOException {
        JsonInputFormat format = new JsonInputFormat(new JSONPathSpec(Boolean.valueOf(true), (List)ImmutableList.of((Object)new JSONPathFieldSpec(JSONPathFieldType.ROOT, "root_baz", "baz"), (Object)new JSONPathFieldSpec(JSONPathFieldType.ROOT, "root_baz2", "baz2"), (Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "path_omg", "$.o.mg"), (Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "path_omg2", "$.o.mg2"), (Object)new JSONPathFieldSpec(JSONPathFieldType.JQ, "jq_omg", ".o.mg"), (Object)new JSONPathFieldSpec(JSONPathFieldType.JQ, "jq_omg2", ".o.mg2"), (Object)new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree_baz", null, Collections.singletonList("baz")), (Object)new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree_baz2", null, Collections.singletonList("baz2")), (Object)new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree_omg", null, Arrays.asList("o", "mg")), (Object)new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree_omg2", null, Arrays.asList("o", "mg2")))), null, null, null, null);
        ByteEntity source = new ByteEntity(StringUtils.toUtf8((String)"{\"timestamp\":\"2019-01-01\",\"bar\":null,\"foo\":\"x\",\"baz\":4,\"o\":{\"mg\":1}}"));
        InputEntityReader reader = format.createReader(new InputRowSchema(new TimestampSpec("timestamp", "iso", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"bar", (Object)"foo"))), ColumnsFilter.all()), (InputEntity)source, null);
        boolean numExpectedIterations = true;
        try (CloseableIterator iterator = reader.read();){
            int numActualIterations = 0;
            while (iterator.hasNext()) {
                InputRow row = (InputRow)iterator.next();
                Assert.assertEquals((Object)DateTimes.of((String)"2019-01-01"), (Object)row.getTimestamp());
                Assert.assertEquals((Object)"x", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("foo")));
                Assert.assertEquals((Object)"4", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("baz")));
                Assert.assertEquals((Object)"4", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("root_baz")));
                Assert.assertEquals((Object)"4", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("tree_baz")));
                Assert.assertEquals((Object)"1", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("path_omg")));
                Assert.assertEquals((Object)"1", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("jq_omg")));
                Assert.assertEquals((Object)"1", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("tree_omg")));
                Assert.assertTrue((boolean)row.getDimension("root_baz2").isEmpty());
                Assert.assertTrue((boolean)row.getDimension("tree_baz2").isEmpty());
                Assert.assertTrue((boolean)row.getDimension("path_omg2").isEmpty());
                Assert.assertTrue((boolean)row.getDimension("jq_omg2").isEmpty());
                Assert.assertTrue((boolean)row.getDimension("tree_omg2").isEmpty());
                ++numActualIterations;
            }
            Assert.assertEquals((long)1L, (long)numActualIterations);
        }
    }

    @Test
    public void testParseRowWithConditional() throws IOException {
        JsonInputFormat format = new JsonInputFormat(new JSONPathSpec(Boolean.valueOf(true), (List)ImmutableList.of((Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "foo", "$.[?(@.maybe_object)].maybe_object.foo.test"), (Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "baz", "$.maybe_object_2.foo.test"), (Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "bar", "$.[?(@.something_else)].something_else.foo"))), null, null, null, null);
        ByteEntity source = new ByteEntity(StringUtils.toUtf8((String)"{\"timestamp\":\"2019-01-01\",\"something_else\": {\"foo\": \"test\"}}"));
        InputEntityReader reader = format.createReader(new InputRowSchema(new TimestampSpec("timestamp", "iso", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"foo"))), ColumnsFilter.all()), (InputEntity)source, null);
        boolean numExpectedIterations = true;
        try (CloseableIterator iterator = reader.read();){
            int numActualIterations = 0;
            while (iterator.hasNext()) {
                InputRow row = (InputRow)iterator.next();
                Assert.assertEquals((Object)"test", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("bar")));
                Assert.assertEquals(Collections.singletonList(null), (Object)row.getRaw("foo"));
                Assert.assertEquals(Collections.singletonList("null"), (Object)row.getDimension("foo"));
                Assert.assertTrue((boolean)row.getDimension("baz").isEmpty());
                ++numActualIterations;
            }
            Assert.assertEquals((long)1L, (long)numActualIterations);
        }
    }

    @Test
    public void testParseRowKeepNullColumns() throws IOException {
        JsonInputFormat format = new JsonInputFormat(new JSONPathSpec(Boolean.valueOf(true), (List)ImmutableList.of((Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "path_omg", "$.o.mg"), (Object)new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree_omg", null, Arrays.asList("o", "mg")))), null, Boolean.valueOf(true), null, null);
        ByteEntity source = new ByteEntity(StringUtils.toUtf8((String)"{\"timestamp\":\"2019-01-01\",\"bar\":null,\"foo\":\"x\",\"o\":{\"mg\":null}}"));
        InputEntityReader reader = format.createReader(new InputRowSchema(new TimestampSpec("timestamp", "iso", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Collections.emptyList())), ColumnsFilter.all()), (InputEntity)source, null);
        boolean numExpectedIterations = true;
        try (CloseableIterator iterator = reader.read();){
            int numActualIterations = 0;
            while (iterator.hasNext()) {
                InputRow row = (InputRow)iterator.next();
                Assert.assertEquals(Arrays.asList("path_omg", "tree_omg", "bar", "foo"), (Object)row.getDimensions());
                Assert.assertTrue((boolean)row.getDimension("bar").isEmpty());
                Assert.assertEquals((Object)"x", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("foo")));
                Assert.assertTrue((boolean)row.getDimension("path_omg").isEmpty());
                Assert.assertTrue((boolean)row.getDimension("tree_omg").isEmpty());
                ++numActualIterations;
            }
            Assert.assertEquals((long)1L, (long)numActualIterations);
        }
    }

    @Test
    public void testKeepNullColumnsWithNoNullValues() throws IOException {
        JsonInputFormat format = new JsonInputFormat(new JSONPathSpec(Boolean.valueOf(true), (List)ImmutableList.of((Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "path_omg", "$.o.mg"), (Object)new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree_omg", null, Arrays.asList("o", "mg")))), null, Boolean.valueOf(true), null, null);
        ByteEntity source = new ByteEntity(StringUtils.toUtf8((String)"{\"timestamp\":\"2019-01-01\",\"bar\":1,\"foo\":\"x\",\"o\":{\"mg\":\"a\"}}"));
        InputEntityReader reader = format.createReader(new InputRowSchema(new TimestampSpec("timestamp", "iso", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Collections.emptyList())), ColumnsFilter.all()), (InputEntity)source, null);
        boolean numExpectedIterations = true;
        try (CloseableIterator iterator = reader.read();){
            int numActualIterations = 0;
            while (iterator.hasNext()) {
                InputRow row = (InputRow)iterator.next();
                Assert.assertEquals(Arrays.asList("path_omg", "tree_omg", "bar", "foo"), (Object)row.getDimensions());
                Assert.assertEquals((Object)"1", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("bar")));
                Assert.assertEquals((Object)"x", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("foo")));
                Assert.assertEquals((Object)"a", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("path_omg")));
                Assert.assertEquals((Object)"a", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("tree_omg")));
                ++numActualIterations;
            }
            Assert.assertEquals((long)1L, (long)numActualIterations);
        }
    }

    @Test
    public void testFalseKeepNullColumns() throws IOException {
        JsonInputFormat format = new JsonInputFormat(new JSONPathSpec(Boolean.valueOf(true), (List)ImmutableList.of((Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "path_omg", "$.o.mg"), (Object)new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree_omg", null, Arrays.asList("o", "mg")))), null, Boolean.valueOf(false), null, null);
        ByteEntity source = new ByteEntity(StringUtils.toUtf8((String)"{\"timestamp\":\"2019-01-01\",\"bar\":null,\"foo\":\"x\",\"o\":{\"mg\":\"a\"}}"));
        InputEntityReader reader = format.createReader(new InputRowSchema(new TimestampSpec("timestamp", "iso", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Collections.emptyList())), ColumnsFilter.all()), (InputEntity)source, null);
        boolean numExpectedIterations = true;
        try (CloseableIterator iterator = reader.read();){
            int numActualIterations = 0;
            while (iterator.hasNext()) {
                InputRow row = (InputRow)iterator.next();
                Assert.assertEquals(Arrays.asList("path_omg", "tree_omg", "foo"), (Object)row.getDimensions());
                Assert.assertTrue((boolean)row.getDimension("bar").isEmpty());
                Assert.assertEquals((Object)"x", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("foo")));
                Assert.assertEquals((Object)"a", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("path_omg")));
                Assert.assertEquals((Object)"a", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("tree_omg")));
                ++numActualIterations;
            }
            Assert.assertEquals((long)1L, (long)numActualIterations);
        }
    }
}

