/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.druid.data.input.ColumnsFilter;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputEntityReader;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.impl.ByteEntity;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.LinesReader;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class LinesReaderTest
extends InitializedNullHandlingTest {
    @Test
    public void testSimpleLineParsing() throws IOException {
        String input = "line1\nline2\nline3";
        InputEntityReader reader = this.createReader("line1\nline2\nline3", Collections.emptyList());
        List<InputRow> inputRows = this.readAllRows(reader);
        Assert.assertEquals((long)3L, (long)inputRows.size());
        Assert.assertEquals((Object)"line1", (Object)inputRows.get(0).getRaw("line"));
        Assert.assertEquals((Object)"line2", (Object)inputRows.get(1).getRaw("line"));
        Assert.assertEquals((Object)"line3", (Object)inputRows.get(2).getRaw("line"));
    }

    @Test
    public void testEmptyLines() throws IOException {
        String input = "line1\n\n line3\n";
        InputEntityReader reader = this.createReader("line1\n\n line3\n", Collections.emptyList());
        List<InputRow> inputRows = this.readAllRows(reader);
        Assert.assertEquals((long)3L, (long)inputRows.size());
        Assert.assertEquals((Object)"line1", (Object)inputRows.get(0).getRaw("line"));
        Assert.assertEquals((Object)"", (Object)inputRows.get(1).getRaw("line"));
        Assert.assertEquals((Object)" line3", (Object)inputRows.get(2).getRaw("line"));
    }

    @Test
    public void testSingleLine() throws IOException {
        String input = "single line without newline";
        InputEntityReader reader = this.createReader("single line without newline", Collections.emptyList());
        List<InputRow> inputRows = this.readAllRows(reader);
        Assert.assertEquals((long)1L, (long)inputRows.size());
        Assert.assertEquals((Object)"single line without newline", (Object)inputRows.get(0).getRaw("line"));
    }

    @Test
    public void testToMap() {
        String input = "test line";
        LinesReader reader = (LinesReader)this.createReader("test line", Collections.emptyList());
        List maps = reader.toMap("test line");
        Assert.assertEquals((long)1L, (long)maps.size());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"line", (Object)"test line"), maps.get(0));
    }

    private InputEntityReader createReader(String input, List<String> columns) {
        InputRowSchema inputRowSchema = new InputRowSchema(new TimestampSpec("__time", "auto", DateTimes.of((String)"2000-01-01T00:00:00.000Z")), new DimensionsSpec(DimensionsSpec.getDefaultSchemas(columns)), ColumnsFilter.all());
        ByteEntity entity = new ByteEntity(StringUtils.toUtf8((String)input));
        return new LinesReader(inputRowSchema, (InputEntity)entity);
    }

    private List<InputRow> readAllRows(InputEntityReader reader) throws IOException {
        try (CloseableIterator iterator = reader.read();){
            ArrayList arrayList = Lists.newArrayList((Iterator)iterator);
            return arrayList;
        }
    }
}

