/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.MaxSizeSplitHintSpec;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.data.input.impl.FileEntity;
import org.apache.druid.data.input.impl.LocalInputSource;
import org.apache.druid.data.input.impl.NoopInputFormat;
import org.apache.druid.data.input.impl.systemfield.SystemField;
import org.apache.druid.data.input.impl.systemfield.SystemFields;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.utils.Streams;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class LocalInputSourceTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testSerdeAbsoluteBaseDir() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        LocalInputSource source = new LocalInputSource(new File("myFile").getAbsoluteFile(), "myFilter");
        byte[] json = mapper.writeValueAsBytes((Object)source);
        LocalInputSource fromJson = (LocalInputSource)mapper.readValue(json, InputSource.class);
        Assert.assertEquals((Object)source, (Object)fromJson);
    }

    @Test
    public void testSerdeRelativeBaseDir() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        LocalInputSource source = new LocalInputSource(new File("myFile"), "myFilter");
        byte[] json = mapper.writeValueAsBytes((Object)source);
        LocalInputSource fromJson = (LocalInputSource)mapper.readValue(json, InputSource.class);
        Assert.assertEquals((Object)source, (Object)fromJson);
        Assert.assertEquals(Collections.emptySet(), (Object)fromJson.getConfiguredSystemFields());
    }

    @Test
    public void testSerdeRelativeBaseDirWithSystemFields() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        LocalInputSource source = new LocalInputSource(new File("myFile"), "myFilter", null, new SystemFields(EnumSet.of(SystemField.URI, SystemField.PATH)));
        byte[] json = mapper.writeValueAsBytes((Object)source);
        LocalInputSource fromJson = (LocalInputSource)mapper.readValue(json, InputSource.class);
        Assert.assertEquals((Object)source, (Object)fromJson);
        Assert.assertEquals(EnumSet.of(SystemField.URI, SystemField.PATH), (Object)fromJson.getConfiguredSystemFields());
    }

    @Test
    public void testSerdeMixedAbsoluteAndRelativeFiles() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        LocalInputSource source = new LocalInputSource(null, null, (List)ImmutableList.of((Object)new File("myFile1"), (Object)new File("myFile2").getAbsoluteFile()), null);
        byte[] json = mapper.writeValueAsBytes((Object)source);
        LocalInputSource fromJson = (LocalInputSource)mapper.readValue(json, InputSource.class);
        Assert.assertEquals((Object)source, (Object)fromJson);
    }

    @Test
    public void testGetTypes() {
        LocalInputSource source = new LocalInputSource(new File("myFile").getAbsoluteFile(), "myFilter");
        Assert.assertEquals(Collections.singleton("local"), (Object)source.getTypes());
    }

    @Test
    public void testSystemFields() {
        LocalInputSource inputSource = new LocalInputSource(null, null, (List)ImmutableList.of((Object)new File("myFile1"), (Object)new File("myFile2").getAbsoluteFile()), new SystemFields(EnumSet.of(SystemField.URI, SystemField.PATH)));
        Assert.assertEquals(EnumSet.of(SystemField.URI, SystemField.PATH), (Object)inputSource.getConfiguredSystemFields());
        FileEntity entity = new FileEntity(new File("/tmp/foo"));
        Assert.assertEquals((Object)"file:/tmp/foo", (Object)inputSource.getSystemFieldValue((InputEntity)entity, SystemField.URI));
        Assert.assertEquals((Object)"/tmp/foo", (Object)inputSource.getSystemFieldValue((InputEntity)entity, SystemField.PATH));
    }

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(LocalInputSource.class).usingGetClass().withNonnullFields(new String[]{"files"}).verify();
    }

    @Test
    public void testCreateSplitsRespectingSplitHintSpec() {
        long fileSize = 15L;
        HumanReadableBytes maxSplitSize = new HumanReadableBytes(50L);
        List<File> files = LocalInputSourceTest.mockFiles(10, 15L);
        LocalInputSource inputSource = new LocalInputSource(null, null, files, null);
        List splits = inputSource.createSplits((InputFormat)new NoopInputFormat(), (SplitHintSpec)new MaxSizeSplitHintSpec(maxSplitSize, null)).collect(Collectors.toList());
        Assert.assertEquals((long)4L, (long)splits.size());
        Assert.assertEquals((long)3L, (long)((List)((InputSplit)splits.get(0)).get()).size());
        Assert.assertEquals((long)3L, (long)((List)((InputSplit)splits.get(1)).get()).size());
        Assert.assertEquals((long)3L, (long)((List)((InputSplit)splits.get(2)).get()).size());
        Assert.assertEquals((long)1L, (long)((List)((InputSplit)splits.get(3)).get()).size());
    }

    @Test
    public void testEstimateNumSplitsRespectingSplitHintSpec() {
        long fileSize = 13L;
        HumanReadableBytes maxSplitSize = new HumanReadableBytes(40L);
        List<File> files = LocalInputSourceTest.mockFiles(10, 13L);
        LocalInputSource inputSource = new LocalInputSource(null, null, files, null);
        Assert.assertEquals((long)4L, (long)inputSource.estimateNumSplits((InputFormat)new NoopInputFormat(), (SplitHintSpec)new MaxSizeSplitHintSpec(maxSplitSize, null)));
    }

    @Test
    public void testGetFileIteratorWithBothBaseDirAndDuplicateFilesIteratingFilesOnlyOnce() throws IOException {
        File baseDir = this.temporaryFolder.newFolder();
        ArrayList<File> filesInBaseDir = new ArrayList<File>();
        for (int i = 0; i < 10; ++i) {
            File file = File.createTempFile("local-input-source", ".data", baseDir);
            try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                writer.write("test");
            }
            filesInBaseDir.add(file);
        }
        List<File> files = filesInBaseDir.subList(0, 5);
        for (int i = 0; i < 3; ++i) {
            File file = File.createTempFile("local-input-source", ".data", baseDir);
            try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                writer.write("test");
            }
            files.add(file);
        }
        HashSet<File> expectedFiles = new HashSet<File>(filesInBaseDir);
        expectedFiles.addAll(files);
        File.createTempFile("local-input-source", ".filtered", baseDir);
        Iterator fileIterator = new LocalInputSource(baseDir, "*.data", files, null).getFileIterator();
        Set actualFiles = Streams.sequentialStreamFrom((Iterator)fileIterator).collect(Collectors.toSet());
        Assert.assertEquals(expectedFiles, actualFiles);
    }

    @Test
    public void testGetFileIteratorWithOnlyBaseDirIteratingAllFiles() throws IOException {
        File baseDir = this.temporaryFolder.newFolder();
        HashSet<File> filesInBaseDir = new HashSet<File>();
        for (int i = 0; i < 10; ++i) {
            File file = File.createTempFile("local-input-source", ".data", baseDir);
            try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                writer.write("test");
            }
            filesInBaseDir.add(file);
        }
        Iterator fileIterator = new LocalInputSource(baseDir, "*", null, null).getFileIterator();
        Set actualFiles = Streams.sequentialStreamFrom((Iterator)fileIterator).collect(Collectors.toSet());
        Assert.assertEquals(filesInBaseDir, actualFiles);
    }

    @Test
    public void testGetFileIteratorWithOnlyFilesIteratingAllFiles() throws IOException {
        File baseDir = this.temporaryFolder.newFolder();
        ArrayList<File> filesInBaseDir = new ArrayList<File>();
        for (int i = 0; i < 10; ++i) {
            File file = File.createTempFile("local-input-source", ".data", baseDir);
            try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                writer.write("test");
            }
            filesInBaseDir.add(file);
        }
        Iterator fileIterator = new LocalInputSource(null, null, filesInBaseDir, null).getFileIterator();
        List actualFiles = Streams.sequentialStreamFrom((Iterator)fileIterator).collect(Collectors.toList());
        Assert.assertEquals(filesInBaseDir, actualFiles);
    }

    @Test
    public void testFileIteratorWithEmptyFilesIteratingNonEmptyFilesOnly() {
        List<File> files = LocalInputSourceTest.mockFiles(10, 5L);
        files.addAll(LocalInputSourceTest.mockFiles(10, 0L));
        LocalInputSource inputSource = new LocalInputSource(null, null, files, null);
        ArrayList iteratedFiles = Lists.newArrayList((Iterator)inputSource.getFileIterator());
        Assert.assertTrue((boolean)iteratedFiles.stream().allMatch(file -> file.length() > 0L));
    }

    @Test
    public void testRebuildSame() {
        LocalInputSource src = new LocalInputSource(new File("myFile"), "myFilter", (List)ImmutableList.of((Object)new File("someFile")), new SystemFields(EnumSet.of(SystemField.URI, SystemField.PATH)));
        LocalInputSource copy = new LocalInputSource(src.getBaseDir(), src.getFilter(), src.getFiles(), src.getSystemFields());
        Assert.assertEquals((Object)src, (Object)copy);
    }

    private static List<File> mockFiles(int numFiles, long fileSize) {
        ArrayList<File> files = new ArrayList<File>();
        for (int i = 0; i < numFiles; ++i) {
            File file = (File)EasyMock.niceMock(File.class);
            EasyMock.expect((Object)file.length()).andReturn((Object)fileSize).anyTimes();
            EasyMock.replay((Object[])new Object[]{file});
            files.add(file);
        }
        return files;
    }
}

