/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class MapInputRowParserTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final TimestampSpec timestampSpec = new TimestampSpec("time", null, null);
    private final DimensionsSpec dimensionsSpec = DimensionsSpec.builder().setDefaultSchemaDimensions((List)ImmutableList.of((Object)"dim")).setDimensionExclusions((List)ImmutableList.of((Object)"time")).build();

    @Test
    public void testParseValidInput() {
        InputRow inputRow = MapInputRowParser.parse((TimestampSpec)this.timestampSpec, (DimensionsSpec)this.dimensionsSpec, (Map)ImmutableMap.of((Object)"time", (Object)"2020-01-01", (Object)"dim", (Object)0, (Object)"met", (Object)10));
        Assert.assertEquals((Object)this.dimensionsSpec.getDimensionNames(), (Object)inputRow.getDimensions());
        Assert.assertEquals((Object)DateTimes.of((String)"2020-01-01"), (Object)inputRow.getTimestamp());
        Assert.assertEquals((Object)ImmutableList.of((Object)"0"), (Object)inputRow.getDimension("dim"));
        Assert.assertEquals((Object)10, (Object)inputRow.getMetric("met"));
    }

    @Test
    public void testParseInvalidTimestampThrowParseException() {
        this.expectedException.expect(ParseException.class);
        this.expectedException.expectMessage("Timestamp[invalid timestamp] is unparseable!");
        InputRow inputRow = MapInputRowParser.parse((TimestampSpec)this.timestampSpec, (DimensionsSpec)this.dimensionsSpec, (Map)ImmutableMap.of((Object)"time", (Object)"invalid timestamp", (Object)"dim", (Object)0, (Object)"met", (Object)10));
    }

    @Test
    public void testParseMissingTimestampThrowParseException() {
        this.expectedException.expect(ParseException.class);
        this.expectedException.expectMessage("Timestamp[null] is unparseable!");
        InputRow inputRow = MapInputRowParser.parse((TimestampSpec)this.timestampSpec, (DimensionsSpec)this.dimensionsSpec, (Map)ImmutableMap.of((Object)"dim", (Object)0, (Object)"met", (Object)10));
    }

    @Test
    public void testParseTimestampSmallerThanMinThrowParseException() {
        this.expectedException.expect(ParseException.class);
        this.expectedException.expectMessage("Encountered row with timestamp[-146136543-09-08T08:23:32.095Z] that cannot be represented as a long");
        MapInputRowParser.parse((TimestampSpec)this.timestampSpec, (DimensionsSpec)this.dimensionsSpec, (Map)ImmutableMap.of((Object)"time", (Object)DateTimes.utc((long)-4611686018427387905L), (Object)"dim", (Object)0, (Object)"met", (Object)10));
    }

    @Test
    public void testParseTimestampLargerThanMaxThrowParseException() {
        this.expectedException.expect(ParseException.class);
        this.expectedException.expectMessage("Encountered row with timestamp[146140482-04-24T15:36:27.904Z] that cannot be represented as a long");
        MapInputRowParser.parse((TimestampSpec)this.timestampSpec, (DimensionsSpec)this.dimensionsSpec, (Map)ImmutableMap.of((Object)"time", (Object)DateTimes.utc((long)0x4000000000000000L), (Object)"dim", (Object)0, (Object)"met", (Object)10));
    }

    @Test
    public void testIncludeOnlyDimensionsDefinedInDimensionsSpec() {
        InputRow inputRow = MapInputRowParser.parse((TimestampSpec)this.timestampSpec, (DimensionsSpec)this.dimensionsSpec, (Map)ImmutableMap.of((Object)"time", (Object)"2020-01-01", (Object)"dim", (Object)"val1", (Object)"dim2", (Object)"val2", (Object)"met", (Object)10));
        Assert.assertEquals((Object)this.dimensionsSpec.getDimensionNames(), (Object)inputRow.getDimensions());
        Assert.assertEquals((Object)DateTimes.of((String)"2020-01-01"), (Object)inputRow.getTimestamp());
        Assert.assertEquals((Object)ImmutableList.of((Object)"val1"), (Object)inputRow.getDimension("dim"));
        Assert.assertEquals((Object)10, (Object)inputRow.getMetric("met"));
    }

    @Test
    public void testIncludeOnlyDiscoveredDimensionsFromInputWhenDimensionsSpecIsEmpty() {
        InputRow inputRow = MapInputRowParser.parse((TimestampSpec)this.timestampSpec, (DimensionsSpec)DimensionsSpec.builder().setDimensionExclusions((List)ImmutableList.of((Object)"time", (Object)"met")).build(), (Map)ImmutableMap.of((Object)"time", (Object)"2020-01-01", (Object)"dim", (Object)"val1", (Object)"dim2", (Object)"val2", (Object)"met", (Object)10));
        Assert.assertEquals((Object)ImmutableList.of((Object)"dim", (Object)"dim2"), (Object)inputRow.getDimensions());
        Assert.assertEquals((Object)DateTimes.of((String)"2020-01-01"), (Object)inputRow.getTimestamp());
        Assert.assertEquals((Object)ImmutableList.of((Object)"val1"), (Object)inputRow.getDimension("dim"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"val2"), (Object)inputRow.getDimension("dim2"));
        Assert.assertEquals((Object)10, (Object)inputRow.getMetric("met"));
    }

    @Test
    public void testIncludeAllDimensions() {
        InputRow inputRow = MapInputRowParser.parse((TimestampSpec)this.timestampSpec, (DimensionsSpec)DimensionsSpec.builder().setDefaultSchemaDimensions((List)ImmutableList.of((Object)"dim3")).setDimensionExclusions((List)ImmutableList.of((Object)"time", (Object)"met")).setIncludeAllDimensions(true).build(), (Map)ImmutableMap.of((Object)"time", (Object)"2020-01-01", (Object)"dim", (Object)"val1", (Object)"dim2", (Object)"val2", (Object)"dim3", (Object)"val3", (Object)"met", (Object)10));
        Assert.assertEquals((Object)ImmutableList.of((Object)"dim3", (Object)"dim", (Object)"dim2"), (Object)inputRow.getDimensions());
        Assert.assertEquals((Object)DateTimes.of((String)"2020-01-01"), (Object)inputRow.getTimestamp());
        Assert.assertEquals((Object)ImmutableList.of((Object)"val3"), (Object)inputRow.getDimension("dim3"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"val1"), (Object)inputRow.getDimension("dim"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"val2"), (Object)inputRow.getDimension("dim2"));
        Assert.assertEquals((Object)10, (Object)inputRow.getMetric("met"));
    }

    @Test
    public void testSchemaDiscovery() {
        InputRow inputRow = MapInputRowParser.parse((TimestampSpec)this.timestampSpec, (DimensionsSpec)DimensionsSpec.builder().setDefaultSchemaDimensions((List)ImmutableList.of((Object)"string")).setDimensionExclusions((List)ImmutableList.of((Object)"time", (Object)"long")).useSchemaDiscovery(true).build(), (Map)ImmutableMap.builder().put((Object)"time", (Object)"2020-01-01").put((Object)"array_double", (Object)ImmutableList.of((Object)1.1, (Object)2.2, (Object)3.3)).put((Object)"array_long", (Object)ImmutableList.of((Object)1, (Object)2, (Object)3)).put((Object)"array_string", (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c")).put((Object)"bool", (Object)true).put((Object)"double", (Object)1.0).put((Object)"float", (Object)Float.valueOf(1.0f)).put((Object)"long", (Object)1L).put((Object)"nested", (Object)ImmutableMap.of((Object)"x", (Object)1, (Object)"y", (Object)ImmutableList.of((Object)"a", (Object)"b"))).put((Object)"string", (Object)"a").build());
        Assert.assertEquals((Object)ImmutableList.of((Object)"string", (Object)"array_double", (Object)"array_long", (Object)"array_string", (Object)"bool", (Object)"double", (Object)"float", (Object)"nested"), (Object)inputRow.getDimensions());
    }
}

