/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.util.List;
import junit.framework.Assert;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.TimeAndDimsParseSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.junit.Test;

public class TimeAndDimsParseSpecTest {
    private final ObjectMapper mapper = new ObjectMapper();

    @Test
    public void testSerdeWithNulls() throws Exception {
        String jsonStr = "{ \"format\":\"timeAndDims\" }";
        ParseSpec actual = (ParseSpec)this.mapper.readValue(this.mapper.writeValueAsString(this.mapper.readValue(jsonStr, ParseSpec.class)), ParseSpec.class);
        Assert.assertEquals((Object)new TimeAndDimsParseSpec(null, null), (Object)actual);
    }

    @Test
    public void testSerdeWithNonNulls() throws Exception {
        String jsonStr = "{\"format\":\"timeAndDims\",\"timestampSpec\": { \"column\": \"tcol\" },\"dimensionsSpec\": { \"dimensions\": [\"host\"] }}";
        ParseSpec actual = (ParseSpec)this.mapper.readValue(this.mapper.writeValueAsString(this.mapper.readValue(jsonStr, ParseSpec.class)), ParseSpec.class);
        Assert.assertEquals((Object)new TimeAndDimsParseSpec(new TimestampSpec("tcol", null, null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"host")))), (Object)actual);
    }
}

