/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.error;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.error.ErrorResponse;
import org.apache.druid.error.InvalidSqlInput;
import org.apache.druid.error.QueryExceptionCompat;
import org.apache.druid.matchers.DruidMatchers;
import org.apache.druid.query.QueryException;
import org.apache.druid.query.QueryTimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class ErrorResponseTest {
    @Test
    public void testSanity() {
        ErrorResponse response = new ErrorResponse(InvalidSqlInput.exception((String)"bad sql!", (Object[])new Object[0]));
        Map asMap = response.getAsMap();
        MatcherAssert.assertThat((Object)asMap, DruidMatchers.mapMatcher("error", "druidException", "errorCode", "invalidInput", "persona", "USER", "category", "INVALID_INPUT", "errorMessage", "bad sql!", "context", ImmutableMap.of((Object)"sourceType", (Object)"sql")));
        ErrorResponse recomposed = ErrorResponse.fromMap((Map)asMap);
        MatcherAssert.assertThat((Object)recomposed.getUnderlyingException(), (Matcher)DruidExceptionMatcher.invalidSqlInput().expectMessageIs("bad sql!"));
    }

    @Test
    public void testQueryExceptionCompat() {
        ErrorResponse response = new ErrorResponse(DruidException.fromFailure((DruidException.Failure)new QueryExceptionCompat((QueryException)new QueryTimeoutException())));
        Map asMap = response.getAsMap();
        MatcherAssert.assertThat((Object)asMap, DruidMatchers.mapMatcher("error", "Query timeout", "errorCode", "legacyQueryException", "persona", "OPERATOR", "category", "TIMEOUT", "errorMessage", "Query did not complete within configured timeout period. You can increase query timeout or tune the performance of query."));
        MatcherAssert.assertThat((Object)asMap, (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"context"), (Matcher)Matchers.allOf(DruidMatchers.mapMatcher("errorClass", "org.apache.druid.query.QueryTimeoutException", "legacyErrorCode", "Query timeout"), (Matcher)Matchers.hasKey((Object)"host"))));
        ErrorResponse recomposed = ErrorResponse.fromMap((Map)asMap);
        MatcherAssert.assertThat((Object)recomposed.getUnderlyingException(), (Matcher)new DruidExceptionMatcher(DruidException.Persona.OPERATOR, DruidException.Category.TIMEOUT, "legacyQueryException").expectMessageIs("Query did not complete within configured timeout period. You can increase query timeout or tune the performance of query."));
    }

    @Test
    public void testQueryExceptionCompatWithNullMessage() {
        ErrorResponse response = new ErrorResponse(DruidException.fromFailure((DruidException.Failure)new QueryExceptionCompat((QueryException)new QueryTimeoutException(null, "hostname"))));
        Map asMap = response.getAsMap();
        MatcherAssert.assertThat((Object)asMap, DruidMatchers.mapMatcher("error", "Query timeout", "errorCode", "legacyQueryException", "persona", "OPERATOR", "category", "TIMEOUT", "errorMessage", "null"));
    }
}

