/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.extendedset.intset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.Assert;
import org.apache.druid.extendedset.intset.ConciseSet;
import org.apache.druid.extendedset.intset.ImmutableConciseSet;
import org.apache.druid.extendedset.intset.IntSet;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ImmutableConciseSetIntersectionTest {
    private boolean compact;

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return Arrays.asList({false}, {true});
    }

    public ImmutableConciseSetIntersectionTest(boolean compact) {
        this.compact = compact;
    }

    @Test
    public void testIntersection1() {
        int[] ints1 = new int[]{33, 100000};
        int[] ints2 = new int[]{33, 100000};
        List<Integer> expected = Arrays.asList(33, 100000);
        ConciseSet set1 = new ConciseSet();
        for (int i : ints1) {
            set1.add(i);
        }
        ConciseSet set2 = new ConciseSet();
        for (int i : ints2) {
            set2.add(i);
        }
        this.verifyIntersection(expected, set1, set2);
    }

    @Test
    public void testIntersection2() {
        int[] ints1 = new int[]{33, 100000};
        int[] ints2 = new int[]{34, 100000};
        List<Integer> expected = Collections.singletonList(100000);
        ConciseSet set1 = new ConciseSet();
        for (int i : ints1) {
            set1.add(i);
        }
        ConciseSet set2 = new ConciseSet();
        for (int i : ints2) {
            set2.add(i);
        }
        this.verifyIntersection(expected, set1, set2);
    }

    @Test
    public void testIntersection3() {
        ArrayList<Integer> expected = new ArrayList<Integer>();
        ConciseSet set1 = new ConciseSet();
        ConciseSet set2 = new ConciseSet();
        for (int i = 0; i < 1000; ++i) {
            set1.add(i);
            set2.add(i);
            expected.add(i);
        }
        this.verifyIntersection(expected, set1, set2);
    }

    @Test
    public void testIntersection4() {
        ArrayList<Integer> expected = new ArrayList<Integer>();
        ConciseSet set1 = new ConciseSet();
        ConciseSet set2 = new ConciseSet();
        for (int i = 0; i < 1000; ++i) {
            set1.add(i);
            if (i == 500) continue;
            set2.add(i);
            expected.add(i);
        }
        this.verifyIntersection(expected, set1, set2);
    }

    @Test
    public void testIntersection5() {
        int[] ints1 = new int[]{33, 100000};
        int[] ints2 = new int[]{34, 200000};
        ArrayList<Integer> expected = new ArrayList<Integer>();
        ConciseSet set1 = new ConciseSet();
        for (int i : ints1) {
            set1.add(i);
        }
        ConciseSet set2 = new ConciseSet();
        for (int i : ints2) {
            set2.add(i);
        }
        this.verifyIntersection(expected, set1, set2);
    }

    @Test
    public void testIntersection6() {
        int i;
        int i2;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        ConciseSet set1 = new ConciseSet();
        for (i2 = 0; i2 < 5; ++i2) {
            set1.add(i2);
        }
        for (i2 = 1000; i2 < 1005; ++i2) {
            set1.add(i2);
        }
        ConciseSet set2 = new ConciseSet();
        for (i = 800; i < 805; ++i) {
            set2.add(i);
        }
        for (i = 806; i < 1005; ++i) {
            set2.add(i);
        }
        for (i = 1000; i < 1005; ++i) {
            expected.add(i);
        }
        this.verifyIntersection(expected, set1, set2);
    }

    @Test
    public void testIntersection7() {
        ConciseSet set1 = new ConciseSet();
        for (int i = 0; i < 3100; ++i) {
            set1.add(i);
        }
        ConciseSet set2 = new ConciseSet();
        set2.add(100);
        set2.add(500);
        for (int i = 600; i < 700; ++i) {
            set2.add(i);
        }
        ArrayList<Integer> expected = new ArrayList<Integer>();
        expected.add(100);
        expected.add(500);
        for (int i = 600; i < 700; ++i) {
            expected.add(i);
        }
        this.verifyIntersection(expected, set1, set2);
    }

    @Test
    public void testIntersection8() {
        ConciseSet set1 = new ConciseSet();
        for (int i = 0; i < 3100; ++i) {
            set1.add(i);
        }
        set1.add(4001);
        ConciseSet set2 = new ConciseSet();
        set2.add(100);
        set2.add(500);
        for (int i = 600; i < 700; ++i) {
            set2.add(i);
        }
        set2.add(4001);
        ArrayList<Integer> expected = new ArrayList<Integer>();
        expected.add(100);
        expected.add(500);
        for (int i = 600; i < 700; ++i) {
            expected.add(i);
        }
        expected.add(4001);
        this.verifyIntersection(expected, set1, set2);
    }

    @Test
    public void testIntersection9() {
        ConciseSet set1 = new ConciseSet();
        set1.add(2005);
        set1.add(3005);
        set1.add(3008);
        ConciseSet set2 = new ConciseSet();
        for (int i = 0; i < 3007; ++i) {
            set2.add(i);
        }
        ArrayList<Integer> expected = new ArrayList<Integer>();
        expected.add(2005);
        expected.add(3005);
        this.verifyIntersection(expected, set1, set2);
    }

    @Test
    public void testIntersection10() {
        ConciseSet set1 = new ConciseSet();
        for (int i = 0; i < 3100; ++i) {
            set1.add(i);
        }
        ConciseSet set2 = new ConciseSet();
        set2.add(500);
        set2.add(600);
        set2.add(4001);
        ArrayList<Integer> expected = new ArrayList<Integer>();
        expected.add(500);
        expected.add(600);
        this.verifyIntersection(expected, set1, set2);
    }

    @Test
    public void testIntersection11() {
        ConciseSet set1 = new ConciseSet();
        set1.add(2005);
        for (int i = 2800; i < 3500; ++i) {
            set1.add(i);
        }
        ConciseSet set2 = new ConciseSet();
        for (int i = 0; i < 3007; ++i) {
            set2.add(i);
        }
        ArrayList<Integer> expected = new ArrayList<Integer>();
        expected.add(2005);
        for (int i = 2800; i < 3007; ++i) {
            expected.add(i);
        }
        this.verifyIntersection(expected, set1, set2);
    }

    @Test
    public void testIntersection12() {
        ConciseSet set1 = new ConciseSet();
        set1.add(2005);
        for (int i = 2800; i < 3500; ++i) {
            set1.add(i);
        }
        set1.add(10005);
        ConciseSet set2 = new ConciseSet();
        for (int i = 0; i < 3007; ++i) {
            set2.add(i);
        }
        set2.add(10005);
        ArrayList<Integer> expected = new ArrayList<Integer>();
        expected.add(2005);
        for (int i = 2800; i < 3007; ++i) {
            expected.add(i);
        }
        expected.add(10005);
        this.verifyIntersection(expected, set1, set2);
    }

    @Test
    public void testIntersection13() {
        ConciseSet set1 = new ConciseSet();
        set1.add(2005);
        ConciseSet set2 = new ConciseSet();
        for (int i = 0; i < 100; ++i) {
            set2.add(i);
        }
        ArrayList<Integer> expected = new ArrayList<Integer>();
        this.verifyIntersection(expected, set1, set2);
    }

    @Test
    public void testIntersection14() {
        ConciseSet set1 = new ConciseSet();
        for (int i = 0; i < 1000; ++i) {
            set1.add(i);
        }
        ConciseSet set2 = new ConciseSet();
        set2.add(0);
        set2.add(3);
        set2.add(5);
        set2.add(100);
        set2.add(101);
        ArrayList<Integer> expected = new ArrayList<Integer>();
        expected.add(0);
        expected.add(3);
        expected.add(5);
        expected.add(100);
        expected.add(101);
        this.verifyIntersection(expected, set1, set2);
    }

    @Test
    public void testIntersection15() {
        ConciseSet set1 = new ConciseSet();
        for (int i = 0; i < 1000; ++i) {
            set1.add(i);
        }
        ConciseSet set2 = new ConciseSet();
        set2.add(0);
        set2.add(3);
        set2.add(5);
        for (int i = 100; i < 500; ++i) {
            set2.add(i);
        }
        ArrayList<Integer> expected = new ArrayList<Integer>();
        expected.add(0);
        expected.add(3);
        expected.add(5);
        for (int i = 100; i < 500; ++i) {
            expected.add(i);
        }
        this.verifyIntersection(expected, set1, set2);
    }

    @Test
    public void testIntersection16() {
        ConciseSet set1 = new ConciseSet();
        set1.add(2005);
        ConciseSet set2 = new ConciseSet();
        set2.add(0);
        set2.add(3);
        set2.add(5);
        set2.add(100);
        set2.add(101);
        ArrayList<Integer> expected = new ArrayList<Integer>();
        this.verifyIntersection(expected, set1, set2);
    }

    @Test
    public void testIntersection17() {
        ConciseSet set1 = new ConciseSet();
        for (int i = 0; i < 4002; ++i) {
            set1.add(i);
        }
        ConciseSet set2 = new ConciseSet();
        set2.add(4001);
        ArrayList<Integer> expected = new ArrayList<Integer>();
        expected.add(4001);
        this.verifyIntersection(expected, set1, set2);
    }

    @Test
    public void testIntersection18() {
        ConciseSet set1 = new ConciseSet();
        for (int i = 32; i < 93; ++i) {
            set1.add(i);
        }
        ConciseSet set2 = new ConciseSet();
        for (int i = 0; i < 62; ++i) {
            set2.add(i);
        }
        ArrayList<Integer> expected = new ArrayList<Integer>();
        for (int i = 32; i < 62; ++i) {
            expected.add(i);
        }
        this.verifyIntersection(expected, set1, set2);
    }

    @Test
    public void testIntersection19() {
        ConciseSet set1 = new ConciseSet();
        set1.add(2005);
        ConciseSet set2 = new ConciseSet();
        for (int i = 0; i < 10000; ++i) {
            set2.add(i);
        }
        ArrayList<Integer> expected = new ArrayList<Integer>();
        expected.add(2005);
        this.verifyIntersection(expected, set1, set2);
    }

    @Test
    public void testIntersectionLiteralAndOneFill() {
        ConciseSet set1 = new ConciseSet();
        for (int i = 0; i < 31; i += 2) {
            set1.add(i);
        }
        ConciseSet set2 = new ConciseSet();
        for (int i = 0; i < 1000; ++i) {
            if (i == 2) continue;
            set2.add(i);
        }
        this.verifyIntersection(set1, set2);
    }

    @Test
    public void testIntersectionZeroSequenceRemovedFromQueue() {
        int zeroSequence = 1;
        ConciseSet set1 = new ConciseSet(new int[]{zeroSequence}, false);
        ConciseSet set2 = new ConciseSet();
        for (int i = 0; i < 1000; ++i) {
            set2.add(i);
        }
        this.verifyIntersection(set1, set2);
    }

    @Test
    public void testIntersectionOneFillAndOneFillWithFlipBit() {
        ConciseSet set1 = new ConciseSet();
        for (int i = 0; i < 100; ++i) {
            set1.add(i);
        }
        ConciseSet set2 = new ConciseSet();
        for (int i = 0; i < 1000; ++i) {
            if (i == 2) continue;
            set2.add(i);
        }
        this.verifyIntersection(set1, set2);
    }

    @Test
    public void testIntersectionSecondOneFillRemovedFromQueue() {
        ConciseSet set1 = new ConciseSet();
        for (int i = 0; i < 62; ++i) {
            set1.add(i);
        }
        set1.add(100);
        ConciseSet set2 = new ConciseSet();
        for (int i = 0; i < 93; ++i) {
            set2.add(i);
        }
        this.verifyIntersection(set1, set2);
    }

    @Test
    public void testIntersectionFirstOneFillRemovedFromQueue() {
        ConciseSet set1 = new ConciseSet();
        for (int i = 0; i < 62; ++i) {
            set1.add(i);
        }
        ConciseSet set2 = new ConciseSet();
        for (int i = 0; i < 93; ++i) {
            set2.add(i);
        }
        this.verifyIntersection(set1, set2);
    }

    @Test
    public void testIntersectionTerminates() {
        this.verifyIntersection(Collections.emptyList(), Arrays.asList(new ImmutableConciseSet(), new ImmutableConciseSet()));
    }

    private static List<Integer> toList(ConciseSet set) {
        ArrayList<Integer> list1 = new ArrayList<Integer>();
        IntSet.IntIterator it = set.iterator();
        while (it.hasNext()) {
            list1.add(it.next());
        }
        return list1;
    }

    private void verifyIntersection(ConciseSet set1, ConciseSet set2) {
        List<Integer> expectedIntersection = ImmutableConciseSetIntersectionTest.toList(set1);
        expectedIntersection.retainAll(ImmutableConciseSetIntersectionTest.toList(set2));
        this.verifyIntersection(expectedIntersection, set1, set2);
    }

    private void verifyIntersection(List<Integer> expected, ConciseSet set1, ConciseSet set2) {
        ImmutableConciseSet immutableSet1 = ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set1);
        ImmutableConciseSet immutableSet2 = ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set2);
        if (this.compact) {
            immutableSet1 = ImmutableConciseSet.compact((ImmutableConciseSet)immutableSet1);
            immutableSet2 = ImmutableConciseSet.compact((ImmutableConciseSet)immutableSet2);
        }
        List<ImmutableConciseSet> immutableSets = Arrays.asList(immutableSet1, immutableSet2);
        this.verifyIntersection(expected, immutableSets);
    }

    private void verifyIntersection(List<Integer> expected, List<ImmutableConciseSet> sets) {
        ArrayList<Integer> actual = new ArrayList<Integer>();
        ImmutableConciseSet set = ImmutableConciseSet.intersection(sets);
        IntSet.IntIterator itr = set.iterator();
        while (itr.hasNext()) {
            actual.add(itr.next());
        }
        Assert.assertEquals(expected, actual);
    }
}

