/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junitparams.converters.Nullable;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.frame.field.ConstantFieldPointer;
import org.apache.druid.frame.field.FieldWriter;
import org.apache.druid.frame.field.ReadableFieldPointer;
import org.apache.druid.frame.field.StringArrayFieldReader;
import org.apache.druid.frame.field.StringArrayFieldWriter;
import org.apache.druid.frame.field.StringFieldReader;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.SubstringDimExtractionFn;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.StringPredicateDruidPredicateFactory;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.quality.Strictness;

public class StringFieldReaderTest
extends InitializedNullHandlingTest {
    private static final long MEMORY_POSITION = 1L;
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule().strictness(Strictness.STRICT_STUBS);
    @Mock
    public BaseObjectColumnValueSelector<Object[]> writeSelector;
    private WritableMemory memory;
    private FieldWriter fieldWriter;

    @Before
    public void setUp() {
        this.memory = WritableMemory.allocate((int)1000);
        this.fieldWriter = new StringArrayFieldWriter(this.writeSelector, false);
    }

    @After
    public void tearDown() {
        this.fieldWriter.close();
    }

    @Test
    public void test_isNull_nullValue() {
        this.writeToMemory(Collections.singletonList(null));
        Assert.assertTrue((boolean)new StringFieldReader().isNull((Memory)this.memory, 1L));
        Assert.assertFalse((boolean)new StringArrayFieldReader().isNull((Memory)this.memory, 1L));
    }

    @Test
    public void test_isNull_twoNullValues() {
        this.writeToMemory(Arrays.asList(null, null));
        Assert.assertFalse((boolean)new StringFieldReader().isNull((Memory)this.memory, 1L));
        Assert.assertFalse((boolean)new StringArrayFieldReader().isNull((Memory)this.memory, 1L));
    }

    @Test
    public void test_isNull_nullRow() {
        this.writeToMemory(null);
        Assert.assertTrue((boolean)new StringFieldReader().isNull((Memory)this.memory, 1L));
        Assert.assertTrue((boolean)new StringArrayFieldReader().isNull((Memory)this.memory, 1L));
    }

    @Test
    public void test_isNull_emptyString() {
        this.writeToMemory(Collections.singletonList(""));
        Assert.assertFalse((boolean)new StringFieldReader().isNull((Memory)this.memory, 1L));
        Assert.assertFalse((boolean)new StringArrayFieldReader().isNull((Memory)this.memory, 1L));
    }

    @Test
    public void test_isNull_aValue() {
        this.writeToMemory(Collections.singletonList("foo"));
        Assert.assertFalse((boolean)new StringFieldReader().isNull((Memory)this.memory, 1L));
        Assert.assertFalse((boolean)new StringArrayFieldReader().isNull((Memory)this.memory, 1L));
    }

    @Test
    public void test_isNull_multiString() {
        this.writeToMemory((List<String>)ImmutableList.of((Object)"foo", (Object)"bar"));
        Assert.assertFalse((boolean)new StringFieldReader().isNull((Memory)this.memory, 1L));
        Assert.assertFalse((boolean)new StringArrayFieldReader().isNull((Memory)this.memory, 1L));
    }

    @Test
    public void test_isNull_multiStringIncludingNulls() {
        this.writeToMemory(Arrays.asList(null, "bar"));
        Assert.assertFalse((boolean)new StringFieldReader().isNull((Memory)this.memory, 1L));
        Assert.assertFalse((boolean)new StringArrayFieldReader().isNull((Memory)this.memory, 1L));
    }

    @Test
    public void test_makeColumnValueSelector_singleString_notArray() {
        this.writeToMemory(Collections.singletonList("foo"));
        ColumnValueSelector readSelector = new StringFieldReader().makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L, -1L));
        ColumnValueSelector readSelectorAsArray = new StringArrayFieldReader().makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L, -1L));
        Assert.assertEquals((Object)"foo", (Object)readSelector.getObject());
        Assert.assertArrayEquals((Object[])new Object[]{"foo"}, (Object[])((Object[])readSelectorAsArray.getObject()));
    }

    @Test
    public void test_makeColumnValueSelector_multiString() {
        this.writeToMemory((List<String>)ImmutableList.of((Object)"foo", (Object)"bar"));
        ColumnValueSelector readSelector = new StringFieldReader().makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L, -1L));
        ColumnValueSelector readSelectorAsArray = new StringArrayFieldReader().makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L, -1L));
        Assert.assertEquals((Object)ImmutableList.of((Object)"foo", (Object)"bar"), (Object)readSelector.getObject());
        Assert.assertArrayEquals((Object[])new Object[]{"foo", "bar"}, (Object[])((Object[])readSelectorAsArray.getObject()));
    }

    @Test
    public void test_makeColumnValueSelector_null() {
        this.writeToMemory(Collections.singletonList(null));
        ColumnValueSelector readSelector = new StringFieldReader().makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L, -1L));
        ColumnValueSelector readSelectorAsArray = new StringArrayFieldReader().makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L, -1L));
        Assert.assertNull((Object)readSelector.getObject());
        Assert.assertArrayEquals((Object[])new Object[]{null}, (Object[])((Object[])readSelectorAsArray.getObject()));
    }

    @Test
    public void test_makeColumnValueSelector_empty() {
        this.writeToMemory(Collections.emptyList());
        ColumnValueSelector readSelector = new StringFieldReader().makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L, -1L));
        ColumnValueSelector readSelectorAsArray = new StringArrayFieldReader().makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L, -1L));
        Assert.assertNull((Object)readSelector.getObject());
        Assert.assertArrayEquals((Object[])ObjectArrays.EMPTY_ARRAY, (Object[])((Object[])readSelectorAsArray.getObject()));
    }

    @Test
    public void test_makeDimensionSelector_multiString_asArray() {
        this.writeToMemory((List<String>)ImmutableList.of((Object)"foo", (Object)"bar"));
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> new StringArrayFieldReader().makeDimensionSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L, -1L), null));
        MatcherAssert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Cannot call makeDimensionSelector")));
    }

    @Test
    public void test_makeDimensionSelector_multiString() {
        this.writeToMemory((List<String>)ImmutableList.of((Object)"foo", (Object)"bar"));
        DimensionSelector readSelector = new StringFieldReader().makeDimensionSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L, -1L), null);
        IndexedInts row = readSelector.getRow();
        Assert.assertEquals((long)2L, (long)row.size());
        Assert.assertEquals((Object)"foo", (Object)readSelector.lookupName(0));
        Assert.assertEquals((Object)"bar", (Object)readSelector.lookupName(1));
        Assert.assertEquals((Object)StringUtils.toUtf8ByteBuffer((String)"foo"), (Object)readSelector.lookupNameUtf8(0));
        Assert.assertEquals((Object)StringUtils.toUtf8ByteBuffer((String)"bar"), (Object)readSelector.lookupNameUtf8(1));
        Assert.assertTrue((boolean)readSelector.supportsLookupNameUtf8());
        Assert.assertFalse((boolean)readSelector.nameLookupPossibleInAdvance());
        Assert.assertEquals((long)-1L, (long)readSelector.getValueCardinality());
        Assert.assertEquals(Object.class, (Object)readSelector.classOfObject());
        Assert.assertNull((Object)readSelector.idLookup());
        Assert.assertTrue((boolean)readSelector.makeValueMatcher("bar").matches(false));
        Assert.assertFalse((boolean)readSelector.makeValueMatcher("baz").matches(false));
        Assert.assertTrue((boolean)readSelector.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.equalTo((String)"bar")).matches(false));
        Assert.assertFalse((boolean)readSelector.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.equalTo((String)"baz")).matches(false));
    }

    @Test
    public void test_makeDimensionSelector_multiString_withExtractionFn() {
        this.writeToMemory((List<String>)ImmutableList.of((Object)"foo", (Object)"bar"));
        DimensionSelector readSelector = new StringFieldReader().makeDimensionSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L, -1L), (ExtractionFn)new SubstringDimExtractionFn(1, null));
        IndexedInts row = readSelector.getRow();
        Assert.assertEquals((long)2L, (long)row.size());
        Assert.assertEquals((Object)"oo", (Object)readSelector.lookupName(0));
        Assert.assertEquals((Object)"ar", (Object)readSelector.lookupName(1));
        Assert.assertFalse((boolean)readSelector.supportsLookupNameUtf8());
        Assert.assertFalse((boolean)readSelector.nameLookupPossibleInAdvance());
        Assert.assertEquals((long)-1L, (long)readSelector.getValueCardinality());
        Assert.assertEquals(Object.class, (Object)readSelector.classOfObject());
        Assert.assertNull((Object)readSelector.idLookup());
        Assert.assertTrue((boolean)readSelector.makeValueMatcher("ar").matches(false));
        Assert.assertFalse((boolean)readSelector.makeValueMatcher("bar").matches(false));
        Assert.assertTrue((boolean)readSelector.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.equalTo((String)"ar")).matches(false));
        Assert.assertFalse((boolean)readSelector.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.equalTo((String)"bar")).matches(false));
    }

    private void writeToMemory(@Nullable List<String> values) {
        Object[] arr = values == null ? null : values.toArray();
        Mockito.when((Object)((Object[])this.writeSelector.getObject())).thenReturn((Object)arr);
        if (this.fieldWriter.writeTo(this.memory, 1L, this.memory.getCapacity() - 1L) < 0L) {
            throw new ISE("Could not write", new Object[0]);
        }
    }
}

