/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.key;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.field.FieldReaders;
import org.apache.druid.frame.key.ByteRowKeyComparatorTest;
import org.apache.druid.frame.key.FrameComparisonWidget;
import org.apache.druid.frame.key.FrameComparisonWidgetImpl;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.key.KeyOrder;
import org.apache.druid.frame.key.KeyTestUtils;
import org.apache.druid.frame.key.RowKey;
import org.apache.druid.frame.testutil.FrameSequenceBuilder;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.RowBasedSegment;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FrameComparisonWidgetImplTest
extends InitializedNullHandlingTest {
    private Frame frameWithoutComplexColumns;
    private Frame frameWithComplexColumns;

    @Before
    public void setUp() {
        CursorFactory rowBasedAdapterWithoutComplexColumn = (CursorFactory)new RowBasedSegment(Sequences.simple(ByteRowKeyComparatorTest.KEY_OBJECTS_WITHOUT_COMPLEX_COLUMN), columnName -> {
            int idx = ByteRowKeyComparatorTest.NO_COMPLEX_SIGNATURE.getColumnNames().indexOf(columnName);
            if (idx < 0) {
                return row -> null;
            }
            return row -> row[idx];
        }, ByteRowKeyComparatorTest.NO_COMPLEX_SIGNATURE).as(CursorFactory.class);
        this.frameWithoutComplexColumns = (Frame)Iterables.getOnlyElement((Iterable)FrameSequenceBuilder.fromCursorFactory(rowBasedAdapterWithoutComplexColumn).frameType(FrameType.latestRowBased()).frames().toList());
        CursorFactory rowBasedAdapterWithComplexColumn = (CursorFactory)new RowBasedSegment(Sequences.simple(ByteRowKeyComparatorTest.ALL_KEY_OBJECTS), columnName -> {
            int idx = ByteRowKeyComparatorTest.SIGNATURE.getColumnNames().indexOf(columnName);
            if (idx < 0) {
                return row -> null;
            }
            return row -> row[idx];
        }, ByteRowKeyComparatorTest.SIGNATURE).as(CursorFactory.class);
        this.frameWithComplexColumns = (Frame)Iterables.getOnlyElement((Iterable)FrameSequenceBuilder.fromCursorFactory(rowBasedAdapterWithComplexColumn).frameType(FrameType.latestRowBased()).frames().toList());
    }

    @Test
    public void test_noComplexColumns_isPartiallyNullKey_someColumns() {
        ImmutableList keyColumns = ImmutableList.of((Object)new KeyColumn("1", KeyOrder.ASCENDING), (Object)new KeyColumn("2", KeyOrder.ASCENDING), (Object)new KeyColumn("3", KeyOrder.ASCENDING));
        FrameComparisonWidget widget = this.createComparisonWidget(this.frameWithoutComplexColumns, (List<KeyColumn>)keyColumns, ByteRowKeyComparatorTest.NO_COMPLEX_SIGNATURE);
        for (int i = 0; i < this.frameWithoutComplexColumns.numRows(); ++i) {
            boolean isAllNonNull = Arrays.stream(ByteRowKeyComparatorTest.KEY_OBJECTS_WITHOUT_COMPLEX_COLUMN.get(i)).limit(3L).allMatch(Objects::nonNull);
            Assert.assertTrue((boolean)widget.hasNonNullKeyParts(i, new int[0]));
            Assert.assertTrue((boolean)widget.hasNonNullKeyParts(i, new int[]{0, 2}));
            Assert.assertEquals((Object)isAllNonNull, (Object)widget.hasNonNullKeyParts(i, new int[]{0, 1, 2}));
            Assert.assertEquals((Object)isAllNonNull, (Object)widget.hasNonNullKeyParts(i, new int[]{1}));
        }
    }

    @Test
    public void test_noComplexColumns_isPartiallyNullKey_allColumns() {
        ImmutableList keyColumns = ImmutableList.of((Object)new KeyColumn("1", KeyOrder.ASCENDING), (Object)new KeyColumn("2", KeyOrder.ASCENDING), (Object)new KeyColumn("3", KeyOrder.ASCENDING), (Object)new KeyColumn("4", KeyOrder.ASCENDING));
        FrameComparisonWidget widget = this.createComparisonWidget(this.frameWithoutComplexColumns, (List<KeyColumn>)keyColumns, ByteRowKeyComparatorTest.NO_COMPLEX_SIGNATURE);
        for (int i = 0; i < this.frameWithoutComplexColumns.numRows(); ++i) {
            boolean isAllNonNull = Arrays.stream(ByteRowKeyComparatorTest.KEY_OBJECTS_WITHOUT_COMPLEX_COLUMN.get(i)).allMatch(Objects::nonNull);
            Assert.assertEquals((Object)isAllNonNull, (Object)widget.hasNonNullKeyParts(i, new int[]{0, 1, 2, 3}));
        }
    }

    @Test
    public void test_noComplexColumns_readKey_someColumns() {
        ImmutableList keyColumns = ImmutableList.of((Object)new KeyColumn("1", KeyOrder.ASCENDING), (Object)new KeyColumn("2", KeyOrder.ASCENDING), (Object)new KeyColumn("3", KeyOrder.ASCENDING));
        FrameComparisonWidget widget = this.createComparisonWidget(this.frameWithoutComplexColumns, (List<KeyColumn>)keyColumns, ByteRowKeyComparatorTest.NO_COMPLEX_SIGNATURE);
        RowSignature signature = RowSignature.builder().add("1", (ColumnType)ByteRowKeyComparatorTest.NO_COMPLEX_SIGNATURE.getColumnType("1").orElse(null)).add("2", (ColumnType)ByteRowKeyComparatorTest.NO_COMPLEX_SIGNATURE.getColumnType("2").orElse(null)).add("3", (ColumnType)ByteRowKeyComparatorTest.NO_COMPLEX_SIGNATURE.getColumnType("3").orElse(null)).build();
        for (int i = 0; i < this.frameWithoutComplexColumns.numRows(); ++i) {
            Object[] expectedKeyArray = new Object[keyColumns.size()];
            System.arraycopy(ByteRowKeyComparatorTest.KEY_OBJECTS_WITHOUT_COMPLEX_COLUMN.get(i), 0, expectedKeyArray, 0, keyColumns.size());
            Assert.assertEquals((Object)KeyTestUtils.createKey(signature, FrameType.latestRowBased(), expectedKeyArray), (Object)widget.readKey(i));
        }
    }

    @Test
    public void test_noComplexColumns_readKey_allColumns() {
        ImmutableList keyColumns = ImmutableList.of((Object)new KeyColumn("1", KeyOrder.ASCENDING), (Object)new KeyColumn("2", KeyOrder.ASCENDING), (Object)new KeyColumn("3", KeyOrder.ASCENDING), (Object)new KeyColumn("4", KeyOrder.ASCENDING));
        FrameComparisonWidget widget = this.createComparisonWidget(this.frameWithoutComplexColumns, (List<KeyColumn>)keyColumns, ByteRowKeyComparatorTest.NO_COMPLEX_SIGNATURE);
        for (int i = 0; i < this.frameWithoutComplexColumns.numRows(); ++i) {
            Assert.assertEquals((Object)KeyTestUtils.createKey(ByteRowKeyComparatorTest.NO_COMPLEX_SIGNATURE, FrameType.latestRowBased(), ByteRowKeyComparatorTest.KEY_OBJECTS_WITHOUT_COMPLEX_COLUMN.get(i)), (Object)widget.readKey(i));
        }
    }

    @Test
    public void test_noComplexColumns_compare_frameToKey() {
        ImmutableList keyColumns = ImmutableList.of((Object)new KeyColumn("1", KeyOrder.ASCENDING), (Object)new KeyColumn("2", KeyOrder.ASCENDING), (Object)new KeyColumn("3", KeyOrder.ASCENDING), (Object)new KeyColumn("4", KeyOrder.ASCENDING));
        FrameComparisonWidget widget = this.createComparisonWidget(this.frameWithoutComplexColumns, (List<KeyColumn>)keyColumns, ByteRowKeyComparatorTest.NO_COMPLEX_SIGNATURE);
        for (int i = 0; i < this.frameWithoutComplexColumns.numRows(); ++i) {
            Assert.assertEquals((long)0L, (long)widget.compare(i, KeyTestUtils.createKey(ByteRowKeyComparatorTest.NO_COMPLEX_SIGNATURE, FrameType.latestRowBased(), ByteRowKeyComparatorTest.KEY_OBJECTS_WITHOUT_COMPLEX_COLUMN.get(i))));
        }
        RowKey firstKey = KeyTestUtils.createKey(ByteRowKeyComparatorTest.NO_COMPLEX_SIGNATURE, FrameType.latestRowBased(), ByteRowKeyComparatorTest.KEY_OBJECTS_WITHOUT_COMPLEX_COLUMN.get(0));
        MatcherAssert.assertThat((Object)widget.compare(0, firstKey), (Matcher)Matchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)widget.compare(1, firstKey), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)widget.compare(2, firstKey), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)widget.compare(3, firstKey), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)widget.compare(4, firstKey), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)widget.compare(5, firstKey), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)widget.compare(6, firstKey), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void test_isPartiallyNullKey_someColumns() {
        ImmutableList keyColumns = ImmutableList.of((Object)new KeyColumn("1", KeyOrder.ASCENDING), (Object)new KeyColumn("2", KeyOrder.ASCENDING), (Object)new KeyColumn("3", KeyOrder.ASCENDING));
        FrameComparisonWidget widget = this.createComparisonWidget(this.frameWithComplexColumns, (List<KeyColumn>)keyColumns, ByteRowKeyComparatorTest.SIGNATURE);
        for (int i = 0; i < this.frameWithComplexColumns.numRows(); ++i) {
            boolean isAllNonNull = Arrays.stream(ByteRowKeyComparatorTest.ALL_KEY_OBJECTS.get(i)).limit(3L).allMatch(Objects::nonNull);
            Assert.assertTrue((boolean)widget.hasNonNullKeyParts(i, new int[]{1}));
            Assert.assertTrue((boolean)widget.hasNonNullKeyParts(i, new int[]{1}));
            Assert.assertEquals((Object)isAllNonNull, (Object)widget.hasNonNullKeyParts(i, new int[]{0, 1, 2}));
            Assert.assertEquals((Object)isAllNonNull, (Object)(widget.hasNonNullKeyParts(i, new int[]{0}) && widget.hasNonNullKeyParts(i, new int[]{2}) ? 1 : 0));
        }
    }

    @Test
    public void test_isPartiallyNullKey_allColumns() {
        ImmutableList keyColumns = ImmutableList.of((Object)new KeyColumn("1", KeyOrder.ASCENDING), (Object)new KeyColumn("2", KeyOrder.ASCENDING), (Object)new KeyColumn("3", KeyOrder.ASCENDING), (Object)new KeyColumn("4", KeyOrder.ASCENDING), (Object)new KeyColumn("5", KeyOrder.ASCENDING), (Object)new KeyColumn("6", KeyOrder.ASCENDING), (Object)new KeyColumn("7", KeyOrder.ASCENDING), (Object)new KeyColumn("8", KeyOrder.ASCENDING));
        FrameComparisonWidget widget = this.createComparisonWidget(this.frameWithComplexColumns, (List<KeyColumn>)keyColumns, ByteRowKeyComparatorTest.SIGNATURE);
        for (int i = 0; i < this.frameWithoutComplexColumns.numRows(); ++i) {
            boolean isAllNonNull = Arrays.stream(ByteRowKeyComparatorTest.ALL_KEY_OBJECTS.get(i)).allMatch(Objects::nonNull);
            Assert.assertEquals((Object)isAllNonNull, (Object)widget.hasNonNullKeyParts(i, new int[]{0, 1, 2, 3, 4, 5, 6, 7}));
        }
    }

    @Test
    public void test_readKey_someColumns() {
        ImmutableList keyColumns = ImmutableList.of((Object)new KeyColumn("1", KeyOrder.ASCENDING), (Object)new KeyColumn("2", KeyOrder.ASCENDING), (Object)new KeyColumn("3", KeyOrder.ASCENDING));
        FrameComparisonWidget widget = this.createComparisonWidget(this.frameWithComplexColumns, (List<KeyColumn>)keyColumns, ByteRowKeyComparatorTest.SIGNATURE);
        RowSignature signature = RowSignature.builder().add("1", (ColumnType)ByteRowKeyComparatorTest.SIGNATURE.getColumnType("1").orElse(null)).add("2", (ColumnType)ByteRowKeyComparatorTest.SIGNATURE.getColumnType("2").orElse(null)).add("3", (ColumnType)ByteRowKeyComparatorTest.SIGNATURE.getColumnType("3").orElse(null)).build();
        for (int i = 0; i < this.frameWithComplexColumns.numRows(); ++i) {
            Object[] expectedKeyArray = new Object[keyColumns.size()];
            System.arraycopy(ByteRowKeyComparatorTest.ALL_KEY_OBJECTS.get(i), 0, expectedKeyArray, 0, keyColumns.size());
            Assert.assertEquals((Object)KeyTestUtils.createKey(signature, FrameType.latestRowBased(), expectedKeyArray), (Object)widget.readKey(i));
        }
    }

    @Test
    public void test_readKey_allColumns() {
        ImmutableList keyColumns = ImmutableList.of((Object)new KeyColumn("1", KeyOrder.ASCENDING), (Object)new KeyColumn("2", KeyOrder.ASCENDING), (Object)new KeyColumn("3", KeyOrder.ASCENDING), (Object)new KeyColumn("4", KeyOrder.ASCENDING), (Object)new KeyColumn("5", KeyOrder.ASCENDING), (Object)new KeyColumn("6", KeyOrder.ASCENDING), (Object)new KeyColumn("7", KeyOrder.ASCENDING), (Object)new KeyColumn("8", KeyOrder.ASCENDING));
        FrameComparisonWidget widget = this.createComparisonWidget(this.frameWithComplexColumns, (List<KeyColumn>)keyColumns, ByteRowKeyComparatorTest.SIGNATURE);
        for (int i = 0; i < this.frameWithComplexColumns.numRows(); ++i) {
            Assert.assertEquals((Object)KeyTestUtils.createKey(ByteRowKeyComparatorTest.SIGNATURE, FrameType.latestRowBased(), ByteRowKeyComparatorTest.ALL_KEY_OBJECTS.get(i)), (Object)widget.readKey(i));
        }
    }

    @Test
    public void test_compare_frameToKey() {
        ImmutableList keyColumns = ImmutableList.of((Object)new KeyColumn("1", KeyOrder.ASCENDING), (Object)new KeyColumn("2", KeyOrder.ASCENDING), (Object)new KeyColumn("3", KeyOrder.ASCENDING), (Object)new KeyColumn("4", KeyOrder.ASCENDING), (Object)new KeyColumn("5", KeyOrder.ASCENDING), (Object)new KeyColumn("6", KeyOrder.ASCENDING), (Object)new KeyColumn("7", KeyOrder.ASCENDING), (Object)new KeyColumn("8", KeyOrder.ASCENDING));
        FrameComparisonWidget widget = this.createComparisonWidget(this.frameWithComplexColumns, (List<KeyColumn>)keyColumns, ByteRowKeyComparatorTest.SIGNATURE);
        for (int i = 0; i < this.frameWithComplexColumns.numRows(); ++i) {
            Assert.assertEquals((long)0L, (long)widget.compare(i, KeyTestUtils.createKey(ByteRowKeyComparatorTest.SIGNATURE, FrameType.latestRowBased(), ByteRowKeyComparatorTest.ALL_KEY_OBJECTS.get(i))));
        }
        RowKey firstKey = KeyTestUtils.createKey(ByteRowKeyComparatorTest.SIGNATURE, FrameType.latestRowBased(), ByteRowKeyComparatorTest.ALL_KEY_OBJECTS.get(0));
        MatcherAssert.assertThat((Object)widget.compare(0, firstKey), (Matcher)Matchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)widget.compare(1, firstKey), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)widget.compare(2, firstKey), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)widget.compare(3, firstKey), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)widget.compare(4, firstKey), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)widget.compare(5, firstKey), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)widget.compare(6, firstKey), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)widget.compare(7, firstKey), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)widget.compare(8, firstKey), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        RowKey eighthKey = KeyTestUtils.createKey(ByteRowKeyComparatorTest.SIGNATURE, FrameType.latestRowBased(), ByteRowKeyComparatorTest.ALL_KEY_OBJECTS.get(7));
        MatcherAssert.assertThat((Object)widget.compare(8, eighthKey), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
    }

    private FrameComparisonWidget createComparisonWidget(Frame frame, List<KeyColumn> keyColumns, RowSignature rowSignature) {
        return FrameComparisonWidgetImpl.create((Frame)frame, (RowSignature)rowSignature, keyColumns, keyColumns.stream().map(keyColumn -> FieldReaders.create((String)keyColumn.columnName(), (ColumnType)((ColumnType)rowSignature.getColumnType(keyColumn.columnName()).get()), (FrameType)FrameType.latestRowBased())).collect(Collectors.toList()));
    }
}

