/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.key;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.key.ByteRowKeyComparatorTest;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.key.KeyOrder;
import org.apache.druid.frame.key.KeyTestUtils;
import org.apache.druid.frame.key.RowKey;
import org.apache.druid.frame.key.RowKeyComparator;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesSerde;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetrics;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class RowKeyComparatorTest
extends InitializedNullHandlingTest {
    @Test
    public void test_compare_AAAA_without_complex_column() {
        ImmutableList keyColumns = ImmutableList.of((Object)new KeyColumn("1", KeyOrder.DESCENDING), (Object)new KeyColumn("2", KeyOrder.DESCENDING), (Object)new KeyColumn("3", KeyOrder.DESCENDING), (Object)new KeyColumn("4", KeyOrder.DESCENDING));
        Assert.assertEquals(RowKeyComparatorTest.sortUsingObjectComparator((List<KeyColumn>)keyColumns, ByteRowKeyComparatorTest.KEY_OBJECTS_WITHOUT_COMPLEX_COLUMN, ByteRowKeyComparatorTest.NO_COMPLEX_SIGNATURE), RowKeyComparatorTest.sortUsingKeyComparator((List<KeyColumn>)keyColumns, ByteRowKeyComparatorTest.KEY_OBJECTS_WITHOUT_COMPLEX_COLUMN, ByteRowKeyComparatorTest.NO_COMPLEX_SIGNATURE));
    }

    @Test
    public void test_compare_DDDD_without_complex_column() {
        ImmutableList keyColumns = ImmutableList.of((Object)new KeyColumn("1", KeyOrder.ASCENDING), (Object)new KeyColumn("2", KeyOrder.ASCENDING), (Object)new KeyColumn("3", KeyOrder.ASCENDING), (Object)new KeyColumn("4", KeyOrder.ASCENDING));
        Assert.assertEquals(RowKeyComparatorTest.sortUsingObjectComparator((List<KeyColumn>)keyColumns, ByteRowKeyComparatorTest.KEY_OBJECTS_WITHOUT_COMPLEX_COLUMN, ByteRowKeyComparatorTest.NO_COMPLEX_SIGNATURE), RowKeyComparatorTest.sortUsingKeyComparator((List<KeyColumn>)keyColumns, ByteRowKeyComparatorTest.KEY_OBJECTS_WITHOUT_COMPLEX_COLUMN, ByteRowKeyComparatorTest.NO_COMPLEX_SIGNATURE));
    }

    @Test
    public void test_compare_DAAD_without_complex_column() {
        ImmutableList keyColumns = ImmutableList.of((Object)new KeyColumn("1", KeyOrder.ASCENDING), (Object)new KeyColumn("2", KeyOrder.DESCENDING), (Object)new KeyColumn("3", KeyOrder.DESCENDING), (Object)new KeyColumn("4", KeyOrder.ASCENDING));
        Assert.assertEquals(RowKeyComparatorTest.sortUsingObjectComparator((List<KeyColumn>)keyColumns, ByteRowKeyComparatorTest.KEY_OBJECTS_WITHOUT_COMPLEX_COLUMN, ByteRowKeyComparatorTest.NO_COMPLEX_SIGNATURE), RowKeyComparatorTest.sortUsingKeyComparator((List<KeyColumn>)keyColumns, ByteRowKeyComparatorTest.KEY_OBJECTS_WITHOUT_COMPLEX_COLUMN, ByteRowKeyComparatorTest.NO_COMPLEX_SIGNATURE));
    }

    @Test
    public void test_compare_ADDA_without_complex_column() {
        ImmutableList keyColumns = ImmutableList.of((Object)new KeyColumn("1", KeyOrder.DESCENDING), (Object)new KeyColumn("2", KeyOrder.ASCENDING), (Object)new KeyColumn("3", KeyOrder.ASCENDING), (Object)new KeyColumn("4", KeyOrder.DESCENDING));
        Assert.assertEquals(RowKeyComparatorTest.sortUsingObjectComparator((List<KeyColumn>)keyColumns, ByteRowKeyComparatorTest.KEY_OBJECTS_WITHOUT_COMPLEX_COLUMN, ByteRowKeyComparatorTest.NO_COMPLEX_SIGNATURE), RowKeyComparatorTest.sortUsingKeyComparator((List<KeyColumn>)keyColumns, ByteRowKeyComparatorTest.KEY_OBJECTS_WITHOUT_COMPLEX_COLUMN, ByteRowKeyComparatorTest.NO_COMPLEX_SIGNATURE));
    }

    @Test
    public void test_compare_DADA_without_complex_column() {
        ImmutableList keyColumns = ImmutableList.of((Object)new KeyColumn("1", KeyOrder.DESCENDING), (Object)new KeyColumn("2", KeyOrder.ASCENDING), (Object)new KeyColumn("3", KeyOrder.DESCENDING), (Object)new KeyColumn("4", KeyOrder.ASCENDING));
        Assert.assertEquals(RowKeyComparatorTest.sortUsingObjectComparator((List<KeyColumn>)keyColumns, ByteRowKeyComparatorTest.KEY_OBJECTS_WITHOUT_COMPLEX_COLUMN, ByteRowKeyComparatorTest.NO_COMPLEX_SIGNATURE), RowKeyComparatorTest.sortUsingKeyComparator((List<KeyColumn>)keyColumns, ByteRowKeyComparatorTest.KEY_OBJECTS_WITHOUT_COMPLEX_COLUMN, ByteRowKeyComparatorTest.NO_COMPLEX_SIGNATURE));
    }

    @Test
    public void test_compare_DDDDDDDD() {
        ImmutableList keyColumns = ImmutableList.of((Object)new KeyColumn("1", KeyOrder.DESCENDING), (Object)new KeyColumn("2", KeyOrder.DESCENDING), (Object)new KeyColumn("3", KeyOrder.DESCENDING), (Object)new KeyColumn("4", KeyOrder.DESCENDING), (Object)new KeyColumn("5", KeyOrder.DESCENDING), (Object)new KeyColumn("6", KeyOrder.DESCENDING), (Object)new KeyColumn("7", KeyOrder.DESCENDING), (Object)new KeyColumn("8", KeyOrder.DESCENDING));
        Assert.assertEquals(RowKeyComparatorTest.sortUsingObjectComparator((List<KeyColumn>)keyColumns, ByteRowKeyComparatorTest.ALL_KEY_OBJECTS, ByteRowKeyComparatorTest.SIGNATURE), RowKeyComparatorTest.sortUsingKeyComparator((List<KeyColumn>)keyColumns, ByteRowKeyComparatorTest.ALL_KEY_OBJECTS, ByteRowKeyComparatorTest.SIGNATURE));
    }

    @Test
    public void test_compare_AAAAAAAA() {
        ImmutableList keyColumns = ImmutableList.of((Object)new KeyColumn("1", KeyOrder.ASCENDING), (Object)new KeyColumn("2", KeyOrder.ASCENDING), (Object)new KeyColumn("3", KeyOrder.ASCENDING), (Object)new KeyColumn("4", KeyOrder.ASCENDING), (Object)new KeyColumn("5", KeyOrder.ASCENDING), (Object)new KeyColumn("6", KeyOrder.ASCENDING), (Object)new KeyColumn("7", KeyOrder.ASCENDING), (Object)new KeyColumn("8", KeyOrder.ASCENDING));
        Assert.assertEquals(RowKeyComparatorTest.sortUsingObjectComparator((List<KeyColumn>)keyColumns, ByteRowKeyComparatorTest.ALL_KEY_OBJECTS, ByteRowKeyComparatorTest.SIGNATURE), RowKeyComparatorTest.sortUsingKeyComparator((List<KeyColumn>)keyColumns, ByteRowKeyComparatorTest.ALL_KEY_OBJECTS, ByteRowKeyComparatorTest.SIGNATURE));
    }

    @Test
    public void test_compare_ADDADDAA() {
        ImmutableList keyColumns = ImmutableList.of((Object)new KeyColumn("1", KeyOrder.ASCENDING), (Object)new KeyColumn("2", KeyOrder.DESCENDING), (Object)new KeyColumn("3", KeyOrder.DESCENDING), (Object)new KeyColumn("4", KeyOrder.ASCENDING), (Object)new KeyColumn("5", KeyOrder.DESCENDING), (Object)new KeyColumn("6", KeyOrder.DESCENDING), (Object)new KeyColumn("7", KeyOrder.ASCENDING), (Object)new KeyColumn("8", KeyOrder.ASCENDING));
        Assert.assertEquals(RowKeyComparatorTest.sortUsingObjectComparator((List<KeyColumn>)keyColumns, ByteRowKeyComparatorTest.ALL_KEY_OBJECTS, ByteRowKeyComparatorTest.SIGNATURE), RowKeyComparatorTest.sortUsingKeyComparator((List<KeyColumn>)keyColumns, ByteRowKeyComparatorTest.ALL_KEY_OBJECTS, ByteRowKeyComparatorTest.SIGNATURE));
    }

    @Test
    public void test_compare_DAADAADD() {
        ImmutableList keyColumns = ImmutableList.of((Object)new KeyColumn("1", KeyOrder.DESCENDING), (Object)new KeyColumn("2", KeyOrder.ASCENDING), (Object)new KeyColumn("3", KeyOrder.ASCENDING), (Object)new KeyColumn("4", KeyOrder.DESCENDING), (Object)new KeyColumn("5", KeyOrder.ASCENDING), (Object)new KeyColumn("6", KeyOrder.ASCENDING), (Object)new KeyColumn("7", KeyOrder.DESCENDING), (Object)new KeyColumn("8", KeyOrder.DESCENDING));
        Assert.assertEquals(RowKeyComparatorTest.sortUsingObjectComparator((List<KeyColumn>)keyColumns, ByteRowKeyComparatorTest.ALL_KEY_OBJECTS, ByteRowKeyComparatorTest.SIGNATURE), RowKeyComparatorTest.sortUsingKeyComparator((List<KeyColumn>)keyColumns, ByteRowKeyComparatorTest.ALL_KEY_OBJECTS, ByteRowKeyComparatorTest.SIGNATURE));
    }

    @Test
    public void test_compare_DADADADA() {
        ImmutableList keyColumns = ImmutableList.of((Object)new KeyColumn("1", KeyOrder.DESCENDING), (Object)new KeyColumn("2", KeyOrder.ASCENDING), (Object)new KeyColumn("3", KeyOrder.DESCENDING), (Object)new KeyColumn("4", KeyOrder.ASCENDING), (Object)new KeyColumn("5", KeyOrder.DESCENDING), (Object)new KeyColumn("6", KeyOrder.ASCENDING), (Object)new KeyColumn("7", KeyOrder.DESCENDING), (Object)new KeyColumn("8", KeyOrder.ASCENDING));
        Assert.assertEquals(RowKeyComparatorTest.sortUsingObjectComparator((List<KeyColumn>)keyColumns, ByteRowKeyComparatorTest.ALL_KEY_OBJECTS, ByteRowKeyComparatorTest.SIGNATURE), RowKeyComparatorTest.sortUsingKeyComparator((List<KeyColumn>)keyColumns, ByteRowKeyComparatorTest.ALL_KEY_OBJECTS, ByteRowKeyComparatorTest.SIGNATURE));
    }

    @Test
    public void test_equals() {
        EqualsVerifier.forClass(RowKeyComparator.class).withNonnullFields(new String[]{"byteRowKeyComparatorDelegate"}).usingGetClass().verify();
    }

    private static List<RowKey> sortUsingKeyComparator(List<KeyColumn> keyColumns, List<Object[]> objectss, RowSignature rowSignature) {
        ArrayList<RowKey> sortedKeys = new ArrayList<RowKey>();
        for (Object[] objects : objectss) {
            sortedKeys.add(KeyTestUtils.createKey(rowSignature, FrameType.latestRowBased(), objects));
        }
        sortedKeys.sort((Comparator<RowKey>)RowKeyComparator.create(keyColumns, (RowSignature)rowSignature));
        return sortedKeys;
    }

    private static List<RowKey> sortUsingObjectComparator(List<KeyColumn> keyColumns, List<Object[]> objectss, RowSignature rowSignature) {
        List sortedObjectssCopy = objectss.stream().sorted((o1, o2) -> {
            for (int i = 0; i < keyColumns.size(); ++i) {
                KeyColumn keyColumn = (KeyColumn)keyColumns.get(i);
                int cmp = Comparators.naturalNullsFirst().compare((Object)((Comparable)o1[i]), (Object)((Comparable)o2[i]));
                if (cmp == 0) continue;
                return keyColumn.order() == KeyOrder.DESCENDING ? -cmp : cmp;
            }
            return 0;
        }).collect(Collectors.toList());
        ArrayList<RowKey> sortedKeys = new ArrayList<RowKey>();
        for (Object[] objects : sortedObjectssCopy) {
            sortedKeys.add(KeyTestUtils.createKey(rowSignature, FrameType.latestRowBased(), objects));
        }
        return sortedKeys;
    }

    static {
        ComplexMetrics.registerSerde((String)"hyperUnique", (ComplexMetricSerde)new HyperUniquesSerde());
    }
}

