/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.druid.frame.processor.Bouncer;
import org.junit.Assert;
import org.junit.Test;

public class BouncerTest {
    @Test
    public void testBouncerWithoutParent() throws ExecutionException, InterruptedException {
        Bouncer bouncer = new Bouncer(2);
        Assert.assertEquals((long)2L, (long)bouncer.getMaxCount());
        Assert.assertEquals((long)0L, (long)bouncer.getCurrentCount());
        ListenableFuture future1 = bouncer.ticket();
        Assert.assertTrue((boolean)future1.isDone());
        Bouncer.Ticket ticket1 = (Bouncer.Ticket)future1.get();
        Assert.assertEquals((long)1L, (long)bouncer.getCurrentCount());
        ListenableFuture future2 = bouncer.ticket();
        Assert.assertTrue((boolean)future2.isDone());
        Bouncer.Ticket ticket2 = (Bouncer.Ticket)future2.get();
        Assert.assertEquals((long)2L, (long)bouncer.getCurrentCount());
        ListenableFuture future3 = bouncer.ticket();
        Assert.assertFalse((boolean)future3.isDone());
        Assert.assertEquals((long)2L, (long)bouncer.getCurrentCount());
        ticket1.giveBack();
        Assert.assertEquals((long)2L, (long)bouncer.getCurrentCount());
        Assert.assertTrue((boolean)future3.isDone());
        Bouncer.Ticket ticket3 = (Bouncer.Ticket)future3.get();
        ticket2.giveBack();
        Assert.assertEquals((long)1L, (long)bouncer.getCurrentCount());
        ticket3.giveBack();
        Assert.assertEquals((long)0L, (long)bouncer.getCurrentCount());
    }

    @Test
    public void testBouncerWithParentMaxCountOne() throws ExecutionException, InterruptedException {
        Bouncer parentBouncer = new Bouncer(1);
        Bouncer bouncer = new Bouncer(2, parentBouncer);
        Assert.assertEquals((long)1L, (long)bouncer.getMaxCount());
        Assert.assertEquals((long)0L, (long)bouncer.getCurrentCount());
        Assert.assertEquals((long)0L, (long)parentBouncer.getCurrentCount());
        ListenableFuture future1 = bouncer.ticket();
        Assert.assertTrue((boolean)future1.isDone());
        Bouncer.Ticket ticket1 = (Bouncer.Ticket)future1.get();
        Assert.assertEquals((long)1L, (long)bouncer.getCurrentCount());
        Assert.assertEquals((long)1L, (long)parentBouncer.getCurrentCount());
        ListenableFuture future2 = bouncer.ticket();
        Assert.assertFalse((boolean)future2.isDone());
        Assert.assertEquals((long)2L, (long)bouncer.getCurrentCount());
        Assert.assertEquals((long)1L, (long)parentBouncer.getCurrentCount());
        ticket1.giveBack();
        Assert.assertEquals((long)1L, (long)bouncer.getCurrentCount());
        Assert.assertEquals((long)1L, (long)parentBouncer.getCurrentCount());
        Assert.assertTrue((boolean)future2.isDone());
        Bouncer.Ticket ticket2 = (Bouncer.Ticket)future2.get();
        ticket2.giveBack();
        Assert.assertEquals((long)0L, (long)bouncer.getCurrentCount());
        Assert.assertEquals((long)0L, (long)parentBouncer.getCurrentCount());
    }

    @Test
    public void testBouncerWithParentMaxCountThree() throws ExecutionException, InterruptedException {
        Bouncer parentBouncer = new Bouncer(3);
        Bouncer bouncer = new Bouncer(2, parentBouncer);
        Assert.assertEquals((long)2L, (long)bouncer.getMaxCount());
        Assert.assertEquals((long)0L, (long)bouncer.getCurrentCount());
        Assert.assertEquals((long)0L, (long)parentBouncer.getCurrentCount());
        ListenableFuture future1 = bouncer.ticket();
        Assert.assertTrue((boolean)future1.isDone());
        Bouncer.Ticket ticket1 = (Bouncer.Ticket)future1.get();
        Assert.assertEquals((long)1L, (long)bouncer.getCurrentCount());
        Assert.assertEquals((long)1L, (long)parentBouncer.getCurrentCount());
        ListenableFuture future2 = bouncer.ticket();
        Assert.assertTrue((boolean)future2.isDone());
        Bouncer.Ticket ticket2 = (Bouncer.Ticket)future2.get();
        Assert.assertEquals((long)2L, (long)bouncer.getCurrentCount());
        Assert.assertEquals((long)2L, (long)parentBouncer.getCurrentCount());
        ListenableFuture future3 = bouncer.ticket();
        Assert.assertFalse((boolean)future3.isDone());
        Assert.assertEquals((long)2L, (long)bouncer.getCurrentCount());
        Assert.assertEquals((long)2L, (long)parentBouncer.getCurrentCount());
        ticket1.giveBack();
        Assert.assertEquals((long)2L, (long)bouncer.getCurrentCount());
        Assert.assertEquals((long)2L, (long)parentBouncer.getCurrentCount());
        Assert.assertTrue((boolean)future3.isDone());
        Bouncer.Ticket ticket3 = (Bouncer.Ticket)future3.get();
        ticket2.giveBack();
        Assert.assertEquals((long)1L, (long)bouncer.getCurrentCount());
        Assert.assertEquals((long)1L, (long)parentBouncer.getCurrentCount());
        ticket3.giveBack();
        Assert.assertEquals((long)0L, (long)bouncer.getCurrentCount());
        Assert.assertEquals((long)0L, (long)parentBouncer.getCurrentCount());
    }
}

