/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.channel.ReadableFileFrameChannel;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.file.FrameFile;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.testutil.FrameSequenceBuilder;
import org.apache.druid.frame.testutil.FrameTestUtil;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.QueryableIndexCursorFactory;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ReadableFileFrameChannelTest
extends InitializedNullHandlingTest {
    private static final int ROWS_PER_FRAME = 20;
    private List<List<Object>> allRows;
    private FrameReader frameReader;
    private FrameFile frameFile;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Before
    public void setUp() throws IOException {
        QueryableIndexCursorFactory cursorFactory = new QueryableIndexCursorFactory(TestIndex.getNoRollupMMappedTestIndex());
        File file = FrameTestUtil.writeFrameFile(FrameSequenceBuilder.fromCursorFactory((CursorFactory)cursorFactory).frameType(FrameType.latestRowBased()).maxRowsPerFrame(20).frames(), this.temporaryFolder.newFile());
        this.allRows = FrameTestUtil.readRowsFromCursorFactory((CursorFactory)cursorFactory).toList();
        this.frameReader = FrameReader.create((RowSignature)cursorFactory.getRowSignature());
        this.frameFile = FrameFile.open((File)file, null, (FrameFile.Flag[])new FrameFile.Flag[]{FrameFile.Flag.DELETE_ON_CLOSE});
    }

    @After
    public void tearDown() throws Exception {
        this.frameFile.close();
    }

    @Test
    public void test_fullFile() {
        ReadableFileFrameChannel channel = new ReadableFileFrameChannel(this.frameFile);
        Assert.assertTrue((boolean)channel.isEntireFile());
        FrameTestUtil.assertRowsEqual((Sequence<List<Object>>)Sequences.simple(this.allRows), FrameTestUtil.readRowsFromFrameChannel((ReadableFrameChannel)channel, this.frameReader));
        Assert.assertFalse((boolean)channel.isEntireFile());
    }

    @Test
    public void test_partialFile() {
        ReadableFileFrameChannel channel = new ReadableFileFrameChannel(this.frameFile, 1, 2);
        Assert.assertFalse((boolean)channel.isEntireFile());
        FrameTestUtil.assertRowsEqual((Sequence<List<Object>>)Sequences.simple(this.allRows).skip(20L).limit(20L), FrameTestUtil.readRowsFromFrameChannel((ReadableFrameChannel)channel, this.frameReader));
        Assert.assertFalse((boolean)channel.isEntireFile());
    }
}

