/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor.manager;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Optional;
import org.apache.druid.frame.processor.manager.ConcurrencyLimitedProcessorManager;
import org.apache.druid.frame.processor.manager.NilFrameProcessor;
import org.apache.druid.frame.processor.manager.ProcessorAndCallback;
import org.apache.druid.frame.processor.manager.ProcessorManagers;
import org.apache.druid.java.util.common.Unit;
import org.junit.Assert;
import org.junit.Test;

public class ConcurrencyLimitedProcessorManagerTest {
    @Test
    public void test_empty() throws Exception {
        try (ConcurrencyLimitedProcessorManager manager = new ConcurrencyLimitedProcessorManager(ProcessorManagers.none(), 1);){
            ListenableFuture future = manager.next();
            Assert.assertTrue((boolean)future.isDone());
            Assert.assertFalse((boolean)((Optional)future.get()).isPresent());
            Assert.assertEquals((long)0L, (long)((Long)manager.result()));
        }
    }

    @Test
    public void test_one_limitOne() throws Exception {
        NilFrameProcessor processor = new NilFrameProcessor();
        try (ConcurrencyLimitedProcessorManager manager = new ConcurrencyLimitedProcessorManager(ProcessorManagers.of((Iterable)ImmutableList.of(processor)), 1);){
            ListenableFuture future = manager.next();
            Assert.assertTrue((boolean)future.isDone());
            Assert.assertTrue((boolean)((Optional)future.get()).isPresent());
            Assert.assertSame(processor, (Object)((ProcessorAndCallback)((Optional)future.get()).get()).processor());
            ((ProcessorAndCallback)((Optional)future.get()).get()).onComplete((Object)Unit.instance());
            future = manager.next();
            Assert.assertTrue((boolean)future.isDone());
            Assert.assertFalse((boolean)((Optional)future.get()).isPresent());
        }
    }

    @Test
    public void test_two_limitOne() throws Exception {
        NilFrameProcessor processor0 = new NilFrameProcessor();
        NilFrameProcessor processor1 = new NilFrameProcessor();
        ImmutableList processors = ImmutableList.of(processor0, processor1);
        try (ConcurrencyLimitedProcessorManager manager = new ConcurrencyLimitedProcessorManager(ProcessorManagers.of((Iterable)processors), 1);){
            ListenableFuture future0 = manager.next();
            Assert.assertTrue((boolean)future0.isDone());
            Assert.assertTrue((boolean)((Optional)future0.get()).isPresent());
            Assert.assertSame((Object)processors.get(0), (Object)((ProcessorAndCallback)((Optional)future0.get()).get()).processor());
            ListenableFuture future1 = manager.next();
            Assert.assertFalse((boolean)future1.isDone());
            ((ProcessorAndCallback)((Optional)future0.get()).get()).onComplete((Object)Unit.instance());
            Assert.assertTrue((boolean)future1.isDone());
            Assert.assertTrue((boolean)((Optional)future1.get()).isPresent());
            Assert.assertSame((Object)processors.get(1), (Object)((ProcessorAndCallback)((Optional)future1.get()).get()).processor());
            ((ProcessorAndCallback)((Optional)future1.get()).get()).onComplete((Object)Unit.instance());
            future1 = manager.next();
            Assert.assertTrue((boolean)future1.isDone());
            Assert.assertFalse((boolean)((Optional)future1.get()).isPresent());
        }
    }
}

