/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor.test;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.ReturnOrAwait;
import org.apache.druid.java.util.common.ISE;
import org.junit.Assert;

public class FutureWaitingProcessor
implements FrameProcessor<List<String>> {
    private final ListenableFuture<String> future1;
    private final ListenableFuture<String> future2;
    private int runCount = 0;
    private boolean cleanedUp;
    private final List<String> results = new ArrayList<String>();

    public FutureWaitingProcessor(ListenableFuture<String> future1, ListenableFuture<String> future2) {
        this.future1 = future1;
        this.future2 = future2;
    }

    public List<ReadableFrameChannel> inputChannels() {
        return Collections.emptyList();
    }

    public List<WritableFrameChannel> outputChannels() {
        return Collections.emptyList();
    }

    public ReturnOrAwait<List<String>> runIncrementally(IntSet readableInputs) {
        ++this.runCount;
        if (this.runCount == 1) {
            return ReturnOrAwait.awaitAllFutures((Collection)ImmutableList.of(this.future1, this.future2));
        }
        if (this.runCount == 2) {
            Assert.assertTrue((String)"future1 should be done", (boolean)this.future1.isDone());
            Assert.assertTrue((String)"future2 should be done", (boolean)this.future2.isDone());
            try {
                this.results.add((String)this.future1.get());
                this.results.add((String)this.future2.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ReturnOrAwait.returnObject(this.results);
        }
        throw new ISE("Should not run more than twice", new Object[0]);
    }

    public void cleanup() {
        this.cleanedUp = true;
    }

    public boolean isCleanedUp() {
        return this.cleanedUp;
    }
}

