/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor.test;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.FrameProcessors;
import org.apache.druid.frame.processor.ReturnOrAwait;

public class InfiniteFrameProcessor
implements FrameProcessor<Long> {
    private final Frame frame;
    private final WritableFrameChannel outChannel;
    private final AtomicBoolean stop = new AtomicBoolean(false);
    private final AtomicBoolean didCleanup = new AtomicBoolean(false);
    private final AtomicLong numFrames = new AtomicLong();

    public InfiniteFrameProcessor(Frame frame, WritableFrameChannel outChannel) {
        this.frame = frame;
        this.outChannel = outChannel;
    }

    public List<ReadableFrameChannel> inputChannels() {
        return Collections.emptyList();
    }

    public List<WritableFrameChannel> outputChannels() {
        return Collections.singletonList(this.outChannel);
    }

    public ReturnOrAwait<Long> runIncrementally(IntSet readableInputs) throws IOException {
        this.outChannel.write(this.frame);
        this.numFrames.incrementAndGet();
        if (this.stop.get()) {
            return ReturnOrAwait.returnObject((Object)this.numFrames.get());
        }
        return ReturnOrAwait.runAgain();
    }

    public void cleanup() throws IOException {
        FrameProcessors.closeAll(this.inputChannels(), this.outputChannels(), (Closeable[])new Closeable[0]);
        this.didCleanup.set(true);
    }

    public long getNumFrames() {
        return this.numFrames.get();
    }

    public void stop() {
        this.stop.set(true);
    }

    public boolean didCleanup() {
        return this.didCleanup.get();
    }
}

