/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Injector;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.guice.BuiltInTypesModule;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.StartupInjectorBuilder;
import org.apache.druid.segment.DefaultColumnFormatConfig;
import org.apache.druid.segment.DimensionHandlerProvider;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.NestedCommonFormatColumnHandler;
import org.apache.druid.segment.column.StringEncodingStrategy;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.ConciseBitmapSerdeFactory;
import org.apache.druid.segment.nested.NestedCommonFormatColumnFormatSpec;
import org.junit.AfterClass;
import org.junit.Test;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;

public class BuiltInTypesModuleTest {
    @Nullable
    private static DimensionHandlerProvider DEFAULT_HANDLER_PROVIDER;

    @BeforeAll
    public static void setup() {
        DEFAULT_HANDLER_PROVIDER = (DimensionHandlerProvider)DimensionHandlerUtils.DIMENSION_HANDLER_PROVIDERS.get("json");
        DimensionHandlerUtils.DIMENSION_HANDLER_PROVIDERS.remove("json");
    }

    @AfterEach
    public void beforeEach() {
        BuiltInTypesModule.setIndexSpecDefaults((IndexSpec)IndexSpec.builder().build());
    }

    @AfterClass
    public static void teardown() {
        if (DEFAULT_HANDLER_PROVIDER == null) {
            DimensionHandlerUtils.DIMENSION_HANDLER_PROVIDERS.remove("json");
        } else {
            DimensionHandlerUtils.DIMENSION_HANDLER_PROVIDERS.put("json", DEFAULT_HANDLER_PROVIDER);
        }
        BuiltInTypesModule.setIndexSpecDefaults((IndexSpec)IndexSpec.builder().build());
    }

    @Test
    public void testDefaults() {
        DimensionHandlerUtils.DIMENSION_HANDLER_PROVIDERS.remove("json");
        Properties props = new Properties();
        Injector gadget = this.makeInjector(props);
        gadget.getInstance(BuiltInTypesModule.SideEffectRegisterer.class);
        DimensionHandlerProvider provider = (DimensionHandlerProvider)DimensionHandlerUtils.DIMENSION_HANDLER_PROVIDERS.get("json");
        Assertions.assertInstanceOf(NestedCommonFormatColumnHandler.class, (Object)provider.get("test"));
        Assertions.assertEquals((Object)DimensionSchema.MultiValueHandling.SORTED_ARRAY, (Object)BuiltInTypesModule.getStringMultiValueHandlingMode());
    }

    @Test
    public void testOverride() {
        DimensionHandlerUtils.DIMENSION_HANDLER_PROVIDERS.remove("json");
        Properties props = new Properties();
        props.setProperty("druid.indexing.formats.stringMultiValueHandlingMode", "sorted_array");
        props.setProperty("druid.indexing.formats.indexSpec.complexMetricCompression", CompressionStrategy.LZ4.toString());
        props.setProperty("druid.indexing.formats.indexSpec.autoColumnFormatSpec.stringDictionaryEncoding.type", "frontCoded");
        props.setProperty("druid.indexing.formats.indexSpec.autoColumnFormatSpec.stringDictionaryEncoding.bucketSize", "16");
        props.setProperty("druid.indexing.formats.indexSpec.autoColumnFormatSpec.stringDictionaryEncoding.formatVersion", "1");
        props.setProperty("druid.indexing.formats.indexSpec.autoColumnFormatSpec.bitmapEncoding", "roaring");
        props.setProperty("druid.indexing.formats.indexSpec.metricCompression", CompressionStrategy.ZSTD.toString());
        props.setProperty("druid.indexing.formats.indexSpec.bitmap", "{\"type\":\"concise\"}");
        Injector gadget = this.makeInjector(props);
        gadget.getInstance(BuiltInTypesModule.SideEffectRegisterer.class);
        DimensionHandlerProvider provider = (DimensionHandlerProvider)DimensionHandlerUtils.DIMENSION_HANDLER_PROVIDERS.get("json");
        Assertions.assertEquals((Object)DimensionSchema.MultiValueHandling.SORTED_ARRAY, (Object)BuiltInTypesModule.getStringMultiValueHandlingMode());
        Assertions.assertEquals((Object)CompressionStrategy.LZ4, (Object)IndexSpec.getDefault().getComplexMetricCompression());
        Assertions.assertEquals((Object)NestedCommonFormatColumnFormatSpec.builder().setStringDictionaryEncoding((StringEncodingStrategy)new StringEncodingStrategy.FrontCoded(Integer.valueOf(16), Byte.valueOf((byte)1))).build(), (Object)IndexSpec.getDefault().getAutoColumnFormatSpec());
        Assertions.assertNull((Object)IndexSpec.getDefault().getAutoColumnFormatSpec().getBitmapEncoding());
        Assertions.assertEquals((Object)CompressionStrategy.ZSTD, (Object)IndexSpec.getDefault().getMetricCompression());
        Assertions.assertEquals((Object)new ConciseBitmapSerdeFactory(), (Object)IndexSpec.getDefault().getBitmapSerdeFactory());
    }

    @Test
    public void testOverrideMultiValueHandlingModeCaseInsensitive() {
        Properties props = new Properties();
        props.setProperty("druid.indexing.formats.stringMultiValueHandlingMode", "ARRAY");
        Injector gadget = this.makeInjector(props);
        gadget.getInstance(BuiltInTypesModule.SideEffectRegisterer.class);
        Assertions.assertEquals((Object)DimensionSchema.MultiValueHandling.ARRAY, (Object)BuiltInTypesModule.getStringMultiValueHandlingMode());
    }

    @Test
    public void testInvalidMultiValueHandlingMode() {
        Properties props = new Properties();
        props.setProperty("druid.indexing.formats.stringMultiValueHandlingMode", "boo");
        Injector gadget = this.makeInjector(props);
        Exception exception = (Exception)Assertions.assertThrows(Exception.class, () -> gadget.getInstance(BuiltInTypesModule.SideEffectRegisterer.class));
        Assertions.assertTrue((boolean)exception.getMessage().contains("Invalid value[boo] specified for 'druid.indexing.formats.stringMultiValueHandlingMode'. Supported values are [[SORTED_ARRAY, SORTED_SET, ARRAY]]."));
    }

    private Injector makeInjector(Properties props) {
        StartupInjectorBuilder bob = new StartupInjectorBuilder().forTests().withProperties(props);
        bob.addAll((List)ImmutableList.of(binder -> JsonConfigProvider.bind((Binder)binder, (String)"druid.indexing.formats", DefaultColumnFormatConfig.class), (Object)new BuiltInTypesModule()));
        return bob.build();
    }
}

