/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.google.inject.Injector;
import java.util.Collections;
import java.util.Properties;
import org.apache.druid.error.ExceptionMatcher;
import org.apache.druid.guice.DruidSecondaryModule;
import org.apache.druid.guice.ExtensionsConfig;
import org.apache.druid.guice.ExtensionsLoader;
import org.apache.druid.guice.ModulesConfig;
import org.apache.druid.guice.StartupInjectorBuilder;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.utils.RuntimeInfo;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class StartupInjectorBuilderTest {
    @Test
    public void testEmpty() {
        Injector injector = new StartupInjectorBuilder().build();
        Properties props = (Properties)injector.getInstance(Properties.class);
        Assert.assertNotNull((Object)props);
        Assert.assertTrue((boolean)props.isEmpty());
        Assert.assertNotSame((Object)props, (Object)injector.getInstance(Properties.class));
        Assert.assertNotNull((Object)injector.getInstance(RuntimeInfo.class));
        Assert.assertSame((Object)injector.getInstance(RuntimeInfo.class), (Object)injector.getInstance(RuntimeInfo.class));
        Assert.assertNotNull((Object)injector.getInstance(ExtensionsLoader.class));
        Assert.assertSame((Object)injector.getInstance(ExtensionsLoader.class), (Object)injector.getInstance(ExtensionsLoader.class));
        Assert.assertNotNull((Object)injector.getInstance(DruidSecondaryModule.class));
        Assert.assertSame((Object)injector.getInstance(DruidSecondaryModule.class), (Object)injector.getInstance(DruidSecondaryModule.class));
    }

    @Test
    public void testEmptyTestInjector() {
        Injector injector = new StartupInjectorBuilder().forTests().build();
        Properties props = (Properties)injector.getInstance(Properties.class);
        Assert.assertNotNull((Object)props);
        Assert.assertTrue((boolean)props.isEmpty());
        Assert.assertNotSame((Object)props, (Object)injector.getInstance(Properties.class));
        Assert.assertNull((Object)injector.getInstance(RuntimeInfo.class));
        Assert.assertNull((Object)injector.getInstance(ExtensionsLoader.class));
        Assert.assertNotNull((Object)injector.getInstance(DruidSecondaryModule.class));
        Assert.assertSame((Object)injector.getInstance(DruidSecondaryModule.class), (Object)injector.getInstance(DruidSecondaryModule.class));
    }

    @Test
    public void testEmptyProperties() {
        Injector injector = new StartupInjectorBuilder().withEmptyProperties().build();
        Properties props = (Properties)injector.getInstance(Properties.class);
        Assert.assertNotNull((Object)props);
        Assert.assertTrue((boolean)props.isEmpty());
        Assert.assertSame((Object)props, (Object)injector.getInstance(Properties.class));
    }

    @Test
    public void testExplicitProperties() {
        Properties props = new Properties();
        props.put("foo", "bar");
        Injector injector = new StartupInjectorBuilder().forTests().withProperties(props).build();
        Properties propsInstance = (Properties)injector.getInstance(Properties.class);
        Assert.assertSame((Object)props, (Object)propsInstance);
    }

    @Test
    public void testExtensionsOption() {
        Properties props = new Properties();
        props.put("druid.extensions.directory", "bogus");
        props.put("druid.modules.excludeList", "[\"excluded\"]");
        Injector injector = new StartupInjectorBuilder().withExtensions().withProperties(props).build();
        Assert.assertEquals((Object)"bogus", (Object)((ExtensionsConfig)injector.getInstance(ExtensionsConfig.class)).getDirectory());
        Assert.assertEquals(Collections.singletonList("excluded"), (Object)((ModulesConfig)injector.getInstance(ModulesConfig.class)).getExcludeList());
    }

    @Test
    public void testValidator() {
        Properties propsDefaultValueMode = new Properties();
        propsDefaultValueMode.put("druid.generic.useDefaultValueForNull", "true");
        Throwable t = Assert.assertThrows(ISE.class, () -> new StartupInjectorBuilder().withExtensions().withProperties(propsDefaultValueMode).build());
        Assert.assertEquals((Object)StringUtils.format((String)"druid.generic.useDefaultValueForNull set to 'true', but has been removed, see https://druid.apache.org/docs/%s/release-info/migr-ansi-sql-null for details for how to migrate to SQL compliant behavior", (Object[])new Object[]{StartupInjectorBuilder.getVersionString()}), (Object)t.getMessage());
        Properties propsNo3vl = new Properties();
        propsNo3vl.put("druid.generic.useThreeValueLogicForNativeFilters", "false");
        t = Assert.assertThrows(ISE.class, () -> new StartupInjectorBuilder().withExtensions().withProperties(propsNo3vl).build());
        Assert.assertEquals((Object)StringUtils.format((String)"druid.generic.useThreeValueLogicForNativeFilters set to 'false', but has been removed, see https://druid.apache.org/docs/%s/release-info/migr-ansi-sql-null for details for how to migrate to SQL compliant behavior", (Object[])new Object[]{StartupInjectorBuilder.getVersionString()}), (Object)t.getMessage());
        Properties propsNonStrictBooleans = new Properties();
        propsNonStrictBooleans.put("druid.expressions.useStrictBooleans", "false");
        t = Assert.assertThrows(ISE.class, () -> new StartupInjectorBuilder().withExtensions().withProperties(propsNonStrictBooleans).build());
        Assert.assertEquals((Object)StringUtils.format((String)"druid.expressions.useStrictBooleans set to 'false', but has been removed, see https://druid.apache.org/docs/%s/release-info/migr-ansi-sql-null for details for how to migrate to SQL compliant behavior", (Object[])new Object[]{StartupInjectorBuilder.getVersionString()}), (Object)t.getMessage());
    }

    @Test
    public void verifyInjectorBuild_withDeletedConfig_throwsException() {
        StartupInjectorBuilderTest.verifyInjectorBuild_withDeletedConfig_throwsException("druid.processing.merge.pool.parallelism", "10", "Config[druid.processing.merge.pool.parallelism] has been removed. Please use config[druid.processing.merge.parallelism] instead.");
        StartupInjectorBuilderTest.verifyInjectorBuild_withDeletedConfig_throwsException("druid.processing.merge.pool.awaitShutdownMillis", "1000", "Config[druid.processing.merge.pool.awaitShutdownMillis] has been removed. Please use config[druid.processing.merge.awaitShutdownMillis] instead.");
        StartupInjectorBuilderTest.verifyInjectorBuild_withDeletedConfig_throwsException("druid.processing.merge.pool.defaultMaxQueryParallelism", "100", "Config[druid.processing.merge.pool.defaultMaxQueryParallelism] has been removed. Please use config[druid.processing.merge.defaultMaxQueryParallelism] instead.");
        StartupInjectorBuilderTest.verifyInjectorBuild_withDeletedConfig_throwsException("druid.processing.merge.task.targetRunTimeMillis", "10", "Config[druid.processing.merge.task.targetRunTimeMillis] has been removed. Please use config[druid.processing.merge.targetRunTimeMillis] instead.");
        StartupInjectorBuilderTest.verifyInjectorBuild_withDeletedConfig_throwsException("druid.processing.merge.task.initialYieldNumRows", "1000", "Config[druid.processing.merge.task.initialYieldNumRows] has been removed. Please use config[druid.processing.merge.initialYieldNumRows] instead.");
        StartupInjectorBuilderTest.verifyInjectorBuild_withDeletedConfig_throwsException("druid.processing.merge.task.smallBatchNumRows", "100", "Config[druid.processing.merge.task.smallBatchNumRows] has been removed. Please use config[druid.processing.merge.smallBatchNumRows] instead.");
    }

    private static void verifyInjectorBuild_withDeletedConfig_throwsException(String removedProperty, String dummyValue, String expectedMessage) {
        Properties props = new Properties();
        props.setProperty(removedProperty, dummyValue);
        StartupInjectorBuilder builder = new StartupInjectorBuilder().withExtensions().withProperties(props);
        MatcherAssert.assertThat((Object)((ISE)Assert.assertThrows(ISE.class, () -> ((StartupInjectorBuilder)builder).build())), (Matcher)ExceptionMatcher.of(ISE.class).expectMessageIs(expectedMessage));
    }
}

